/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.STPMetadataSingleton;

class STPCompletionProcessor
implements IContentAssistProcessor {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'.'};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];

    STPCompletionProcessor() {
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        IDocument document = viewer.getDocument();
        int locationOffset = 0;
        try {
            prefix = this.completionWord(document, offset);
            locationOffset = this.completionReplaceWordLocation(document, offset);
        }
        catch (Exception exception) {
            return this.NO_COMPLETIONS;
        }
        if (locationOffset < 0) {
            return this.NO_COMPLETIONS;
        }
        String[] completionData = STPMetadataSingleton.getCompletionResults(prefix);
        if (completionData.length < 1) {
            return this.NO_COMPLETIONS;
        }
        ICompletionProposal[] result = new ICompletionProposal[completionData.length];
        int i = 0;
        while (i < completionData.length) {
            result[i] = new CompletionProposal(completionData[i].substring(offset - locationOffset), offset, 0, completionData[i].length(), null, completionData[i], null, null);
            ++i;
        }
        return result;
    }

    private int completionReplaceWordLocation(IDocument doc, int offset) throws BadLocationException {
        int n = offset - 1;
        while (n >= 0) {
            if (doc.getChar(n) == '.') {
                return n + 1;
            }
            --n;
        }
        return -1;
    }

    private String completionWord(IDocument doc, int offset) throws BadLocationException {
        int n = offset - 1;
        while (n >= 0) {
            char c = doc.getChar(n);
            if (Character.isSpaceChar(c) || c == '\n' || c == '\u0000') {
                String word = doc.get(n + 1, offset - n - 1);
                if (word.charAt(word.length() - 1) == '.') {
                    return word.substring(0, word.length() - 1);
                }
                return word;
            }
            --n;
        }
        return "";
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return "Error.";
    }
}

