/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.structures;

import java.util.ArrayList;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;

public final class StapErrorParser
implements IErrorParser {
    private static final int TYPE = 0;
    private static final int ERROR = 1;
    private static final int SAW = 2;
    private static final int LOCATION = 3;
    private static final int PASS = 4;

    public String[][] parseOutput(String output) {
        String[][] sErrors = null;
        ArrayList<String[]> errors = new ArrayList<String[]>();
        int errorType = 0;
        if (output != null) {
            String[] tokens = output.split("\\s");
            String[] row = null;
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].equals("error:")) {
                    row = new String[]{"", "", "", ""};
                    errors.add(row);
                    row[0] = String.valueOf(tokens[i - 1]) + " " + tokens[i];
                    errorType = 1;
                    ++i;
                } else if (tokens[i].equals("saw:")) {
                    errorType = 2;
                    ++i;
                } else if (tokens[i].equals("at")) {
                    errorType = 3;
                    ++i;
                } else if (tokens[i].equals("Pass")) {
                    errorType = 4;
                }
                if (row != null && errorType != 4) {
                    int n = errorType;
                    row[n] = String.valueOf(row[n]) + tokens[i] + " ";
                }
                ++i;
            }
            sErrors = new String[errors.size()][4];
            System.arraycopy(errors.toArray(), 0, sErrors, 0, errors.size());
            i = 0;
            while (i < sErrors.length) {
                sErrors[i][3] = StapErrorParser.fixLocation(sErrors[i][3]);
                ++i;
            }
        }
        return sErrors;
    }

    private static String fixLocation(String loc) {
        if (loc.contains(":")) {
            loc = loc.substring(loc.indexOf(58) + 1, loc.lastIndexOf(58));
            return loc;
        }
        return "";
    }
}

