/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.editors.stp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.linuxtools.systemtap.ui.editor.ColorManager;
import org.eclipse.linuxtools.systemtap.ui.editor.SimpleEditor;
import org.eclipse.linuxtools.systemtap.ui.ide.editors.stp.STPConfiguration;
import org.eclipse.linuxtools.systemtap.ui.ide.editors.stp.STPDocumentProvider;
import org.eclipse.linuxtools.systemtap.ui.ide.editors.stp.STPMetadataSingleton;
import org.eclipse.linuxtools.systemtap.ui.ide.internal.IDEPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STPEditor
extends SimpleEditor {
    private ColorManager colorManager;
    private ProjectionSupport stpProjectionSupport;
    private Annotation[] stpOldAnnotations;
    private ProjectionAnnotationModel stpAnnotationModel;

    public STPEditor() {
        URL completionURL = null;
        completionURL = this.buildCompletionDataLocation("completion/stp_completion.properties");
        STPMetadataSingleton completionDataStore = STPMetadataSingleton.getInstance();
        if (completionURL != null) {
            completionDataStore.build(completionURL);
        }
        this.colorManager = new ColorManager();
        this.setSourceViewerConfiguration(new STPConfiguration(this.colorManager, this));
        this.setDocumentProvider((IDocumentProvider)new STPDocumentProvider());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        this.stpProjectionSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        this.stpProjectionSupport.install();
        viewer.doOperation(19);
        this.stpAnnotationModel = viewer.getProjectionAnnotationModel();
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    public void updateFoldingStructure(ArrayList<Position> updatedPositions) {
        Annotation[] updatedAnnotations = new Annotation[updatedPositions.size()];
        HashMap<ProjectionAnnotation, Position> newAnnotations = new HashMap<ProjectionAnnotation, Position>();
        int i = 0;
        while (i < updatedPositions.size()) {
            ProjectionAnnotation annotation = new ProjectionAnnotation();
            newAnnotations.put(annotation, updatedPositions.get(i));
            updatedAnnotations[i] = annotation;
            ++i;
        }
        this.stpAnnotationModel.modifyAnnotations(this.stpOldAnnotations, newAnnotations, null);
        this.stpOldAnnotations = updatedAnnotations;
    }

    protected void createActions() {
        ContentAssistAction action = new ContentAssistAction(ResourceBundle.getBundle("org.eclipse.linuxtools.systemtap.ui.ide.editors.stp.strings"), "ContentAssistProposal.", (ITextEditor)this);
        String id = "org.eclipse.ui.edit.text.contentAssist.proposals";
        action.setActionDefinitionId(id);
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        super.createActions();
    }

    public ISourceViewer getMySourceViewer() {
        return this.getSourceViewer();
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addAction(menu, "group.edit", "ShiftRight");
        this.addAction(menu, "group.edit", "ShiftLeft");
    }

    private URL buildCompletionDataLocation(String completionDataLocation) {
        URL completionURLLocation = null;
        try {
            completionURLLocation = this.getCompletionURL(completionDataLocation);
        }
        catch (IOException iOException) {
            completionURLLocation = null;
        }
        if (completionURLLocation == null) {
            IDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", 0, "Cannot locate plug-in location for System Tap completion metadata (completion/stp_completion.properties). Completions are not available.", null));
            return null;
        }
        File completionFile = new File(completionURLLocation.getFile());
        if (completionFile == null || !completionFile.exists() || !completionFile.canRead()) {
            IDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.systemtap.ui.ide", 0, "Cannot find System Tap completion metadata at  " + completionFile.getPath() + "Completions are not available.", null));
            return null;
        }
        return completionURLLocation;
    }

    private URL getCompletionURL(String completionLocation) throws IOException {
        URL fileURL = null;
        URL location = IDEPlugin.getDefault().getBundle().getEntry(completionLocation);
        if (location != null) {
            fileURL = FileLocator.toFileURL((URL)location);
        }
        return fileURL;
    }
}

