/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.linuxtools.internal.callgraph.core.Messages;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class FileFinderOpener {
    private static HashMap<String, int[]> map = new HashMap();

    public static void findAndOpen(ICProject project, String functionName) {
        if (project == null) {
            return;
        }
        map = ProfileUIUtils.findFunctionsInProject((ICProject)project, (String)functionName, (int)-1, null);
        ArrayList<String> files = new ArrayList<String>(map.keySet());
        if (files == null || files.size() < 1) {
            return;
        }
        if (files.size() == 1) {
            FileFinderOpener.open(files.get(0), map.get(files.get(0))[0], map.get(files.get(0))[1]);
        } else {
            ElementListSelectionDialog d = new ElementListSelectionDialog(new Shell(), (ILabelProvider)new LabelProvider());
            d.setTitle(Messages.getString("FileFinderOpener.MultipleFilesDialog"));
            d.setMessage(String.valueOf(Messages.getString("FileFinderOpener.MultFilesDialogM1")) + functionName + Messages.getString("FileFinderOpener.MultFilesDialogM2") + Messages.getString("FileFinderOpener.MultFilesDialogM3"));
            d.setElements(files.toArray());
            d.open();
            if (d.getResult() == null) {
                return;
            }
            Object[] objectArray = d.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof String) {
                    String s = (String)o;
                    FileFinderOpener.open(s, map.get(s)[0], map.get(s)[1]);
                }
                ++n2;
            }
        }
    }

    public static void open(String path, int offset, int length) {
        if (path == null) {
            return;
        }
        try {
            ProfileUIUtils.openEditorAndSelect((String)path, (int)offset, (int)length);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }
}

