/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.Directive;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IConditional;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.Parent;

public abstract class Conditional
extends Parent
implements IConditional {
    private static final String EMPTY = "";
    String cond;
    String arg1;
    String arg2;

    public Conditional(Directive parent, String conditional) {
        super(parent);
        this.cond = conditional;
        this.parse();
    }

    public Conditional(Directive parent) {
        this(parent, EMPTY, EMPTY, EMPTY);
    }

    public Conditional(Directive parent, String conditional, String argument1, String argument2) {
        super(parent);
        this.arg1 = argument1;
        this.arg2 = argument2;
        this.cond = conditional;
    }

    public String getConditional() {
        return this.cond;
    }

    public String getArg1() {
        return this.arg1;
    }

    public String getArg2() {
        return this.arg2;
    }

    public boolean isIf() {
        return false;
    }

    public boolean isIfdef() {
        return false;
    }

    public boolean isIfndef() {
        return false;
    }

    public boolean isIfeq() {
        return false;
    }

    public boolean isIfneq() {
        return false;
    }

    public boolean isElse() {
        return false;
    }

    public boolean isEndif() {
        return false;
    }

    protected void parse() {
        char ch;
        int paren;
        char terminal;
        String line = this.getConditional().trim();
        char c = terminal = line.charAt(0) == '(' ? (char)',' : (char)line.charAt(0);
        if (line.length() < 5 && terminal != ',' && terminal != '\"' && terminal != '\'') {
            this.arg2 = EMPTY;
            this.arg1 = EMPTY;
            return;
        }
        int count = 0;
        if (terminal == ',') {
            paren = 0;
            count = 1;
            while (count < line.length()) {
                ch = line.charAt(count);
                if (ch == '(') {
                    ++paren;
                } else if (ch == ')') {
                    --paren;
                }
                if (ch != terminal || paren > 0) {
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            count = 1;
            while (count < line.length()) {
                if (line.charAt(count) != terminal) {
                    ++count;
                    continue;
                }
                break;
            }
        }
        if (count >= line.length()) {
            this.arg2 = EMPTY;
            this.arg1 = EMPTY;
            return;
        }
        this.arg1 = line.substring(1, count);
        line = line.substring(count + 1).trim();
        char c2 = terminal = terminal == ',' ? (char)')' : (char)line.charAt(0);
        if (terminal != ')' && terminal != '\"' && terminal != '\'') {
            this.arg2 = EMPTY;
            return;
        }
        count = 0;
        if (terminal == ')') {
            paren = 0;
            count = 0;
            while (count < line.length()) {
                ch = line.charAt(count);
                if (ch == '(') {
                    ++paren;
                } else if (ch == ')') {
                    --paren;
                }
                if (ch != terminal || paren > 0) {
                    ++count;
                    continue;
                }
                break;
            }
        } else {
            count = 1;
            while (count < line.length()) {
                if (line.charAt(count) != terminal) {
                    ++count;
                    continue;
                }
                break;
            }
        }
        this.arg2 = count > line.length() ? EMPTY : line.substring(0, count);
    }
}

