/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.autotools.core;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.linuxtools.internal.cdt.autotools.core.AutotoolsConfigurationBuilder;

public class AutotoolsNewProjectNature
implements IProjectNature {
    public static final String AUTOTOOLS_NATURE_ID = String.valueOf(AutotoolsPlugin.getUniqueIdentifier()) + ".autotoolsNatureV2";
    public static final String OLD_AUTOTOOLS_NATURE_ID = "org.eclipse.linuxtools.cdt.autotools.autotoolsNature";
    public static final String BUILDER_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".genmakebuilder";
    public static final String OLD_AUTOTOOLS_BUILDER_ID = "org.eclipse.linuxtools.cdt.autotools.genmakebuilder";
    private IProject project;

    public void configure() throws CoreException {
        AutotoolsNewProjectNature.addAutotoolsBuilder(this.project, (IProgressMonitor)new NullProgressMonitor());
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void addAutotoolsBuilder(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        ArrayList<ICommand> commandList = new ArrayList<ICommand>();
        int i = 0;
        while (i < commands.length) {
            ICommand command = commands[i];
            if (!command.getBuilderName().equals(AutotoolsConfigurationBuilder.BUILDER_ID)) {
                ICommand newCommand;
                if (command.getBuilderName().equals(OLD_AUTOTOOLS_BUILDER_ID)) {
                    newCommand = description.newCommand();
                    newCommand.setBuilderName(BUILDER_ID);
                    command = newCommand;
                }
                if (command.getBuilderName().equals(BUILDER_ID)) {
                    newCommand = description.newCommand();
                    newCommand.setBuilderName(AutotoolsConfigurationBuilder.BUILDER_ID);
                    commandList.add(newCommand);
                }
                commandList.add(command);
            }
            ++i;
        }
        ICommand[] newCommands = commandList.toArray(new ICommand[commandList.size()]);
        if (newCommands.length == commands.length) {
            boolean hasCorrectBuilderCommands = true;
            int j = 0;
            while (j < commands.length) {
                if (!commands[j].getBuilderName().equals(newCommands[j].getBuilderName())) {
                    hasCorrectBuilderCommands = false;
                    break;
                }
                ++j;
            }
            if (hasCorrectBuilderCommands) {
                return;
            }
        }
        IWorkspaceRoot rule = ResourcesPlugin.getWorkspace().getRoot();
        IProject proj = project;
        Job backgroundJob = new Job("Autotools Set Project Description", (ISchedulingRule)rule, proj, newCommands){
            private final /* synthetic */ ISchedulingRule val$rule;
            private final /* synthetic */ IProject val$proj;
            private final /* synthetic */ ICommand[] val$newCommands;
            {
                this.val$rule = iSchedulingRule;
                this.val$proj = iProject;
                this.val$newCommands = iCommandArray;
                super($anonymous0);
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){
                        protected boolean savedAutoBuildingValue;

                        public void run(IProgressMonitor monitor) throws CoreException {
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            this.turnOffAutoBuild(workspace);
                            IProjectDescription description = val$proj.getDescription();
                            description.setBuildSpec(val$newCommands);
                            val$proj.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                            this.restoreAutoBuild(workspace);
                        }

                        protected final void turnOffAutoBuild(IWorkspace workspace) throws CoreException {
                            IWorkspaceDescription workspaceDesc = workspace.getDescription();
                            this.savedAutoBuildingValue = workspaceDesc.isAutoBuilding();
                            workspaceDesc.setAutoBuilding(false);
                            workspace.setDescription(workspaceDesc);
                        }

                        protected final void restoreAutoBuild(IWorkspace workspace) throws CoreException {
                            IWorkspaceDescription workspaceDesc = workspace.getDescription();
                            workspaceDesc.setAutoBuilding(this.savedAutoBuildingValue);
                            workspace.setDescription(workspaceDesc);
                        }
                    }, this.val$rule, 1, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                IStatus returnStatus = Status.OK_STATUS;
                return returnStatus;
            }
        };
        backgroundJob.setRule((ISchedulingRule)rule);
        backgroundJob.schedule();
    }

    public static void addAutotoolsNature(IProject project, IProgressMonitor monitor) throws CoreException {
        AutotoolsNewProjectNature.addNature(project, AUTOTOOLS_NATURE_ID, monitor);
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int i = 0;
        while (i < prevNatures.length) {
            if (natureId.equals(prevNatures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static void removeAutotoolsNature(IProject project, IProgressMonitor mon) throws CoreException {
        AutotoolsNewProjectNature.removeNature(project, AUTOTOOLS_NATURE_ID, mon);
    }

    public static void removeOldAutotoolsNature(IProject project, IProgressMonitor mon) throws CoreException {
        AutotoolsNewProjectNature.removeNature(project, OLD_AUTOTOOLS_NATURE_ID, mon);
    }

    public static void removeNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        ArrayList<String> newNatures = new ArrayList<String>(Arrays.asList(prevNatures));
        newNatures.remove(natureId);
        description.setNatureIds(newNatures.toArray(new String[newNatures.size()]));
        project.setDescription(description, monitor);
    }
}

