/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.Serializer;
import org.eclipse.birt.chart.model.impl.SerializerImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.linuxtools.dataviewers.charts.Activator;
import org.eclipse.linuxtools.dataviewers.charts.UIHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;

public class SaveXMLAction
extends Action {
    private Composite cmp;
    private Chart cm;

    public SaveXMLAction(Composite parent) {
        this.cmp = parent;
        this.setImageDescriptor(UIHelper.getImageDescriptor("icons/eexport.gif"));
        this.setDisabledImageDescriptor(UIHelper.getImageDescriptor("icons/dexport.gif"));
        this.setToolTipText("Save XML Source");
        this.setDescription("Save XML Source to the designated directory");
    }

    public void run() {
        block9: {
            if (this.cm != null) {
                FileDialog saveDialog = new FileDialog(this.cmp.getShell(), 8192);
                saveDialog.setFilterExtensions(new String[]{"*.chart"});
                try {
                    saveDialog.open();
                    String name = saveDialog.getFileName();
                    if (name == null || name == "") break block9;
                    Serializer serializer = null;
                    File file = new File(saveDialog.getFilterPath(), name);
                    if (file.exists()) {
                        MessageBox box = new MessageBox(this.cmp.getShell(), 200);
                        box.setText("Save XML Source");
                        box.setMessage("The XML source already exists in the directory. \nDo you want to replace it?");
                        if (box.open() != 64) {
                            return;
                        }
                    }
                    serializer = SerializerImpl.instance();
                    try {
                        serializer.write(this.cm, (OutputStream)new FileOutputStream(file));
                        IFile c = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
                        if (c == null) break block9;
                        try {
                            c.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            Status status = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", e.getMessage(), (Throwable)e);
                            Activator.getDefault().getLog().log((IStatus)status);
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setChart(Chart chart) {
        try {
            if (chart != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.cm = chart;
        }
        catch (Throwable _) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, "Error when creating \"save as image\" action...", _);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }
}

