/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.bugs.AbstractSupportElement;
import org.eclipse.mylyn.internal.tasks.bugs.AttributeTaskMapper;
import org.eclipse.mylyn.internal.tasks.bugs.SupportCategory;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProduct;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProvider;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProviderManager;
import org.eclipse.mylyn.internal.tasks.bugs.SupportRequest;
import org.eclipse.mylyn.internal.tasks.bugs.TaskErrorReporter;
import org.eclipse.mylyn.internal.tasks.bugs.TasksBugsPlugin;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.ProductStatus;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.SelectSupportElementPage;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.bugs.IProduct;
import org.eclipse.mylyn.tasks.bugs.IProvider;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;

public class ReportBugOrEnhancementWizard
extends Wizard {
    private SupportContentProvider contentProvider;
    private boolean inFinish;

    public ReportBugOrEnhancementWizard() {
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ReportBugOrEnhancementWizard_Report_Bug_or_Enhancement);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPORT_BUG);
    }

    public void addPages() {
        this.contentProvider = new SupportContentProvider();
        SelectSupportElementPage page = new SelectSupportElementPage("selectProvider", this.contentProvider);
        page.setInput(new Object());
        this.addPage((IWizardPage)page);
    }

    public boolean canFinish() {
        return this.getSelectedElement() instanceof SupportProduct;
    }

    public AbstractSupportElement getSelectedElement() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page != null) {
            Object[] elements;
            AbstractSupportElement element = ((SelectSupportElementPage)page).getSelectedElement();
            if (!(element instanceof SupportProduct) && (elements = this.contentProvider.getElements(element)).length == 1) {
                return (AbstractSupportElement)elements[0];
            }
            return element;
        }
        return null;
    }

    public boolean performFinish() {
        AbstractSupportElement product = this.getSelectedElement();
        if (!(product instanceof SupportProduct) || this.inFinish) {
            return false;
        }
        try {
            this.inFinish = true;
            TaskErrorReporter reporter = TasksBugsPlugin.getTaskErrorReporter();
            ProductStatus status = new ProductStatus((IProduct)((Object)product));
            SupportRequest request = reporter.preProcess((IStatus)status, status.getProduct());
            if (!((AttributeTaskMapper)request.getDefaultContribution()).isMappingComplete()) {
                TasksUiInternal.displayStatus((String)Messages.ReportBugOrEnhancementWizard_Report_Bug_or_Enhancement, (IStatus)new Status(4, "org.eclipse.mylyn.tasks.bugs", Messages.ReportBugOrEnhancementWizard_Support_request_faild_Information_incomplete_Error));
                return false;
            }
            boolean bl = reporter.process(request.getDefaultContribution(), (IRunnableContext)this.getContainer());
            return bl;
        }
        finally {
            this.inFinish = false;
        }
    }

    private class SupportContentProvider
    implements IStructuredContentProvider {
        private SupportProviderManager providerManager;
        private Object input;

        private SupportContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof SupportProvider) {
                List<SupportProduct> providerProducts = this.getProducts((SupportProvider)inputElement);
                return providerProducts.toArray();
            }
            if (this.input == inputElement) {
                ArrayList<AbstractSupportElement> elements = new ArrayList<AbstractSupportElement>();
                Collection<SupportCategory> categories = this.providerManager.getCategories();
                for (SupportCategory category : categories) {
                    List<IProvider> providers = category.getProviders();
                    ArrayList<IProvider> validProviders = new ArrayList<IProvider>();
                    for (IProvider provider : providers) {
                        if (!this.isValid((SupportProvider)provider)) continue;
                        validProviders.add(provider);
                    }
                    if (validProviders.isEmpty()) continue;
                    elements.add(category);
                    for (IProvider provider : validProviders) {
                        elements.add((AbstractSupportElement)((Object)provider));
                    }
                }
                return elements.toArray();
            }
            return new Object[0];
        }

        private boolean isValid(SupportProvider provider) {
            Collection<SupportProduct> products = this.providerManager.getProducts();
            for (SupportProduct product : products) {
                if (!provider.equals(product.getProvider()) || !product.isInstalled()) continue;
                return true;
            }
            return false;
        }

        private List<SupportProduct> getProducts(SupportProvider provider) {
            Collection<SupportProduct> products = this.providerManager.getProducts();
            ArrayList<SupportProduct> providerProducts = new ArrayList<SupportProduct>();
            for (SupportProduct product : products) {
                if (!provider.equals(product.getProvider()) || !product.isInstalled()) continue;
                providerProducts.add(product);
            }
            return providerProducts;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput;
            this.providerManager = TasksBugsPlugin.getTaskErrorReporter().getProviderManager();
        }
    }
}

