/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.telnet.controls;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.internal.terminal.provisional.api.AbstractSettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetConnector;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetSettings;
import org.eclipse.tm.terminal.connector.telnet.connector.TelnetSettingsPage;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.panels.AbstractExtendedConfigurationPanel;

public class TelnetWizardConfigurationPanel
extends AbstractExtendedConfigurationPanel {
    public TelnetSettings telnetSettings;
    private ISettingsPage telnetSettingsPage;

    public TelnetWizardConfigurationPanel(IConfigurationPanelContainer container) {
        super(container);
    }

    public void setupPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        panel.setLayoutData((Object)data);
        if (this.isWithoutSelection()) {
            this.createHostsUI(panel, true);
        }
        TelnetConnector conn = new TelnetConnector();
        this.telnetSettings = (TelnetSettings)conn.getTelnetSettings();
        this.telnetSettings.setHost(this.getSelectionHost());
        this.telnetSettings.setNetworkPort("23");
        this.telnetSettingsPage = new TelnetSettingsPage(this.telnetSettings);
        if (this.telnetSettingsPage instanceof AbstractSettingsPage) {
            ((AbstractSettingsPage)this.telnetSettingsPage).setHasControlDecoration(true);
        }
        this.telnetSettingsPage.createControl(panel);
        this.telnetSettingsPage.addListener(control -> {
            if (this.getContainer() != null) {
                this.getContainer().validate();
            }
        });
        this.createEncodingUI(panel, true);
        this.setControl(panel);
    }

    public void setupData(Map<String, Object> data) {
        Object v;
        if (data == null || this.telnetSettings == null || this.telnetSettingsPage == null) {
            return;
        }
        String value = (String)data.get("ip.host");
        if (value != null) {
            this.telnetSettings.setHost(value);
        }
        String string = value = (v = data.get("ip.port")) != null ? v.toString() : null;
        if (value != null) {
            this.telnetSettings.setNetworkPort(value);
        }
        String string2 = value = (v = data.get("timeout")) != null ? v.toString() : null;
        if (value != null) {
            this.telnetSettings.setTimeout(value);
        }
        String string3 = value = (v = data.get("telnet.eol")) != null ? v.toString() : null;
        if (value != null) {
            this.telnetSettings.setEndOfLine(value);
        }
        if ((value = (String)data.get("encoding")) != null) {
            this.setEncoding(value);
        }
        this.telnetSettingsPage.loadSettings();
    }

    public void extractData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        data.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.telnet.TelnetConnector");
        this.telnetSettingsPage.saveSettings();
        data.put("ip.host", this.telnetSettings.getHost());
        data.put("ip.port", this.telnetSettings.getNetworkPort());
        data.put("timeout", this.telnetSettings.getTimeout());
        data.put("telnet.eol", this.telnetSettings.getEndOfLine());
        data.put("encoding", this.getEncoding());
    }

    protected void fillSettingsForHost(String host) {
        if (host != null && host.length() != 0) {
            if (this.hostSettingsMap.containsKey(host)) {
                Map hostSettings = (Map)this.hostSettingsMap.get(host);
                if (hostSettings.get("ip.host") != null) {
                    this.telnetSettings.setHost((String)hostSettings.get("ip.host"));
                }
                if (hostSettings.get("ip.port") != null) {
                    this.telnetSettings.setNetworkPort((String)hostSettings.get("ip.port"));
                }
                if (hostSettings.get("timeout") != null) {
                    this.telnetSettings.setTimeout((String)hostSettings.get("timeout"));
                }
                if (hostSettings.get("telnet.eol") != null) {
                    this.telnetSettings.setEndOfLine((String)hostSettings.get("telnet.eol"));
                }
                if (hostSettings.get("encoding") != null) {
                    this.setEncoding((String)hostSettings.get("encoding"));
                }
            } else {
                this.telnetSettings.setHost(this.getSelectionHost());
                this.telnetSettings.setNetworkPort("23");
            }
            this.telnetSettingsPage.loadSettings();
        }
    }

    protected void saveSettingsForHost(boolean add) {
        String host = this.getHostFromSettings();
        if (host != null && host.length() != 0) {
            HashMap<String, String> hostSettings = (HashMap<String, String>)this.hostSettingsMap.get(host);
            if (hostSettings == null && add) {
                hostSettings = new HashMap<String, String>();
                this.hostSettingsMap.put(host, hostSettings);
            }
            if (hostSettings != null) {
                hostSettings.put("ip.host", this.telnetSettings.getHost());
                hostSettings.put("ip.port", Integer.toString(this.telnetSettings.getNetworkPort()));
                hostSettings.put("timeout", Integer.toString(this.telnetSettings.getTimeout()));
                hostSettings.put("telnet.eol", this.telnetSettings.getEndOfLine());
                if (this.getEncoding() != null) {
                    hostSettings.put("encoding", this.getEncoding());
                }
            }
        }
    }

    public boolean isValid() {
        return this.isEncodingValid() && this.telnetSettingsPage.validateSettings();
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        this.saveSettingsForHost(true);
        super.doSaveWidgetValues(settings, idPrefix);
    }

    protected String getHostFromSettings() {
        this.telnetSettingsPage.saveSettings();
        return this.telnetSettings.getHost();
    }
}

