/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.util.widget;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public final class UiBuilder<T extends Control> {
    private final T control;

    private UiBuilder(T control) {
        this.control = (Control)Preconditions.checkNotNull(control);
    }

    public T control() {
        return this.control;
    }

    public UiBuilder<T> alignLeft() {
        this.control.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        return this;
    }

    public UiBuilder<T> alignLeft(int horizontalSpan) {
        this.control.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, horizontalSpan, 1));
        return this;
    }

    public UiBuilder<T> alignRight() {
        this.control.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        return this;
    }

    public UiBuilder<T> alignFillHorizontal() {
        this.control.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        return this;
    }

    public UiBuilder<T> alignFillBoth(int horizontalSpan) {
        this.control.setLayoutData((Object)new GridData(4, 4, true, true, horizontalSpan, 1));
        return this;
    }

    public UiBuilder<T> enabled() {
        this.control.setEnabled(true);
        return this;
    }

    public UiBuilder<T> disabled() {
        this.control.setEnabled(false);
        return this;
    }

    public UiBuilder<T> font(Font font) {
        this.control.setFont(font);
        return this;
    }

    public UiBuilder<T> text(String text) {
        text = Strings.nullToEmpty((String)text);
        T control = this.control();
        if (control instanceof Label) {
            ((Label)control).setText(text);
        } else if (control instanceof Text) {
            ((Text)control).setText(text);
        } else if (control instanceof Button) {
            ((Button)control).setText(text);
        } else if (control instanceof Combo) {
            ((Combo)control).setText(text);
        } else if (control instanceof Group) {
            ((Group)control).setText(text);
        } else {
            throw new IllegalStateException(String.format("Cannot set text on control of type %s.", this.control().getClass()));
        }
        return this;
    }

    public static final class UiBuilderFactory {
        private final Optional<Font> defaultFont;

        public UiBuilderFactory(Font font) {
            this.defaultFont = Optional.of((Object)font);
        }

        public UiBuilder<Label> newLabel(Composite parent) {
            UiBuilder<Label> builder = new UiBuilder<Label>(new Label(parent, 0));
            this.init(builder);
            return builder;
        }

        public UiBuilder<Text> newText(Composite parent) {
            UiBuilder<Text> builder = new UiBuilder<Text>(new Text(parent, 2048));
            this.init(builder);
            return builder;
        }

        public UiBuilder<Button> newButton(Composite parent) {
            UiBuilder<Button> builder = new UiBuilder<Button>(new Button(parent, 8));
            this.init(builder);
            return builder;
        }

        public UiBuilder<Button> newRadio(Composite parent) {
            UiBuilder<Button> builder = new UiBuilder<Button>(new Button(parent, 16));
            this.init(builder);
            return builder;
        }

        public UiBuilder<Button> newCheckbox(Composite parent) {
            UiBuilder<Button> builder = new UiBuilder<Button>(new Button(parent, 32));
            this.init(builder);
            return builder;
        }

        public UiBuilder<Combo> newCombo(Composite parent) {
            UiBuilder<Combo> builder = new UiBuilder<Combo>(new Combo(parent, 0));
            this.init(builder);
            return builder;
        }

        public UiBuilder<Tree> newTree(Composite parent) {
            UiBuilder<Tree> builder = new UiBuilder<Tree>(new Tree(parent, 0));
            this.init(builder);
            return builder;
        }

        public UiBuilder<Group> newGroup(Composite parent) {
            UiBuilder<Group> builder = new UiBuilder<Group>(new Group(parent, 0));
            this.init(builder);
            return builder;
        }

        public void span(Composite parent) {
            Label label = new Label(parent, 0);
            GridData data = new GridData(0, 0);
            label.setLayoutData((Object)data);
            this.init((Control)label);
            label.setVisible(false);
        }

        private void init(UiBuilder<?> builder) {
            this.init((Control)builder.control());
        }

        private void init(Control control) {
            if (this.defaultFont.isPresent()) {
                control.setFont((Font)this.defaultFont.get());
            }
        }
    }
}

