/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;

public class SocketTimeoutRetryInputStream
extends FilterInputStream {
    public static int read(InputStream inputStream) throws IOException {
        while (true) {
            try {
                return inputStream.read();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public static int read(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (true) {
            try {
                return inputStream.read(byArray, n, n2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public static int read(InputStream inputStream, byte[] byArray) throws IOException {
        while (true) {
            try {
                return inputStream.read(byArray);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public int available() throws IOException {
        while (true) {
            try {
                return this.in.available();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void close() throws IOException {
        while (true) {
            try {
                this.in.close();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public void mark(int n) {
        this.in.mark(n);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        return SocketTimeoutRetryInputStream.read(this.in);
    }

    public int read(byte[] byArray) throws IOException {
        return SocketTimeoutRetryInputStream.read(this.in, byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return SocketTimeoutRetryInputStream.read(this.in, byArray, n, n2);
    }

    public void reset() throws IOException {
        while (true) {
            try {
                this.in.reset();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    public long skip(long l) throws IOException {
        while (true) {
            try {
                return this.in.skip(l);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            break;
        }
    }

    SocketTimeoutRetryInputStream(InputStream inputStream) {
        super(inputStream);
    }
}

