/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.ui.editors.ooo;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.XSystemChildFactory;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XDrawView;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFrames;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sheet.XSpreadsheetView;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import java.io.File;
import java.io.IOException;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.ODFParser;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.util.ODFFileUtils;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.BootstrapForOOoComposite;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.ODFException;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.ODFUtils;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.OOoNavigation;
import org.eclipse.actf.model.internal.ui.editors.ooo.util.OOoUIControls;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.NodeList;

public class OOoWindowComposite
extends Composite {
    public static final int ACTION_SCROLL_DECREMENT_LINE = 0;
    public static final int ACTION_SCROLL_INCREMENT_LINE = 1;
    public static final int ACTION_SCROLL_DECREMENT_BLOCK = 2;
    public static final int ACTION_SCROLL_INCREMENT_BLOCK = 3;
    private XDesktop xDesktop = null;
    private XMultiServiceFactory xMSF = null;
    private OOoWindow oooWin = null;
    private XFrame xFrame = null;
    private XComponent xComponent = null;
    private XAccessibleAction[] scrollAction = null;
    private String _url = null;
    private OOoNavigation oooNavigation = null;

    public OOoWindowComposite(Composite composite, int n) throws ODFException {
        super(composite, n);
        this.init();
        this.addControlListener(new OOoWindowControlListener());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                OOoWindowComposite.this.dispose();
            }
        });
    }

    public void init() throws ODFException {
        try {
            ClassLoader classLoader = ODFUtils.loadOpenOfficeLibs();
            BootstrapForOOoComposite.bootstrap(classLoader);
            this.xMSF = BootstrapForOOoComposite.getXMultiServiceFactory();
            this.xDesktop = BootstrapForOOoComposite.getXDesktop();
        }
        catch (BootstrapException bootstrapException) {
            throw new ODFException(bootstrapException.getMessage());
        }
    }

    public void dispose() {
        super.dispose();
        this.xMSF = null;
        if (this.oooWin != null) {
            this.oooWin.dispose();
        }
        if (this.xFrame != null) {
            this.closeFrame();
        }
        this.xFrame = null;
        this.xComponent = null;
        if (this.xDesktop != null && ODFUtils.getOpenOfficeFrameNum() == 0) {
            this.dispathMessageThread(new Runnable(){

                public void run() {
                    try {
                        OOoWindowComposite.this.xDesktop.terminate();
                    }
                    catch (DisposedException disposedException) {}
                }
            });
        }
        this.xDesktop = null;
        if (this.scrollAction != null) {
            int n = 0;
            while (n < this.scrollAction.length) {
                this.scrollAction[n] = null;
                ++n;
            }
        }
        this.scrollAction = null;
    }

    public void dispathMessageThread(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
        Display display = Display.getDefault();
        while (thread.isAlive()) {
            display.readAndDispatch();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private void closeFrame() {
        if (this.xFrame != null) {
            this.dispathMessageThread(new Runnable(){

                public void run() {
                    XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)OOoWindowComposite.this.xFrame);
                    if (xCloseable != null) {
                        try {
                            xCloseable.close(true);
                        }
                        catch (CloseVetoException closeVetoException) {
                            closeVetoException.printStackTrace();
                        }
                    } else {
                        XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)OOoWindowComposite.this.xFrame);
                        if (xComponent != null) {
                            xComponent.dispose();
                        }
                    }
                }
            });
            this.xFrame = null;
            this.xComponent = null;
        }
    }

    private void load(String string) {
        Object object;
        Object object2;
        if (string.indexOf("private:") != 0 && string.indexOf("file:///") != 0) {
            try {
                object2 = new File(string);
                object = new StringBuffer("file:///");
                ((StringBuffer)object).append(((File)object2).getCanonicalPath().replace('\\', '/'));
                string = ((StringBuffer)object).toString();
                if (!((File)object2).canRead()) {
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
        object2 = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.xFrame);
        try {
            object = new PropertyValue[]{new PropertyValue()};
            object[0].Name = "ReadOnly";
            ((PropertyValue)object[0]).Value = Boolean.TRUE;
            this.xComponent = object2.loadComponentFromURL(string, this.xFrame.getName(), 23, (PropertyValue[])object);
            this.oooNavigation = new OOoNavigation(this.xMSF, this.xComponent);
        }
        catch (Exception exception) {
            this.xComponent = null;
        }
    }

    private XAccessible findXAccessibleByRole(XAccessible xAccessible, short s) {
        XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
        if (xAccessible.getAccessibleContext().getAccessibleRole() == s) {
            return xAccessible;
        }
        int n = 0;
        while (n < xAccessibleContext.getAccessibleChildCount()) {
            XAccessible xAccessible2 = null;
            try {
                xAccessible2 = xAccessibleContext.getAccessibleChild(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
            XAccessible xAccessible3 = this.findXAccessibleByRole(xAccessible2, s);
            if (xAccessible3 != null) {
                return xAccessible3;
            }
            ++n;
        }
        return null;
    }

    private XAccessibleAction[] findScrollAction() {
        XWindow xWindow = this.oooWin.getXWindow();
        XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)xWindow);
        XAccessible xAccessible2 = this.findXAccessibleByRole(xAccessible, (short)51);
        XAccessibleContext xAccessibleContext = xAccessible2.getAccessibleContext();
        XAccessible[] xAccessibleArray = new XAccessible[2];
        XAccessibleAction[] xAccessibleActionArray = new XAccessibleAction[2];
        int n = 0;
        int n2 = 0;
        while (n < xAccessibleContext.getAccessibleChildCount()) {
            try {
                XAccessible xAccessible3 = xAccessibleContext.getAccessibleChild(n);
                XAccessibleContext xAccessibleContext2 = xAccessible3.getAccessibleContext();
                if (xAccessibleContext2.getAccessibleRole() == 50) {
                    xAccessibleArray[n2] = xAccessible3;
                    xAccessibleActionArray[n2] = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)xAccessibleArray[n2].getAccessibleContext());
                    ++n2;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
            }
            ++n;
        }
        return xAccessibleActionArray;
    }

    public boolean isPasswordProtected(String string) {
        ODFParser oDFParser = new ODFParser();
        ODFDocument oDFDocument = oDFParser.getDocument(string, ODFConstants.ODF_MANIFEST_FILENAME);
        if (oDFDocument == null) {
            return false;
        }
        NodeList nodeList = oDFDocument.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "encryption-data");
        return nodeList != null && nodeList.getLength() != 0;
    }

    public void open(String string) {
        if (this.isPasswordProtected(string)) {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.actf.examples.adesigner.doc/docs/odf/error.html");
            return;
        }
        if (this.oooWin != null) {
            this.oooWin.dispose();
        }
        if (this.xFrame != null) {
            this.closeFrame();
        }
        this.oooWin = new OOoWindow(this);
        this._url = string;
        this.dispathMessageThread(new Runnable(){

            public void run() {
                try {
                    OOoWindowComposite.this.oooWin.create(OOoWindowComposite.this.xMSF);
                    OOoWindowComposite.this.xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)OOoWindowComposite.this.xMSF.createInstance("com.sun.star.frame.Frame"));
                    XFramesSupplier xFramesSupplier = (XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)OOoWindowComposite.this.xMSF.createInstance("com.sun.star.frame.Desktop"));
                    XFrames xFrames = xFramesSupplier.getFrames();
                    xFrames.append(OOoWindowComposite.this.xFrame);
                    OOoWindowComposite.this.xFrame.initialize(OOoWindowComposite.this.oooWin.getXWindow());
                    OOoWindowComposite.this.load(OOoWindowComposite.this._url);
                    OOoWindowComposite.this.scrollAction = OOoWindowComposite.this.findScrollAction();
                    try {
                        OOoUIControls.hideUIElements(OOoWindowComposite.this.xFrame, OOoWindowComposite.this.xMSF);
                    }
                    catch (ODFException oDFException) {
                        oDFException.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        Point point = this.getSize();
        this.oooWin.setVisible(true);
        this.oooWin.setSize(point.x, point.y);
    }

    public String getUrl() {
        return this._url;
    }

    public OOoNavigation getOooNavigation() {
        return this.oooNavigation;
    }

    public XAccessibleAction[] getScrollAction() {
        return this.scrollAction;
    }

    public int[] getViewData() {
        ODFConstants.ContentType contentType = ODFFileUtils.getODFFileType((String)this._url);
        if (ODFConstants.ContentType.WRITE.equals((Object)contentType)) {
            XTextDocument xTextDocument = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xComponent);
            if (xTextDocument != null) {
                String string = (String)this.xFrame.getController().getViewData();
                String[] stringArray = string.split(";");
                int[] nArray = new int[]{new Integer(stringArray[3]), new Integer(stringArray[4]), new Integer(stringArray[5]), new Integer(stringArray[6])};
                return nArray;
            }
        } else if (ODFConstants.ContentType.SPREADSHEET.equals((Object)contentType)) {
            XController xController = this.xFrame.getController();
            XSpreadsheetView xSpreadsheetView = (XSpreadsheetView)UnoRuntime.queryInterface(XSpreadsheetView.class, (Object)xController);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xSpreadsheetView);
            try {
                Rectangle rectangle = (Rectangle)UnoRuntime.queryInterface(Rectangle.class, (Object)xPropertySet.getPropertyValue("VisibleArea"));
                int[] nArray = new int[]{rectangle.X, rectangle.Y, rectangle.X + rectangle.Width, rectangle.Y + rectangle.Height};
                return nArray;
            }
            catch (UnknownPropertyException unknownPropertyException) {
                unknownPropertyException.printStackTrace();
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace();
            }
        } else if (ODFConstants.ContentType.PRESENTATION.equals((Object)contentType)) {
            XController xController = this.xFrame.getController();
            XDrawView xDrawView = (XDrawView)UnoRuntime.queryInterface(XDrawView.class, (Object)xController);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xDrawView);
            try {
                Rectangle rectangle = (Rectangle)UnoRuntime.queryInterface(Rectangle.class, (Object)xPropertySet.getPropertyValue("VisibleArea"));
                int[] nArray = new int[]{rectangle.X, rectangle.Y, rectangle.X + rectangle.Width, rectangle.Y + rectangle.Height};
                return nArray;
            }
            catch (UnknownPropertyException unknownPropertyException) {
                unknownPropertyException.printStackTrace();
            }
            catch (WrappedTargetException wrappedTargetException) {
                wrappedTargetException.printStackTrace();
            }
        }
        return null;
    }

    public int[] getOOoWinSize() throws ODFException {
        if (this.xFrame == null) {
            throw new ODFException("not initialized");
        }
        XWindow xWindow = this.xFrame.getComponentWindow();
        Rectangle rectangle = xWindow.getPosSize();
        int[] nArray = new int[]{rectangle.Width, rectangle.Height};
        return nArray;
    }

    public int getPresentationPageCount() {
        return ODFUtils.getDrawPageCount(this.xComponent);
    }

    public int jumpToPresentationPage(int n) {
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xComponent);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        XController xController = this.xFrame.getController();
        XDrawView xDrawView = (XDrawView)UnoRuntime.queryInterface(XDrawView.class, (Object)xController);
        try {
            XDrawPage xDrawPage = (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, (Object)xDrawPages.getByIndex(n - 1));
            xDrawView.setCurrentPage(xDrawPage);
            return 1;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace();
        }
        return -1;
    }

    public int getCurrentPageNumber() {
        XController xController = this.xFrame.getController();
        XDrawView xDrawView = (XDrawView)UnoRuntime.queryInterface(XDrawView.class, (Object)xController);
        XDrawPage xDrawPage = xDrawView.getCurrentPage();
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xDrawPage);
        try {
            return ((Short)xPropertySet.getPropertyValue("Number")).intValue();
        }
        catch (UnknownPropertyException unknownPropertyException) {
            unknownPropertyException.printStackTrace();
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace();
        }
        return -1;
    }

    public int movePresentationPage(boolean bl) {
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)this.xComponent);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        int n = xDrawPages.getCount();
        int n2 = this.getCurrentPageNumber();
        if (n2 == -1) {
            return -1;
        }
        if (bl && n2 == n) {
            return 0;
        }
        if (!bl && n2 == 1) {
            return 0;
        }
        int n3 = bl ? n2 : n2 - 2;
        XController xController = this.xFrame.getController();
        XDrawView xDrawView = (XDrawView)UnoRuntime.queryInterface(XDrawView.class, (Object)xController);
        try {
            XDrawPage xDrawPage = (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, (Object)xDrawPages.getByIndex(n3));
            xDrawView.setCurrentPage(xDrawPage);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
        catch (WrappedTargetException wrappedTargetException) {
            wrappedTargetException.printStackTrace();
        }
        try {
            return this.getOOoWinSize()[1];
        }
        catch (ODFException oDFException) {
            return -1;
        }
    }

    public boolean setDrawingMode() {
        try {
            return OOoUIControls.setDrawingMode(this.xMSF, this.xFrame.getController());
        }
        catch (ODFException oDFException) {
            oDFException.printStackTrace();
            return false;
        }
    }

    private class OOoWindow {
        Composite parent = null;
        XWindow xWindow = null;

        public OOoWindow(Composite composite) {
            this.parent = composite;
        }

        public void dispose() {
            this.xWindow = null;
        }

        public void create(XMultiServiceFactory xMultiServiceFactory) {
            if (this.xWindow == null) {
                byte[] byArray;
                XWindowPeer xWindowPeer;
                XSystemChildFactory xSystemChildFactory;
                XToolkit xToolkit = null;
                try {
                    xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit"));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (xToolkit != null && (xSystemChildFactory = (XSystemChildFactory)UnoRuntime.queryInterface(XSystemChildFactory.class, (Object)xToolkit)) != null && (xWindowPeer = xSystemChildFactory.createSystemChild((Object)new Integer(this.parent.handle), byArray = new byte[0], (short)1)) != null) {
                    this.xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xWindowPeer);
                }
            }
        }

        public XWindow getXWindow() {
            return this.xWindow;
        }

        public void setSize(int n, int n2) {
            if (this.xWindow != null) {
                this.xWindow.setPosSize(0, 0, n, n2, (short)12);
            }
        }

        public void setWidth(int n) {
            if (this.xWindow != null) {
                this.xWindow.setPosSize(0, 0, n, 0, (short)4);
            }
        }

        public void setHeight(int n) {
            if (this.xWindow != null) {
                this.xWindow.setPosSize(0, 0, 0, n, (short)8);
            }
        }

        public void setVisible(boolean bl) {
            if (this.xWindow != null) {
                this.xWindow.setVisible(bl);
            }
        }
    }

    private class OOoWindowControlListener
    implements ControlListener {
        private OOoWindowControlListener() {
        }

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            Object object;
            if (OOoWindowComposite.this.oooWin != null && (object = controlEvent.getSource()) instanceof Composite) {
                Point point = ((Composite)object).getSize();
                OOoWindowComposite.this.oooWin.setSize(point.x, point.y);
            }
        }
    }
}

