/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.BifurcatedOutputStream;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPConnectionException;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMalformedResponseMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseReader;
import org.eclipse.actf.util.internal.httpproxy.core.RequestDispatcher;
import org.eclipse.actf.util.internal.httpproxy.core.ServerKey;
import org.eclipse.actf.util.internal.httpproxy.core.SocketTimeoutRetryOutputStream;

public abstract class ServerConnection
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ServerConnection.class);
    public static final int STAT_CLOSED = -2;
    public static final int STAT_FINALIZING = -1;
    public static final int STAT_INIT = 0;
    public static final int STAT_CONNECTING = 1;
    public static final int STAT_CONNECTED = 2;
    private final ServerKey fKey;
    private final String name;
    private final String host;
    private final int port;
    private final RequestDispatcher fDispatcher;
    private final int fRetryTime;
    private final int timeout;
    private Thread fThread;
    private SocketOpener fSocketOpener = null;
    private Thread fSocketOpenerThread = null;
    private IHTTPRequestMessage fRequest;
    private long fFirstTimeout = 0L;
    private Socket fSocket = null;
    private InputStream fInputStream = null;
    private BufferedOutputStream fOutputStream = null;
    private HTTPResponseReader fReader = null;
    private long fMessageSerial;
    private Status fStat = new Status();

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    InputStream getInputStream() {
        return this.fInputStream;
    }

    OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    protected ServerConnection(String string, String string2, int n, int n2, int n3, RequestDispatcher requestDispatcher, int n4, int n5) {
        this.name = string;
        this.host = string2;
        this.port = n;
        this.fKey = new ServerKey(n2, n3);
        this.fRetryTime = n4;
        this.fDispatcher = requestDispatcher;
        this.timeout = n5;
        this.fRequest = null;
        this.fMessageSerial = 0L;
    }

    protected abstract HTTPResponseMessage createHTTPResponseMessage(long var1);

    public synchronized void reset() {
        this.deactivate();
        this.setStat(0);
    }

    public ServerKey getKey() {
        return this.fKey;
    }

    public synchronized boolean isActive() {
        return this.fThread != null;
    }

    public synchronized void activate() {
        if (this.isActive()) {
            this.DEBUG("activate: already active");
            return;
        }
        this.DEBUG("activate");
        this.setStat(1);
        this.fMessageSerial = 0L;
        this.setTimeout(false);
        this.fThread = new Thread((Runnable)this, "ServerConnection-" + this.name);
        this.fThread.start();
        this.fSocket = null;
        this.fOutputStream = null;
        this.fReader = null;
        this.fSocketOpener = new SocketOpener(this.host, this.port, this.timeout * 2, this);
        this.fSocketOpenerThread = new Thread((Runnable)this.fSocketOpener, "SocketOpener-" + this.toString());
        this.fSocketOpenerThread.start();
    }

    public void activateAndConnect(long l) throws IOException, TimeoutException, InterruptedException {
        this.activate();
        this.waitUntilConnected(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilConnected(long l) throws IOException, TimeoutException, InterruptedException {
        int n;
        this.DEBUG("waitUntilConnected");
        Status status = this.fStat;
        synchronized (status) {
            if (this.fStat.equals(1)) {
                this.fStat.waitFor(2, l);
            }
            n = this.fStat.get();
        }
        if (n == 2) {
            this.DEBUG("connected");
            return;
        }
        if (n == 1) {
            throw new TimeoutException("ServerConnection.waitUntilConnected");
        }
        if (n == 0) {
            throw new IOException("This connection is not activated yet");
        }
        if (n == -2) {
            throw new IOException("This connection is already closed");
        }
    }

    public synchronized void deactivate() {
        this.DEBUG("deactivate");
        if (!this.isActive()) {
            this.DEBUG("deactivate: already deactive");
            return;
        }
        try {
            if (this.fSocket != null && !this.fSocket.isOutputShutdown()) {
                this.fSocket.shutdownOutput();
            }
        }
        catch (IOException iOException) {
            this.WARNING("Failed to shutdown a socket (IOException): " + iOException.getMessage());
        }
        this.fThread.interrupt();
        this.fThread = null;
        this.fSocketOpener.setValid(false);
        this.fSocketOpenerThread.interrupt();
        this.fSocketOpener = null;
        this.fSocketOpenerThread = null;
        this.fSocket = null;
        this.fOutputStream = null;
        this.fReader = null;
        this.fMessageSerial = 0L;
        this.setTimeout(false);
        this.setStat(-2);
    }

    synchronized void notifyConnected(Socket socket, OutputStream outputStream, InputStream inputStream) {
        if (socket == null) {
            throw new IllegalArgumentException("null");
        }
        this.DEBUG("setSocket");
        this.fSocket = socket;
        this.fOutputStream = new BufferedOutputStream(new SocketTimeoutRetryOutputStream(outputStream));
        this.fInputStream = inputStream;
        this.fReader = this.fDispatcher.createHTTPResponseReader(inputStream);
        this.setStat(2);
    }

    synchronized void notifyConnectFailed(IOException iOException) {
        this.WARNING("setSocketException: failed to create a socket (IOException): " + iOException.getMessage());
        this.fSocket = null;
        this.fOutputStream = null;
        this.fReader = null;
        this.deactivate();
    }

    public synchronized void setTimeout(boolean bl) {
        if (bl) {
            if (this.fFirstTimeout == 0L) {
                this.fFirstTimeout = System.currentTimeMillis();
            }
        } else {
            this.fFirstTimeout = 0L;
        }
    }

    public synchronized boolean isInvalid() {
        if (this.fFirstTimeout == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.fFirstTimeout < (long)this.fRetryTime;
    }

    public int getStat() {
        return this.fStat.get();
    }

    private void setStat(int n) {
        this.fStat.set(n);
    }

    private boolean startSession(long l, long l2) throws TimeoutException, InterruptedException {
        if (this.fMessageSerial != 0L) {
            if (l == this.fMessageSerial) {
                return false;
            }
            long l3 = System.currentTimeMillis() + l2;
            long l4 = l2;
            while (l4 > 0L) {
                this.wait(l4);
                if (this.fMessageSerial == 0L) break;
                l4 = l3 - System.currentTimeMillis();
            }
            if (this.fMessageSerial != 0L) {
                throw new TimeoutException("ServerConnection.startSession");
            }
        }
        this.fMessageSerial = l;
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Session started: msgSerial=" + this.fMessageSerial);
        }
        return true;
    }

    private synchronized void finishSession() {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Session finished: msgSerial=" + this.fMessageSerial);
        }
        assert (this.fMessageSerial != 0L);
        this.fMessageSerial = 0L;
        this.notifyAll();
    }

    public synchronized void putRequest(IHTTPRequestMessage iHTTPRequestMessage, long l) throws TimeoutException, InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("putRequest: msgSerial=" + iHTTPRequestMessage.getSerial() + ", tid=" + iHTTPRequestMessage.getTid());
        }
        boolean bl = this.startSession(iHTTPRequestMessage.getSerial(), l);
        assert (iHTTPRequestMessage.getSerial() == this.fMessageSerial);
        if (bl) {
            this.fRequest = iHTTPRequestMessage;
            this.notifyAll();
        }
    }

    private synchronized IHTTPRequestMessage nextRequest() throws InterruptedException {
        while (this.fRequest == null || this.fMessageSerial == 0L) {
            if (LOGGER.isDebugEnabled()) {
                this.DEBUG("nextRequest waiting: request=" + this.fRequest + ", msgSerial=" + this.fMessageSerial);
            }
            this.wait();
        }
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("nextRequest waiting done: request=" + this.fRequest + ", msgSerial=" + this.fMessageSerial);
        }
        IHTTPRequestMessage iHTTPRequestMessage = this.fRequest;
        this.fRequest = null;
        return iHTTPRequestMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IHTTPResponseMessage receiveResponse(long l, boolean bl) throws InterruptedException, IOException, TimeoutException {
        long l2;
        HTTPResponseReader hTTPResponseReader;
        Object object = this;
        synchronized (object) {
            assert (this.fStat.equals(2) && this.fReader != null && this.fMessageSerial != 0L);
            if (this.fReader == null || this.fMessageSerial == 0L) {
                throw new IOException("Deactivated");
            }
            hTTPResponseReader = this.fReader;
            l2 = this.fMessageSerial;
        }
        object = this.createHTTPResponseMessage(l2);
        this.DEBUG("Try to read response...");
        hTTPResponseReader.readMessage((HTTPMessage)object, l, bl);
        return object;
    }

    private synchronized void sendRequest(IHTTPRequestMessage iHTTPRequestMessage, long l) throws IOException, InterruptedException, TimeoutException {
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("sendRequest....");
        }
        long l2 = System.currentTimeMillis();
        this.waitUntilConnected(l);
        assert (this.fOutputStream != null);
        long l3 = System.currentTimeMillis();
        if ((l -= l3 - l2) <= 0L) {
            throw new TimeoutException();
        }
        if (LOGGER.isDebugEnabled()) {
            this.DEBUG("Sent a request: msgSerial=" + iHTTPRequestMessage.getSerial() + ", tid=" + iHTTPRequestMessage.getTid());
            StringBuffer stringBuffer = new StringBuffer();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BifurcatedOutputStream bifurcatedOutputStream = new BifurcatedOutputStream(this.fOutputStream, byteArrayOutputStream);
            iHTTPRequestMessage.write(l, bifurcatedOutputStream);
            byteArrayOutputStream.close();
            stringBuffer.append("\n===============>====>====>====>=============>\n");
            stringBuffer.append(byteArrayOutputStream.toString());
            stringBuffer.append("===============<====<====<====<=============<\n");
            this.DEBUG(stringBuffer.toString());
        } else {
            iHTTPRequestMessage.write(l, this.fOutputStream);
        }
        this.fOutputStream.flush();
        this.fMessageSerial = iHTTPRequestMessage.getSerial();
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        this.DEBUG("receiver thread started");
        try {
            try {
                var1_1 = false;
                var2_3 = 0;
                if (true) ** GOTO lbl47
                do {
                    block22: {
                        ++var2_3;
                        var3_5 = this.nextRequest();
                        try {
                            if (var3_5.isConnectionShutdownRequired()) {
                                var3_5.setConnectionHeader(false);
                                this.sendRequest(var3_5, this.timeout);
                                this.fSocket.shutdownOutput();
                                this.setStat(-1);
                            } else {
                                var3_5.setConnectionHeader(true);
                                this.sendRequest(var3_5, this.timeout);
                            }
                        }
                        catch (TimeoutException v0) {
                            this.DEBUG("sendRequest() timeout");
                            this.setTimeout(true);
                            break block22;
                        }
                        if (!(ServerConnection.$assertionsDisabled || this.fStat.equals(2) || this.fStat.equals(-1))) {
                            throw new AssertionError();
                        }
                        var4_6 = 0;
                        var5_7 = System.currentTimeMillis();
                        while (!Thread.currentThread().isInterrupted() && !var1_1) {
                            try {
                                this.DEBUG("ReceiveResponse...");
                                var7_8 = this.receiveResponse(this.timeout, var3_5.isResponseBodyEmpty());
                                this.DEBUG("ResponseArrived...");
                                if (var7_8.isConnectionToBeClosed()) {
                                    this.DEBUG("Since the response is not keep-alive, we do not reuse this connection.");
                                    this.setStat(-1);
                                }
                                this.fDispatcher.responseArrived(this, var7_8);
                                this.finishSession();
                                break;
                            }
                            catch (TimeoutException var7_9) {
                                if (ServerConnection.LOGGER.isDebugEnabled()) {
                                    this.DEBUG("response receiving timeout (" + var7_9.getMessage() + "): retry=" + var4_6 + ", elapsed=" + (System.currentTimeMillis() - var5_7));
                                }
                                ++var4_6;
                                var7_10 = System.currentTimeMillis() - var5_7;
                                if (var7_10 <= 60000L) continue;
                                throw new IOException("Shutdown this connection");
                            }
                        }
                    }
                    if (Thread.interrupted()) return;
                } while (!var1_1);
                return;
            }
            catch (HTTPConnectionException v1) {
                this.DEBUG("The connection is closed by the peer.");
                this.DEBUG("receiver thread stopped");
                this.deactivate();
                return;
            }
            catch (IOException var1_2) {
                this.DEBUG("IOException: " + var1_2.getMessage());
                var2_4 = new HTTPMalformedResponseMessage(this.fMessageSerial, var1_2);
                try {
                    this.fDispatcher.responseArrived(this, var2_4);
                }
                catch (InterruptedException v2) {}
                this.finishSession();
                this.DEBUG("receiver thread stopped");
                this.deactivate();
                return;
            }
            catch (InterruptedException v3) {
                this.DEBUG("reader thread interrupted");
                this.DEBUG("receiver thread stopped");
                this.deactivate();
                return;
                {
                    catch (Throwable var9_11) {
                        throw var9_11;
                    }
                }
            }
        }
        finally {
            this.DEBUG("receiver thread stopped");
            this.deactivate();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.host).append(':').append(this.port).append('.').append(this.fKey.toString());
        return stringBuffer.toString();
    }

    private final void DEBUG(String string) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name).append(" [");
            stringBuffer.append(this.toString()).append("] ").append(string);
            LOGGER.debug(stringBuffer.toString());
        }
    }

    private final void WARNING(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append(" [");
        stringBuffer.append(this.toString()).append("] ").append(string);
        LOGGER.warning(stringBuffer.toString());
    }

    public synchronized String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString()).append(": stat=").append(this.fStat);
        stringBuffer.append(", thread=");
        stringBuffer.append(this.fThread == null ? "null" : Boolean.toString(this.fThread.isAlive()));
        stringBuffer.append(", socketOpener=");
        stringBuffer.append(this.fSocketOpener == null ? "null" : "exists");
        stringBuffer.append(", socketOpenerThread=");
        stringBuffer.append(this.fSocketOpenerThread == null ? "null" : Boolean.toString(this.fSocketOpenerThread.isAlive()));
        stringBuffer.append(", socket=");
        stringBuffer.append(this.fSocket == null ? "null" : Boolean.toString(this.fSocket.isConnected()));
        stringBuffer.append(", invalid=").append(this.isInvalid());
        return stringBuffer.toString();
    }

    private static class SocketOpener
    implements Runnable {
        private ServerConnection fSocketReceiver;
        private String fHost;
        private int fPort;
        private boolean isValid;

        SocketOpener(String string, int n, int n2, ServerConnection serverConnection) {
            this.fHost = string;
            this.fPort = n;
            this.fSocketReceiver = serverConnection;
            this.isValid = true;
        }

        synchronized void setValid(boolean bl) {
            this.isValid = bl;
        }

        synchronized boolean isValid() {
            return this.isValid;
        }

        public void run() {
            block8: {
                this.fSocketReceiver.DEBUG("SocketOpener started");
                try {
                    Socket socket = null;
                    OutputStream outputStream = null;
                    InputStream inputStream = null;
                    if (this.isValid()) {
                        if (LOGGER.isDebugEnabled()) {
                            this.fSocketReceiver.DEBUG("Trying to create a Socket: " + this.fHost + "@" + this.fPort);
                        }
                        socket = new Socket(this.fHost, this.fPort);
                        socket.setSoTimeout(1);
                        outputStream = socket.getOutputStream();
                        inputStream = socket.getInputStream();
                        if (LOGGER.isDebugEnabled()) {
                            this.fSocketReceiver.DEBUG("Created a Socket: " + this.fHost + "@" + this.fPort);
                        }
                    }
                    if (socket != null && outputStream != null && inputStream != null && this.isValid()) {
                        if (LOGGER.isDebugEnabled()) {
                            this.fSocketReceiver.DEBUG("Set a Socket to the ServerConnection: " + this.fHost + "@" + this.fPort);
                        }
                        this.fSocketReceiver.notifyConnected(socket, outputStream, inputStream);
                    }
                }
                catch (IOException iOException) {
                    if (LOGGER.isDebugEnabled()) {
                        this.fSocketReceiver.DEBUG("Failed to create a Socket (" + iOException.getClass().getName() + "): " + this.fHost + "@" + this.fPort);
                    }
                    if (!this.isValid()) break block8;
                    this.fSocketReceiver.notifyConnectFailed(iOException);
                }
            }
        }
    }

    private static class Status {
        private int fStat = 0;
        private int fNumWaiters = 0;

        Status() {
        }

        synchronized void set(int n) {
            this.fStat = n;
            this.notifyAll();
        }

        synchronized int get() {
            return this.fStat;
        }

        synchronized boolean equals(int n) {
            return this.fStat == n;
        }

        synchronized boolean waitFor(int n, long l) throws InterruptedException, TimeoutException {
            if (this.fStat == n) {
                return true;
            }
            if (this.fStat == -2) {
                return false;
            }
            ++this.fNumWaiters;
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (l3 > 0L) {
                this.wait(l3);
                if (this.fStat == n) {
                    return true;
                }
                if (this.fStat == -2) {
                    return false;
                }
                l3 = l2 - System.currentTimeMillis();
            }
            throw new TimeoutException();
        }

        public String toString() {
            switch (this.fStat) {
                case -2: {
                    return "CLOSED";
                }
                case 0: {
                    return "INIT";
                }
                case 1: {
                    return "CONNECTING";
                }
                case 2: {
                    return "CONNECTED";
                }
            }
            return "Unkown";
        }
    }
}

