/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.actf.util.win32.WindowUtil;
import org.eclipse.actf.util.win32.comclutch.ComService;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.eclipse.actf.util.win32.msaa.IAccessible;
import org.eclipse.actf.util.win32.msaa.MSAA;

public class FlashMSAAObject {
    FlashMSAAObject parent;
    IAccessible iacc;
    int childId = 0;
    private FlashMSAAObject[] cachedChildren = new FlashMSAAObject[0];
    private String strClassName;
    private long accWindow = -1L;

    FlashMSAAObject(IAccessible iAccessible) {
        this.iacc = iAccessible;
    }

    FlashMSAAObject(FlashMSAAObject flashMSAAObject, int n) {
        this.parent = flashMSAAObject;
        this.childId = n;
    }

    private int getChildId() {
        return this.childId;
    }

    public IAccessible getIAccessible() {
        if (this.iacc != null) {
            return this.iacc;
        }
        if (this.parent != null) {
            return this.parent.getIAccessible();
        }
        return null;
    }

    public String getAccKeyboardShortcut() {
        return this.getIAccessible().getAccKeyboardShortcut(this.getChildId());
    }

    public int getAccRole() {
        return this.getIAccessible().getAccRole(this.getChildId());
    }

    public String getAccDescription() {
        return this.getIAccessible().getAccDescription(this.getChildId());
    }

    public int getAccState() {
        return this.getIAccessible().getAccState(this.getChildId());
    }

    public boolean doDefaultAction() {
        try {
            return this.getIAccessible().accDoDefaultAction(this.getChildId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getChildCount() {
        if (this.iacc != null) {
            return this.iacc.getAccChildCount();
        }
        return 0;
    }

    public String getAccName() {
        return this.getIAccessible().getAccName(this.getChildId());
    }

    public boolean select(int n) {
        this.getIAccessible().accSelect(n, this.getChildId());
        return true;
    }

    public FlashMSAAObject[] getChildren() {
        int n = Math.max(0, this.getChildCount());
        if (n == this.cachedChildren.length) {
            return this.cachedChildren;
        }
        if (n > 32768) {
            System.err.println("Too many children(" + n + "), we don't fectch.");
            return new FlashMSAAObject[0];
        }
        this.cachedChildren = new FlashMSAAObject[n];
        if (n > 0) {
            Object[] objectArray = MSAA.getAccessibleChildren((IDispatch)this.getIAccessible(), (int)0, (int)n);
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2] != null) {
                    if (objectArray[n2] instanceof Integer) {
                        this.cachedChildren[n2] = new FlashMSAAObject(this, (Integer)objectArray[n2]);
                    } else if (objectArray[n2] instanceof IDispatch) {
                        IAccessible iAccessible = ComService.newIAccessible((IUnknown)((IDispatch)objectArray[n2]));
                        this.cachedChildren[n2] = new FlashMSAAObject(iAccessible);
                    }
                }
                ++n2;
            }
        }
        return this.cachedChildren;
    }

    public String getClassName() {
        if (this.strClassName == null) {
            long l = this.getWindow();
            this.strClassName = null;
            if (0L != l) {
                this.strClassName = WindowUtil.GetWindowClassName((int)l);
            }
        }
        return this.strClassName;
    }

    public int getWindow() {
        if (-1L == this.accWindow) {
            try {
                this.accWindow = MSAA.WindowFromAccessibleObject((long)this.getIAccessible().getPtr());
            }
            catch (Exception exception) {
                this.accWindow = 0L;
            }
        }
        return (int)this.accWindow;
    }

    public int getPtr() {
        return (int)this.getIAccessible().getPtr();
    }
}

