/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.maven;

import com.google.common.base.Charsets;
import io.takari.aether.wagon.OkHttpWagon;
import io.takari.aether.wagon.OkHttpsWagon;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.config.BuildDirectories;
import org.eclipse.tea.library.build.config.TeaBuildConfig;
import org.eclipse.tea.library.build.model.MavenExternalJarBuild;
import org.eclipse.tea.library.build.model.PluginBuild;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.tasks.maven.ConsoleRepositoryListener;
import org.eclipse.tea.library.build.tasks.maven.ConsoleTransferListener;
import org.eclipse.tea.library.build.util.FileUtils;
import org.eclipse.tea.library.build.util.StringHelper;

public class SynchronizeMavenArtifact {
    private static final RepositoryPolicy DISABLED_POLICY = new RepositoryPolicy(false, null, null);
    private static final RepositoryPolicy RELEASE_POLICY = new RepositoryPolicy(true, "daily", "warn");
    private static final RepositoryPolicy SNAPSHOT_POLICY = new RepositoryPolicy(true, "always", "warn");
    private MavenConfig properties;

    public String toString() {
        return "Synchronize Maven";
    }

    @Execute
    public void run(TaskingLog log, TeaBuildConfig cfg, WorkspaceBuild wb) throws Exception {
        this.properties = SynchronizeMavenArtifact.getMavenConfig(log, cfg);
        if (this.properties == null) {
            return;
        }
        ServiceLocator locator = SynchronizeMavenArtifact.createServiceLocator(log);
        RepositorySystem system = (RepositorySystem)locator.getService(RepositorySystem.class);
        DefaultRepositorySystemSession session = this.createSession(log, system);
        List<RemoteRepository> remotes = this.createRemoteRepositories();
        List<PluginBuild> pbs = wb.getSourcePlugIns();
        for (PluginBuild pb : pbs) {
            if (pb.getMavenExternalJarDependencies().isEmpty() || ((PluginData)pb.getData()).isBinary()) continue;
            this.runSingle(log, pb, system, (RepositorySystemSession)session, remotes);
        }
    }

    public static MavenConfig getMavenConfig(TaskingLog log, TeaBuildConfig cfg) throws Exception {
        if (cfg.mavenConfigFilePath == null || StringHelper.isNullOrEmpty(cfg.mavenConfigFilePath)) {
            log.info("Skipping synchronization because no maven configuration has been set");
            return null;
        }
        String expanded = StringVariableManager.getDefault().performStringSubstitution(cfg.mavenConfigFilePath);
        File file = new File(expanded);
        if (!file.isAbsolute()) {
            file = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), expanded);
        }
        if (!file.exists()) {
            log.warn("Maven configuration file " + file + " is missing");
            return null;
        }
        return new MavenConfig(file);
    }

    private void runSingle(TaskingLog log, PluginBuild hostPlugin, RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> remotes) throws Exception {
        File target = new File(hostPlugin.getPluginDirectory(), "maven");
        if (!target.exists()) {
            FileUtils.mkdirs(target);
            log.warn("creating " + target + "; make sure to add to the classpath of " + hostPlugin.getPluginName());
        }
        TreeSet<File> valid = new TreeSet<File>(Comparator.comparing(File::getName));
        for (MavenExternalJarBuild artifact : hostPlugin.getMavenExternalJarDependencies()) {
            log.info("synchronize nexus coordinate " + artifact.getCoordinates() + " into " + hostPlugin.getPluginName());
            Coordinate coord = new Coordinate(artifact.getCoordinates());
            DefaultArtifact mvn = new DefaultArtifact(coord.group, coord.artifact, coord.classifier, coord.extension, coord.version);
            ArtifactRequest localrq = new ArtifactRequest().setArtifact((Artifact)mvn);
            boolean remote = false;
            try {
                ArtifactResult local = system.resolveArtifact(session, localrq);
                if (local.isMissing() || !local.isResolved() || local.getArtifact().isSnapshot()) {
                    remote = true;
                }
            }
            catch (Exception e) {
                remote = true;
            }
            ArtifactRequest remoterq = new ArtifactRequest().setArtifact((Artifact)mvn).setRepositories(remote ? remotes : null);
            this.resolveArtifact(log, target, system, session, remoterq, valid);
            try {
                DefaultArtifact srcmvn = new DefaultArtifact(coord.group, coord.artifact, "sources", coord.extension, coord.version);
                ArtifactRequest srcrq = new ArtifactRequest().setArtifact((Artifact)srcmvn).setRepositories(remote ? remotes : null);
                this.resolveArtifact(log, target, system, session, srcrq, valid);
            }
            catch (Exception e) {
                log.warn("No sources available for " + artifact.getCoordinates());
            }
        }
        File[] fileArray = target.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().equals(".gitignore")) {
                boolean isValid = false;
                for (File validFile : valid) {
                    if (!file.equals(validFile)) continue;
                    isValid = true;
                }
                if (!isValid) {
                    log.info("removing old maven artifact: " + file);
                    FileUtils.delete(file);
                }
            }
            ++n2;
        }
        File gitignore = new File(target, ".gitignore");
        if (!gitignore.exists()) {
            FileUtils.writeFileFromString(gitignore, Charsets.UTF_8, "*.jar");
        }
        IProject prj = ((PluginData)hostPlugin.getData()).getProject();
        prj.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
    }

    private void resolveArtifact(TaskingLog log, File target, RepositorySystem system, RepositorySystemSession session, ArtifactRequest rq, Set<File> resolved) {
        Artifact mvn = rq.getArtifact();
        try {
            ArtifactResult result = system.resolveArtifact(session, rq);
            if (result.isMissing() || !result.isResolved()) {
                log.warn("cannot resolve " + mvn.getGroupId() + ":" + mvn.getArtifactId() + ":" + mvn.getVersion() + ":" + mvn.getClassifier());
                if (!result.getExceptions().isEmpty()) {
                    for (Exception e : result.getExceptions()) {
                        e.printStackTrace(log.error());
                    }
                }
                return;
            }
            if (this.properties.isVerboseMavenOutput() && !result.getExceptions().isEmpty()) {
                for (Exception e : result.getExceptions()) {
                    e.printStackTrace(log.debug());
                }
            }
            File file = result.getArtifact().getFile();
            SynchronizeMavenArtifact.addFileToProjectsMavenFolder(log, target, resolved, result, file);
        }
        catch (Exception e) {
            log.error("cannot resolve " + mvn.getGroupId() + ":" + mvn.getArtifactId() + ":" + mvn.getVersion());
            throw new RuntimeException("failed to synchronize " + rq.getArtifact().getArtifactId(), e);
        }
    }

    private static void addFileToProjectsMavenFolder(TaskingLog log, File target, Set<File> resolved, ArtifactResult result, File file) throws IOException {
        File targetFile = new File(target, file.getName());
        resolved.add(targetFile);
        if (targetFile.exists() && !result.getArtifact().isSnapshot() && !targetFile.delete()) {
            if (targetFile.length() != file.length()) {
                log.error("cannot update " + targetFile + " to new version, please make sure file is not locked");
            }
            return;
        }
        FileUtils.delete(targetFile);
        try {
            targetFile = Files.createSymbolicLink(targetFile.toPath(), file.toPath(), new FileAttribute[0]).toFile();
            log.info("symlink created: " + targetFile);
        }
        catch (IOException e) {
            FileUtils.copyFileToDirectory(file, target);
        }
    }

    private List<RemoteRepository> createRemoteRepositories() {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (Map.Entry<String, String> repo : this.properties.getMavenRepos().entrySet()) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder("nexus_" + repo.getKey(), "default", repo.getValue());
            if (repo.getKey().startsWith("snapshot")) {
                builder.setReleasePolicy(DISABLED_POLICY);
                builder.setSnapshotPolicy(SNAPSHOT_POLICY);
            } else if (repo.getKey().startsWith("release")) {
                builder.setSnapshotPolicy(DISABLED_POLICY);
                builder.setReleasePolicy(RELEASE_POLICY);
            }
            repos.add(builder.build());
        }
        return repos;
    }

    private DefaultRepositorySystemSession createSession(TaskingLog log, RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository repo = new LocalRepository(BuildDirectories.get().getMavenDirectory());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, repo));
        if (this.properties.isVerboseMavenOutput()) {
            session.setTransferListener((TransferListener)new ConsoleTransferListener(log.debug()));
            session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener(log.debug()));
        }
        return session;
    }

    private static ServiceLocator createServiceLocator(final TaskingLog log) {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
        locator.addService(WagonProvider.class, InternalWagonProvider.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                log.error("cannot create service " + type.getName());
                exception.printStackTrace(log.error());
            }
        });
        return locator;
    }

    private static class Coordinate {
        final String group;
        final String artifact;
        final String extension;
        final String classifier;
        final String version;

        public Coordinate(String coord) {
            Matcher matcher = PluginBuild.MAVEN_COORDINATE_PATTERN.matcher(coord);
            if (!matcher.matches()) {
                throw new IllegalStateException("Illegal maven coordinates: " + coord);
            }
            this.group = matcher.group(1);
            this.artifact = matcher.group(2);
            this.extension = Coordinate.get(matcher.group(4), "jar");
            this.classifier = Coordinate.get(matcher.group(6), "");
            this.version = matcher.group(7);
        }

        private static String get(String value, String defaultValue) {
            return value == null || value.length() <= 0 ? defaultValue : value;
        }
    }

    private static class InternalWagonProvider
    implements WagonProvider {
        private InternalWagonProvider() {
        }

        public Wagon lookup(String roleHint) throws Exception {
            switch (roleHint) {
                case "file": {
                    return new FileWagon();
                }
                case "http": {
                    return new OkHttpWagon();
                }
                case "https": {
                    return new OkHttpsWagon();
                }
            }
            return null;
        }

        public void release(Wagon wagon) {
            if (wagon instanceof StreamWagon) {
                try {
                    ((StreamWagon)wagon).closeConnection();
                }
                catch (ConnectionException e) {
                    throw new RuntimeException("Cannot close connection", e);
                }
            }
        }
    }

    public static class MavenConfig {
        private static final String MAVEN_REPO_URL = "maven_repo_url_";
        private static final String MAVEN_REPO_TYPE = "maven_repo_type_";
        protected final Properties props;

        public MavenConfig(File file) throws IOException {
            try (FileInputStream fis = new FileInputStream(file);){
                this.props = new Properties();
                this.props.load(fis);
            }
        }

        public Properties getProps() {
            return this.props;
        }

        public Map<String, String> getMavenRepos() {
            long repoNum = 0L;
            TreeMap<String, String> result = new TreeMap<String, String>();
            for (String key : this.props.stringPropertyNames()) {
                if (key == null || !key.startsWith(MAVEN_REPO_URL)) continue;
                String type = this.props.getProperty(MAVEN_REPO_TYPE + key.substring(MAVEN_REPO_URL.length()));
                result.put(String.valueOf(type) + repoNum++, this.props.getProperty(key));
            }
            return result;
        }

        public boolean isVerboseMavenOutput() {
            String x = this.props.getProperty("maven_verbose");
            return Boolean.parseBoolean(x);
        }
    }
}

