/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.loggers.LOGGER_EVENTS;
import org.eclipse.stem.loggers.SimulationLogger;
import org.eclipse.stem.loggers.manager.ISimulationLoggerManagerListener;
import org.eclipse.stem.loggers.manager.SimulationLoggerManager;
import org.eclipse.stem.ui.views.LoggerViewMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;

public class ActiveLoggersView
extends ViewPart
implements ISimulationLoggerManagerListener {
    private static final SimulationLoggerManager LOGGER_MANAGER = SimulationLoggerManager.getManager();
    private TreeViewer viewer;
    private final Adapter labelUpdateAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (ActiveLoggersView.this.viewer == null || ActiveLoggersView.this.viewer.getTree().isDisposed()) {
                ((EObject)notification.getNotifier()).eAdapters().remove((Object)this);
                return;
            }
            ActiveLoggersView.this.viewer.refresh(notification.getNotifier(), true);
        }
    };

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent);
        this.viewer.setUseHashlookup(true);
        Tree baseTree = this.viewer.getTree();
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        TreeColumn col1 = new TreeColumn(this.viewer.getTree(), 16384);
        col1.setText(LoggerViewMessages.ALV_logger);
        col1.setWidth(200);
        TreeColumn col2 = new TreeColumn(baseTree, 16384);
        col2.setText(LoggerViewMessages.ALV_type);
        col2.setWidth(150);
        TreeColumn col3 = new TreeColumn(baseTree, 16384);
        col3.setText(LoggerViewMessages.ALV_status);
        col3.setWidth(100);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.setRemoveAllWhenShown(true);
        this.viewer.getControl().setMenu(contextMenuManager.createContextMenu(this.viewer.getControl()));
        this.getSite().registerContextMenu(contextMenuManager, (ISelectionProvider)this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ActiveLoggersContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ActiveLoggersLabelProvider());
        this.viewer.setInput((Object)SimulationLoggerManager.getManager().getActiveSimulations());
        this.viewer.expandAll();
        for (ISimulation sim : SimulationLoggerManager.getManager().getActiveSimulations()) {
            this.addSimulation(sim);
        }
        LOGGER_MANAGER.addListener((ISimulationLoggerManagerListener)this);
    }

    private void addSimulation(ISimulation simulation) {
        Collection loggers = LOGGER_MANAGER.getLoggersForSimulation(simulation);
        if (loggers != null) {
            for (SimulationLogger logger : loggers) {
                logger.eAdapters().add((Object)this.labelUpdateAdapter);
            }
        }
    }

    private void removeSimulation(ISimulation simulation) {
        Collection loggers = LOGGER_MANAGER.getLoggersForSimulation(simulation);
        if (simulation != null) {
            for (SimulationLogger logger : loggers) {
                logger.eAdapters().remove((Object)this.labelUpdateAdapter);
            }
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        for (ISimulation sim : SimulationLoggerManager.getManager().getActiveSimulations()) {
            this.removeSimulation(sim);
        }
        LOGGER_MANAGER.removeListener((ISimulationLoggerManagerListener)this);
        super.dispose();
    }

    public void simulationLoggerEvent(LOGGER_EVENTS event, Object[] targets) {
        ISimulation sim;
        int n;
        int n2;
        ISimulation[] iSimulationArray;
        ISimulation[] sims;
        if (LOGGER_EVENTS.SIMULATIONS_ADDED.equals((Object)event)) {
            iSimulationArray = sims = (ISimulation[])targets;
            n2 = sims.length;
            n = 0;
            while (n < n2) {
                sim = iSimulationArray[n];
                this.addSimulation(sim);
                ++n;
            }
        }
        if (LOGGER_EVENTS.SIMULATIONS_REMOVED.equals((Object)event)) {
            iSimulationArray = sims = (ISimulation[])targets;
            n2 = sims.length;
            n = 0;
            while (n < n2) {
                sim = iSimulationArray[n];
                this.removeSimulation(sim);
                ++n;
            }
        }
        this.viewer.refresh();
    }

    private class ActiveLoggersContentProvider
    implements ITreeContentProvider {
        private ActiveLoggersContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Collection loggers;
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            if (inputElement instanceof ISimulation && (loggers = LOGGER_MANAGER.getLoggersForSimulation((ISimulation)inputElement)) != null) {
                return loggers.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            Collection loggers;
            if (parentElement instanceof ISimulation && (loggers = LOGGER_MANAGER.getLoggersForSimulation((ISimulation)parentElement)) != null) {
                return loggers.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ISimulation) {
                Collection loggers = LOGGER_MANAGER.getLoggersForSimulation((ISimulation)element);
                return loggers != null && loggers.size() > 0;
            }
            return false;
        }
    }

    private class ActiveLoggersLabelProvider
    implements ITableLabelProvider {
        private ActiveLoggersLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ISimulation && columnIndex == 0) {
                ISimulation sim = (ISimulation)element;
                return sim.getNameWithSequenceNumber();
            }
            if (element instanceof SimulationLogger) {
                SimulationLogger logger = (SimulationLogger)element;
                switch (columnIndex) {
                    case 0: {
                        return logger.getURI().lastSegment();
                    }
                    case 1: {
                        return logger.eClass().getName();
                    }
                    case 2: {
                        return logger.isEnabled() ? LoggerViewMessages.ALV_enabled_message : LoggerViewMessages.ALV_disabled_message;
                    }
                }
            }
            return "";
        }
    }
}

