/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.csv.logger.html;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stem.loggers.csv.logger.html.Html;
import org.eclipse.stem.loggers.csv.logger.html.HtmlElement;

public class HTMLdocument {
    public final String HEADER = "<!DOCTYPE html>\n";
    public final String HTML_START = "<html>";
    public final String HTML_STOP = "</html>";
    protected List<HtmlElement> contents = new ArrayList<HtmlElement>();
    private Html html = new Html();

    public HTMLdocument() {
        this.contents.add(this.html);
    }

    protected void add(HtmlElement element) {
        this.html.add(element);
    }

    protected String getContents() {
        StringBuffer buf = new StringBuffer("<!DOCTYPE html>\n");
        int i = 0;
        while (i < this.contents.size()) {
            HtmlElement element = this.contents.get(i);
            buf.append(element.open());
            String data = element.getData();
            if (data != null) {
                buf.append(data);
            }
            buf.append(element.getContents(""));
            buf.append(element.close());
            ++i;
        }
        return buf.toString();
    }

    protected void writeDocument(File file, String doc) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(doc);
            fw.flush();
        }
        catch (Throwable throwable) {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (fw != null) {
            try {
                fw.close();
            }
            catch (Exception exception) {}
        }
    }
}

