/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.analysis.automaticexperiment.OptimizerAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.ui.AlgorithmCompositeEditor;
import org.eclipse.stem.analysis.automaticexperiment.ui.AlgorithmCompositeEditorAdapter;
import org.eclipse.stem.analysis.automaticexperiment.ui.AlgorithmCompositeEditorAdapterFactory;
import org.eclipse.stem.analysis.automaticexperiment.views.Messages;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AlgorithmControl
extends Composite {
    StackLayout stackLayout;
    private Map<OptimizerAlgorithm, AlgorithmCompositeEditor> compositeMap = new HashMap<OptimizerAlgorithm, AlgorithmCompositeEditor>();

    public AlgorithmControl(Composite parent, int style, ModifyListener projectValidator, IProject project, OptimizerAlgorithm[] algorithms) {
        super(parent, style);
        this.stackLayout = new StackLayout();
        this.setLayout((Layout)this.stackLayout);
        AlgorithmCompositeEditor firstOne = null;
        if (algorithms != null) {
            int i = 0;
            while (i < algorithms.length) {
                AlgorithmCompositeEditorAdapter acea = (AlgorithmCompositeEditorAdapter)AlgorithmCompositeEditorAdapterFactory.INSTANCE.adapt((Notifier)algorithms[i], AlgorithmCompositeEditorAdapter.class);
                AlgorithmCompositeEditor ace = acea.createCompositeEditor(this, 0, projectValidator, project);
                this.compositeMap.put(algorithms[i], ace);
                if (firstOne == null) {
                    firstOne = ace;
                }
                ++i;
            }
        }
        this.stackLayout.topControl = firstOne;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newautoexp_contextid");
    }

    void displayAlgorithm(OptimizerAlgorithm algorithm) {
        AlgorithmCompositeEditor ace = this.compositeMap.get(algorithm);
        if (ace != null) {
            this.stackLayout.topControl = ace;
            this.layout();
        } else {
            Activator.logError((String)(String.valueOf(Messages.getString("DMPC2")) + algorithm.getClass().getName() + "\""), null);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return ((AlgorithmCompositeEditor)this.stackLayout.topControl).validate();
    }

    public String getErrorMessage() {
        return ((AlgorithmCompositeEditor)this.stackLayout.topControl).getErrorMessage();
    }

    public OptimizerAlgorithm createAutomaticExperiment() {
        return ((AlgorithmCompositeEditor)this.stackLayout.topControl).createAlgorithm();
    }
}

