/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.use;

import java.io.File;
import java.net.URI;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.search.ApiSearchEngine;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchRequestor;
import org.eclipse.pde.api.tools.internal.provisional.search.IMetadata;
import org.eclipse.pde.api.tools.internal.search.ApiDescriptionModifier;
import org.eclipse.pde.api.tools.internal.search.ConsumerReportConvertor;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.search.UseMetadata;
import org.eclipse.pde.api.tools.internal.search.UseReportConverter;
import org.eclipse.pde.api.tools.internal.search.UseSearchRequestor;
import org.eclipse.pde.api.tools.internal.search.XmlSearchReporter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.use.Messages;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;

public class ApiUseScanJob
extends Job {
    private ILaunchConfiguration configuration = null;
    Set<SkippedComponent> notsearched = null;

    public ApiUseScanJob(ILaunchConfiguration configuration) {
        super(MessageFormat.format(Messages.ApiUseScanJob_api_use_report, configuration.getName()));
        this.configuration = configuration;
    }

    /*
     * Unable to fully structure code
     */
    protected IStatus run(IProgressMonitor monitor) {
        localmonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            try {
                rootpath = null;
                xmlPath = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.XML_PATH", null);
                if (xmlPath == null) {
                    this.abort(Messages.ApiUseScanJob_missing_xml_loc);
                }
                rootpath = new Path(xmlPath);
                kind = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.TARGET_KIND", 0);
                if (kind != 4) {
                    localmonitor.setTaskName(Messages.ApiUseScanJob_preparing_for_scan);
                    localmonitor.setWorkRemaining(this.isSpecified(16) != false ? 14 : 13);
                    baseline = this.createApiBaseline(kind, (IProgressMonitor)localmonitor.split(1));
                    ids = new HashSet<String>();
                    scope = new TreeSet<IApiComponent>(Util.componentsorter);
                    this.getContext(baseline, ids, scope, (IProgressMonitor)localmonitor.split(2));
                    kinds = 0;
                    if (this.isSpecified(1)) {
                        kinds |= 1;
                    }
                    if (this.isSpecified(2)) {
                        kinds |= 2;
                    }
                    if (this.isSpecified(64)) {
                        kinds |= 4;
                    }
                    requestor = new UseSearchRequestor(ids, scope.toArray(new IApiElement[scope.size()]), kinds);
                    jars = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.JAR_PATTERNS_LIST", null);
                    sjars = this.getStrings(jars);
                    requestor.setJarPatterns(sjars);
                    api = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.API_PATTERNS_LIST", null);
                    sapi = this.getStrings(api);
                    filterRoot = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.FILTER_ROOT", null);
                    requestor.setFilterRoot(filterRoot);
                    internal = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.INTERNAL_PATTERNS_LIST", null);
                    sinternal = this.getStrings(internal);
                    if (sapi != null || sinternal != null) {
                        components = baseline.getApiComponents();
                        visitor = new ApiDescriptionModifier(sinternal, sapi);
                        var23_22 = components;
                        var22_23 = components.length;
                        var21_26 = 0;
                        while (var21_26 < var22_23) {
                            component = var23_22[var21_26];
                            if (!component.isSystemComponent() && !component.isSourceComponent()) {
                                visitor.setApiDescription(component.getApiDescription());
                                component.getApiDescription().accept((ApiDescriptionVisitor)visitor, null);
                            }
                            ++var21_26;
                        }
                    }
                    xmlPath = rootpath.append("xml").toOSString();
                    if (this.isSpecified(4)) {
                        localmonitor.setTaskName(Messages.ApiUseScanJob_cleaning_xml_loc);
                        this.scrubReportLocation(new File(xmlPath), (IProgressMonitor)localmonitor.split(1));
                    }
                    data = new UseMetadata(kinds, this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.TARGET_SCOPE", null), this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.SEARCH_SCOPE", null), baseline.getLocation(), xmlPath, sapi, sinternal, sjars, this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.FILTER_ROOT", null), DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime()), this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.DESCRIPTION", null));
                    reporter = new XmlSearchReporter(xmlPath, false);
                    try {
                        engine = new ApiSearchEngine();
                        engine.search(baseline, (IApiSearchRequestor)requestor, (IApiSearchReporter)reporter, (IProgressMonitor)localmonitor.split(6));
                    }
                    finally {
                        reporter.reportNotSearched(this.notsearched.toArray(new IApiElement[this.notsearched.size()]));
                        reporter.reportMetadata((IMetadata)data);
                        reporter.reportCounts();
                        apiManager = ApiBaselineManager.getManager();
                        baselines = apiManager.getApiBaselines();
                        dispose = true;
                        var28_32 = baselines;
                        var27_34 = baselines.length;
                        var26_36 = 0;
                        ** while (var26_36 < var27_34)
                    }
lbl-1000:
                    // 1 sources

                    {
                        baseline2 = var28_32[var26_36];
                        if (baseline.equals(baseline2)) {
                            dispose = false;
                            break;
                        }
                        ++var26_36;
                        continue;
                    }
lbl75:
                    // 2 sources

                    if (dispose) {
                        baseline.dispose();
                    }
                } else {
                    localmonitor.setWorkRemaining(10);
                }
                if (this.isSpecified(16)) {
                    localmonitor.setTaskName(Messages.ApiUseScanJob_generating_html_reports);
                    htmlPath = rootpath.append("html").toOSString();
                    reportType = 1;
                    if (this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.REPORT_TYPE", 1) == 2) {
                        reportType = 2;
                    }
                    this.performReportCreation(reportType, this.isSpecified(8), htmlPath, xmlPath, this.isSpecified(32), this.getStrings(this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.TO_PATTERNS_LIST", null)), this.getStrings(this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.REPORT_PATTERNS_LIST", null)), (IProgressMonitor)localmonitor.split(10));
                }
            }
            catch (CoreException e) {
                var30_39 = e.getStatus();
                localmonitor.done();
                return var30_39;
            }
        }
        finally {
            localmonitor.done();
        }
        return Status.OK_STATUS;
    }

    private String[] getStrings(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    void abort(String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools.ui", message));
    }

    private IApiBaseline createApiBaseline(int kind, IProgressMonitor monitor) throws CoreException {
        ApiBaselineManager bmanager = ApiBaselineManager.getManager();
        switch (kind) {
            case 2: {
                IApiBaseline baseline;
                String name = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.BASELINE_NAME", null);
                if (name == null) {
                    this.abort(Messages.ApiUseScanJob_baseline_name_missing);
                }
                if ((baseline = bmanager.getApiBaseline(name)) == null) {
                    this.abort(MessageFormat.format(Messages.ApiUseScanJob_baseline_does_not_exist, name));
                }
                return baseline;
            }
            case 3: {
                File file;
                String path = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.INSTALL_PATH", null);
                if (path == null) {
                    this.abort(Messages.ApiUseScanJob_unspecified_install_path);
                }
                if (!(file = new File(path)).exists() || !file.isDirectory()) {
                    this.abort(MessageFormat.format(Messages.ApiUseScanJob_intall_dir_does_no_exist, path));
                }
                return this.createBaseline(path, monitor);
            }
            case 1: {
                String memento = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.TARGET_HANDLE", null);
                if (memento == null) {
                    this.abort(Messages.ApiUseScanJob_target_unspecified);
                }
                ITargetPlatformService service = this.getTargetService();
                ITargetHandle handle = service.getTarget(memento);
                ITargetDefinition definition = handle.getTargetDefinition();
                return this.createBaseline(definition, monitor);
            }
        }
        this.abort(Messages.ApiUseScanJob_target_api_unspecified);
        return null;
    }

    private ITargetPlatformService getTargetService() {
        return (ITargetPlatformService)ApiPlugin.getDefault().acquireService(ITargetPlatformService.class);
    }

    private void getContext(IApiBaseline baseline, Set<String> ids, Set<IApiComponent> scope, IProgressMonitor monitor) throws CoreException {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ApiUseScanJob_collecting_target_components, (int)10);
        this.notsearched = new TreeSet<SkippedComponent>(Util.componentsorter);
        String regex = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.TARGET_SCOPE", null);
        Pattern pattern = this.getPattern(regex);
        regex = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.SEARCH_SCOPE", null);
        Pattern pattern2 = this.getPattern(regex);
        IApiComponent[] components = baseline.getApiComponents();
        localmonitor.setWorkRemaining(components.length);
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component = iApiComponentArray[n2];
            localmonitor.subTask(NLS.bind((String)Messages.ApiUseScanJob_checking_component, (Object)component.getSymbolicName()));
            localmonitor.split(1);
            if (this.acceptComponent(component, pattern, true)) {
                ids.add(component.getSymbolicName());
            }
            if (this.acceptComponent(component, pattern2, false)) {
                scope.add(component);
            } else {
                localmonitor.subTask(NLS.bind((String)Messages.ApiUseScanJob_skipping_component, (Object)component.getSymbolicName()));
                this.notsearched.add(new SkippedComponent(component.getSymbolicName(), component.getVersion(), null));
            }
            ++n2;
        }
    }

    private Pattern getPattern(String regex) {
        if (regex == null) {
            return null;
        }
        if (regex.trim().length() == 0) {
            return null;
        }
        return Pattern.compile(regex);
    }

    boolean acceptComponent(IApiComponent component, Pattern pattern, boolean allowresolve) throws CoreException {
        ResolverError[] errors;
        if (!allowresolve && (errors = component.getErrors()) != null) {
            this.notsearched.add(new SkippedComponent(component.getSymbolicName(), component.getVersion(), errors));
            return false;
        }
        if (component.isSystemComponent()) {
            return false;
        }
        if (pattern != null) {
            return pattern.matcher(component.getSymbolicName()).matches();
        }
        return true;
    }

    private boolean isSpecified(int modifier) throws CoreException {
        int modifiers = this.configuration.getAttribute("org.eclipse.pde.api.tools.ui.SEARCH_MODIFIERS", 0);
        return (modifiers & modifier) > 0;
    }

    void performReportCreation(int reportType, boolean cleanh, String hlocation, String rlocation, boolean openhtml, String[] topatterns, String[] frompatterns, IProgressMonitor monitor) {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ApiUseScanJob_creating_html_reports, (int)10);
        if (cleanh) {
            this.cleanReportLocation(hlocation, (IProgressMonitor)localmonitor.split(5));
        }
        try {
            File index;
            Object converter = null;
            converter = reportType == 2 ? new ConsumerReportConvertor(hlocation, rlocation, topatterns, frompatterns) : new UseReportConverter(hlocation, rlocation, topatterns, frompatterns);
            converter.convert(null, (IProgressMonitor)localmonitor.split(5));
            if (openhtml && (index = converter.getReportIndex()) != null) {
                UIJob ujob = new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IEditorDescriptor edesc = null;
                        try {
                            edesc = IDE.getEditorDescriptor((String)index.getName());
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IDE.openEditor((IWorkbenchPage)window.getActivePage(), (URI)index.toURI(), (String)edesc.getId(), (boolean)true);
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                        return Status.OK_STATUS;
                    }
                };
                ujob.setPriority(10);
                ujob.setSystem(true);
                ujob.schedule();
            }
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            ApiPlugin.log((Throwable)e);
        }
    }

    void cleanReportLocation(String location, IProgressMonitor monitor) {
        File file = new File(location);
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ApiUseScanJob_deleting_old_reports, (int)1);
        if (file.exists()) {
            this.scrubReportLocation(file, (IProgressMonitor)localmonitor.split(1));
            localmonitor.subTask(NLS.bind((String)Messages.ApiUseScanJob_deleting_root_folder, (Object)file.getName()));
        }
    }

    void scrubReportLocation(File file, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                subMonitor.setWorkRemaining(files.length);
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file2 = fileArray[n2];
                    SubMonitor iterationMonitor = subMonitor.split(1);
                    iterationMonitor.subTask(NLS.bind((String)Messages.ApiUseScanJob_deleteing_file, (Object)file2.getPath()));
                    if (file2.isDirectory()) {
                        this.scrubReportLocation(file2, (IProgressMonitor)iterationMonitor);
                    } else {
                        file2.delete();
                    }
                    ++n2;
                }
            }
            file.delete();
        }
    }

    private IApiBaseline createBaseline(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ApiUseScanJob_reading_target, (int)10);
        definition.resolve((IProgressMonitor)localmonitor.split(2));
        TargetBundle[] bundles = definition.getBundles();
        ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
        IApiBaseline profile = ApiModelFactory.newApiBaseline((String)definition.getName());
        localmonitor.setWorkRemaining(bundles.length);
        int i = 0;
        while (i < bundles.length) {
            IApiComponent component;
            localmonitor.split(1);
            if (bundles[i].getStatus().isOK() && !bundles[i].isSourceBundle() && (component = ApiModelFactory.newApiComponent((IApiBaseline)profile, (String)URIUtil.toFile((URI)bundles[i].getBundleInfo().getLocation()).getAbsolutePath())) != null) {
                components.add(component);
            }
            ++i;
        }
        profile.addApiComponents(components.toArray(new IApiComponent[components.size()]));
        return profile;
    }

    private IApiBaseline createBaseline(String installLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.ApiUseScanJob_scanning, (int)10);
        IApiBaseline baseline = ApiModelFactory.newApiBaseline((String)this.configuration.getName());
        IApiComponent[] components = ApiModelFactory.addComponents((IApiBaseline)baseline, (String)installLocation, (IProgressMonitor)localmonitor);
        if (components.length == 0) {
            this.abort(MessageFormat.format(Messages.ApiUseScanJob_no_bundles, installLocation));
        }
        return baseline;
    }
}

