/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.stem.analysis.AnalysisPackage;
import org.eclipse.stem.analysis.ErrorFunction;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.ReferenceScenarioDataMap;
import org.eclipse.stem.analysis.States;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;

public class ErrorFunctionImpl
extends EObjectImpl
implements ErrorFunction {
    protected static final String REFERENCE_DATA_COMPARTMENT_EDEFAULT = "Incidence";
    protected String referenceDataCompartment = "Incidence";
    protected static final String COMPARISON_COMPARTMENT_EDEFAULT = "Incidence";
    protected String comparisonCompartment = "Incidence";

    protected ErrorFunctionImpl() {
    }

    protected EClass eStaticClass() {
        return AnalysisPackage.Literals.ERROR_FUNCTION;
    }

    @Override
    public String getReferenceDataCompartment() {
        return this.referenceDataCompartment;
    }

    @Override
    public void setReferenceDataCompartment(String newReferenceDataCompartment) {
        String oldReferenceDataCompartment = this.referenceDataCompartment;
        this.referenceDataCompartment = newReferenceDataCompartment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldReferenceDataCompartment, (Object)this.referenceDataCompartment));
        }
    }

    @Override
    public String getComparisonCompartment() {
        return this.comparisonCompartment;
    }

    @Override
    public void setComparisonCompartment(String newComparisonCompartment) {
        String oldComparisonCompartment = this.comparisonCompartment;
        this.comparisonCompartment = newComparisonCompartment;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldComparisonCompartment, (Object)this.comparisonCompartment));
        }
    }

    @Override
    public ErrorResult calculateError(ReferenceScenarioDataMap reference, ReferenceScenarioDataMap data) {
        throw new UnsupportedOperationException();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getReferenceDataCompartment();
            }
            case 1: {
                return this.getComparisonCompartment();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setReferenceDataCompartment((String)newValue);
                return;
            }
            case 1: {
                this.setComparisonCompartment((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setReferenceDataCompartment("Incidence");
                return;
            }
            case 1: {
                this.setComparisonCompartment("Incidence");
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return "Incidence" == null ? this.referenceDataCompartment != null : !"Incidence".equals(this.referenceDataCompartment);
            }
            case 1: {
                return "Incidence" == null ? this.comparisonCompartment != null : !"Incidence".equals(this.comparisonCompartment);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (referenceDataCompartment: ");
        result.append(this.referenceDataCompartment);
        result.append(", comparisonCompartment: ");
        result.append(this.comparisonCompartment);
        result.append(')');
        return result.toString();
    }

    public List<Double> getInfectious(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        List<Double> infectious = dataMap.getItotals();
        return infectious;
    }

    public List<Double> getIncidence(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        String INCIDENCE = States.statesToFit[5];
        List<String> incidenceList = dataMap.getData(INCIDENCE);
        assert (incidenceList != null);
        ArrayList<Double> infectious = new ArrayList<Double>();
        int i = 0;
        while (i < incidenceList.size()) {
            double inf = Double.valueOf(incidenceList.get(i));
            infectious.add(inf);
            ++i;
        }
        return infectious;
    }

    public List<Double> getData(String state, ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        List<String> incidenceList = dataMap.getData(state);
        assert (incidenceList != null);
        ArrayList<Double> infectious = new ArrayList<Double>();
        int i = 0;
        while (i < incidenceList.size()) {
            double inf = Double.valueOf(incidenceList.get(i));
            infectious.add(inf);
            ++i;
        }
        return infectious;
    }

    public List<Double> getCumData(String state, ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        List<String> incidenceList = dataMap.getData(state);
        assert (incidenceList != null);
        ArrayList<Double> infectious = new ArrayList<Double>();
        int i = 0;
        while (i < incidenceList.size()) {
            double inf = Double.valueOf(incidenceList.get(i));
            infectious.add(inf);
            ++i;
        }
        List<Double> cumulative = this.dailyToCum(infectious);
        return cumulative;
    }

    private List<Double> dailyToCum(List<Double> dailyValues) {
        ArrayList<Double> cumValues = new ArrayList<Double>();
        int i = 0;
        while (i < dailyValues.size()) {
            if (i == 0) {
                cumValues.add(dailyValues.get(i));
            } else {
                cumValues.add(dailyValues.get(i) + (Double)cumValues.get(i - 1));
            }
            ++i;
        }
        return cumValues;
    }

    public List<Double> getDeaths(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        String DISEASE_DEATHS = States.statesToFit[6];
        List<String> deathList = dataMap.getData(DISEASE_DEATHS);
        assert (deathList != null);
        ArrayList<Double> deaths = new ArrayList<Double>();
        int i = 0;
        while (i < deathList.size()) {
            double d = Double.valueOf(deathList.get(i));
            deaths.add(d);
            ++i;
        }
        return deaths;
    }

    public List<Double> getPopulation(ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance dataMap) {
        String POPULATION = States.statesToFit[4];
        List<String> popList = dataMap.getData(POPULATION);
        if (popList == null) {
            popList = dataMap.getData("Population Count");
        }
        assert (popList != null);
        ArrayList<Double> populations = new ArrayList<Double>();
        int i = 0;
        while (i < popList.size()) {
            double p = Double.valueOf(popList.get(i));
            populations.add(p);
            ++i;
        }
        return populations;
    }
}

