/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.rk.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.TransformationDecorator;
import org.eclipse.stem.core.solver.SolverException;
import org.eclipse.stem.core.solver.impl.SolverImpl;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.solvers.rk.RkPackage;
import org.eclipse.stem.solvers.rk.RungeKutta;
import org.eclipse.stem.solvers.rk.impl.RkJob;
import org.eclipse.stem.ui.Activator;

public class RungeKuttaImpl
extends SolverImpl
implements RungeKutta {
    private short num_threads = (short)2;
    private RkJob[] jobs;
    private CyclicBarrier stepSizeBarrier;
    private CyclicBarrier updateDoneBarrier;
    private double smallestH;
    private double maximumError;
    private double stepSize = 1.0;
    static double a2 = 0.2;
    static double a3 = 0.3;
    static double a4 = 0.6;
    static double a5 = 1.0;
    static double a6 = 0.875;
    static double b21 = 0.2;
    static double b31 = 0.075;
    static double b32 = 0.225;
    static double b41 = 0.3;
    static double b42 = -0.9;
    static double b43 = 1.2;
    static double b51 = -0.2037037037037037;
    static double b52 = 2.5;
    static double b53 = -2.5925925925925926;
    static double b54 = 1.2962962962962963;
    static double b61 = 0.029495804398148147;
    static double b62 = 0.341796875;
    static double b63 = 0.041594328703703706;
    static double b64 = 0.40034541377314814;
    static double b65 = 0.061767578125;
    static double c1 = 0.09788359788359788;
    static double c3 = 0.4025764895330113;
    static double c4 = 0.21043771043771045;
    static double c6 = 0.2891022021456804;
    static double dc5 = -0.019321986607142856;
    static double dc1 = c1 - 0.10217737268518519;
    static double dc3 = c3 - 0.38390790343915343;
    static double dc4 = c4 - 0.24459273726851852;
    static double dc6 = c6 - 0.25;
    static double SAFETY = 0.9;
    static double PGROW = -0.2;
    static double PSHRNK = -0.25;
    static double ERRCON = 1.89E-4;
    static double TINY = 1.0E-30;
    private static int MAX_PROGRESS_REPORTS = 5;
    protected static final double RELATIVE_TOLERANCE_EDEFAULT = 1.0E-9;
    protected double relativeTolerance = 1.0E-9;
    protected static final double MIN_STEP_EDEFAULT = 1.0E-15;
    protected double minStep = 1.0E-15;
    private static boolean CHECK_SANE = false;
    private HashMap<URI, DynamicLabel> labelValueSnapshot;
    private HashMap<URI, LabelValue> deltaLabelValueSnapshot = new HashMap();

    public boolean step(STEMTime time, long timeDelta, int cycle) throws SolverException {
        Activator act = Activator.getDefault();
        if (act != null) {
            IPreferenceStore preferenceStore = act.getPreferenceStore();
            this.num_threads = (short)preferenceStore.getInt("simulationThreads");
        } else {
            this.num_threads = (short)2;
        }
        this.partitioner.setNumProcesses((int)this.num_threads);
        int c = cycle;
        this.stepSizeBarrier = new CyclicBarrier(this.num_threads, new Runnable(){

            @Override
            public void run() {
                RungeKuttaImpl.this.smallestH = Double.MAX_VALUE;
                RungeKuttaImpl.this.maximumError = -1.7976931348623157E308;
                int i = 0;
                while (i < RungeKuttaImpl.this.num_threads) {
                    if (RungeKuttaImpl.this.jobs[i].h <= RungeKuttaImpl.this.smallestH) {
                        if (RungeKuttaImpl.this.maximumError < RungeKuttaImpl.this.jobs[i].maxerror) {
                            RungeKuttaImpl.this.maximumError = RungeKuttaImpl.this.jobs[i].maxerror;
                        }
                        RungeKuttaImpl.this.smallestH = RungeKuttaImpl.this.jobs[i].h;
                    }
                    ++i;
                }
            }
        });
        this.updateDoneBarrier = new CyclicBarrier(this.num_threads);
        ArrayList decoratorsToIterate = new ArrayList(this.getCanonicalGraph().getDecorators());
        for (Decorator decorator : decoratorsToIterate) {
            if (!(decorator instanceof Trigger) && !(decorator instanceof TransformationDecorator)) continue;
            decorator.updateLabels(time, timeDelta, cycle);
        }
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            EList allLabels = this.partitioner.partitionDecoratorLabels(decorator);
            Iterator currentStateLabelIter = allLabels.iterator();
            while (currentStateLabelIter.hasNext()) {
                if (decorator instanceof IntegrationDecorator) {
                    IntegrationLabel iLabel = (IntegrationLabel)currentStateLabelIter.next();
                    iLabel.getProbeValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    iLabel.getTempValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    iLabel.getTempValue().prepareCycle();
                    iLabel.getProbeValue().prepareCycle();
                    continue;
                }
                currentStateLabelIter.next();
            }
        }
        if (this.jobs == null || this.jobs.length != this.num_threads) {
            this.jobs = new RkJob[this.num_threads];
            short i = 0;
            while (i < this.num_threads) {
                short threadnum = i;
                this.jobs[i] = new RkJob("Worker " + i, threadnum, this);
                this.jobs[i].setSystem(true);
                i = (short)(i + 1);
            }
        }
        RkJob[] rkJobArray = this.jobs;
        int allLabels = this.jobs.length;
        int n = 0;
        while (n < allLabels) {
            RkJob j = rkJobArray[n];
            j.cycle = c;
            j.time = time;
            j.timeDelta = timeDelta;
            ++n;
        }
        rkJobArray = this.jobs;
        allLabels = this.jobs.length;
        n = 0;
        while (n < allLabels) {
            RkJob j = rkJobArray[n];
            j.schedule();
            ++n;
        }
        rkJobArray = this.jobs;
        allLabels = this.jobs.length;
        n = 0;
        while (n < allLabels) {
            RkJob j = rkJobArray[n];
            try {
                j.join();
                if (j.getResult().getException() != null) {
                    throw new SolverException(j.getResult().getException().getMessage(), null, j.getResult().getException());
                }
            }
            catch (InterruptedException ie) {
                Activator.logError((String)ie.getMessage(), (Throwable)ie);
            }
            ++n;
        }
        double minStep = Double.MAX_VALUE;
        double currentT = this.jobs[0].t;
        RkJob[] rkJobArray2 = this.jobs;
        int n2 = this.jobs.length;
        int n3 = 0;
        while (n3 < n2) {
            RkJob j = rkJobArray2[n3];
            if (j.h < minStep) {
                minStep = j.h;
            }
            if (j.t != currentT) {
                Activator.logError((String)("Error, one thread was in misstep with other threads, its time was " + j.t + " versus " + currentT), (Throwable)new Exception());
            }
            ++n3;
        }
        return true;
    }

    /*
     * Could not resolve type clashes
     */
    protected void _step(STEMTime time, long timeDelta, int cycle, short threadnum) {
        ArrayList<IntegrationDecorator> iDecorators = new ArrayList<IntegrationDecorator>();
        ArrayList<Decorator> transDecorators = new ArrayList<Decorator>();
        for (Decorator d : this.getCanonicalGraph().getDecorators()) {
            if (d instanceof IntegrationDecorator) {
                iDecorators.add((IntegrationDecorator)d);
            }
            if (!(d instanceof TransformationDecorator)) continue;
            transDecorators.add(d);
        }
        double h = this.getStepSize();
        double x = (double)cycle - 1.0;
        double end = x + 1.0;
        boolean workToDo = false;
        int i = 0;
        while (i < iDecorators.size()) {
            Decorator sdm = (Decorator)iDecorators.get(i);
            if (this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum).size() > 0) {
                workToDo = true;
                break;
            }
            ++i;
        }
        if (!workToDo) {
            this.jobs[threadnum].h = h;
            this.jobs[threadnum].t = x;
            while (x < end) {
                try {
                    do {
                        this.jobs[threadnum].h = Double.MAX_VALUE;
                        this.stepSizeBarrier.await();
                    } while (this.maximumError > 1.0);
                    this.updateDoneBarrier.await();
                }
                catch (InterruptedException ie) {
                    Activator.logError((String)ie.getMessage(), (Throwable)ie);
                }
                catch (BrokenBarrierException bbe) {
                    Activator.logError((String)bbe.getMessage(), (Throwable)bbe);
                }
                h = this.smallestH;
                this.jobs[threadnum].h = h;
                this.jobs[threadnum].t = x += h;
            }
            return;
        }
        HashMap<IntegrationLabel, IntegrationLabelValue> k1map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        HashMap<IntegrationLabel, IntegrationLabelValue> k2map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        HashMap<IntegrationLabel, IntegrationLabelValue> k3map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        HashMap<IntegrationLabel, IntegrationLabelValue> k4map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        HashMap<IntegrationLabel, IntegrationLabelValue> k5map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        HashMap<IntegrationLabel, IntegrationLabelValue> k6map = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        HashMap<EClass, Object> _k1Placeholdes = new HashMap<EClass, Object>();
        HashMap<EClass, Object> _k2Placeholdes = new HashMap<EClass, Object>();
        HashMap<EClass, Object> _k3Placeholdes = new HashMap<EClass, Object>();
        HashMap<EClass, Object> _k4Placeholdes = new HashMap<EClass, Object>();
        HashMap<EClass, Object> _k5Placeholdes = new HashMap<EClass, Object>();
        HashMap<EClass, Object> _k6Placeholdes = new HashMap<EClass, Object>();
        HashMap<IntegrationLabel, IntegrationLabelValue> finalEstimate = new HashMap<IntegrationLabel, IntegrationLabelValue>();
        double delta = 0.0;
        int i2 = 0;
        while (i2 < iDecorators.size()) {
            Decorator sdm = (Decorator)iDecorators.get(i2);
            Iterator iter = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum).iterator();
            if (!iter.hasNext()) {
                Activator.logError((String)("Problem detected: Decorator " + sdm + " had no labels to update. Please check your scenario."), (Throwable)new Exception());
            } else if (sdm instanceof DiseaseModel) {
                DiseaseModel diseaseModel = (DiseaseModel)sdm;
                for (String id : diseaseModel.getAllLabelIdentifiers()) {
                    DiseaseModelLabel label = diseaseModel.createDiseaseModelLabel(id);
                    if (!_k1Placeholdes.containsKey(label.eClass())) {
                        _k1Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                    }
                    if (!_k2Placeholdes.containsKey(label.eClass())) {
                        _k2Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                    }
                    if (!_k3Placeholdes.containsKey(label.eClass())) {
                        _k3Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                    }
                    if (!_k4Placeholdes.containsKey(label.eClass())) {
                        _k4Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                    }
                    if (!_k5Placeholdes.containsKey(label.eClass())) {
                        _k5Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                    }
                    if (_k6Placeholdes.containsKey(label.eClass())) continue;
                    _k6Placeholdes.put(label.eClass(), diseaseModel.createDiseaseModelLabelValue(id));
                }
            } else {
                IntegrationLabel firstLabel = (IntegrationLabel)iter.next();
                if (!_k1Placeholdes.containsKey(firstLabel.eClass())) {
                    _k1Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                }
                if (!_k2Placeholdes.containsKey(firstLabel.eClass())) {
                    _k2Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                }
                if (!_k3Placeholdes.containsKey(firstLabel.eClass())) {
                    _k3Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                }
                if (!_k4Placeholdes.containsKey(firstLabel.eClass())) {
                    _k4Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                }
                if (!_k5Placeholdes.containsKey(firstLabel.eClass())) {
                    _k5Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                }
                if (!_k6Placeholdes.containsKey(firstLabel.eClass())) {
                    _k6Placeholdes.put(firstLabel.eClass(), ((IntegrationLabelValue)firstLabel.getCurrentValue()).copy());
                }
            }
            ++i2;
        }
        double nextProgressReportStep = (double)this.num_threads * (end - x) / (double)MAX_PROGRESS_REPORTS;
        double nextProgressReport = x + nextProgressReportStep;
        while (x < end) {
            IntegrationLabel diseaseLabel;
            EList labs;
            Decorator sdm;
            IntegrationLabelValue k4;
            IntegrationLabelValue k3;
            IntegrationLabelValue k2;
            IntegrationLabelValue k1;
            IntegrationLabelValue deltaLabel;
            IntegrationLabel diseaseLabel2;
            int j;
            EList labs2;
            Decorator sdm2;
            k1map.clear();
            k2map.clear();
            k3map.clear();
            k4map.clear();
            k5map.clear();
            k6map.clear();
            finalEstimate.clear();
            boolean retry = false;
            if (CHECK_SANE) {
                this.getLabelSnapshot(threadnum, iDecorators);
            }
            int i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).calculateDeltas(time, x, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).applyExternalDeltas(time, x, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                labs2 = this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum);
                j = 0;
                while (j < labs2.size()) {
                    diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                    IntegrationLabelValue scale = diseaseLabel2.getErrorScale();
                    scale.set(diseaseLabel2.getTempValue());
                    IntegrationLabelValue dt = diseaseLabel2.getDeltaValue().copy();
                    dt.scale(h);
                    dt.abs();
                    dt.add(TINY);
                    scale.abs();
                    scale.add(dt);
                    ++j;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                labs2 = this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum);
                j = 0;
                while (j < labs2.size()) {
                    diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                    deltaLabel = diseaseLabel2.getDeltaValue();
                    IntegrationLabelValue copyVal = deltaLabel.copy();
                    k1map.put(diseaseLabel2, copyVal);
                    if (CHECK_SANE && retry) {
                        this.checkDeltaLabelSame((LabelValue)deltaLabel);
                    }
                    if (CHECK_SANE) {
                        this.deltaLabelValueSnapshot.put(diseaseLabel2.getURI(), (LabelValue)copyVal);
                    }
                    deltaLabel.scale(h);
                    deltaLabel.scale(b21);
                    diseaseLabel2.getProbeValue().set(deltaLabel.add(diseaseLabel2.getTempValue()));
                    ++j;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).calculateDeltas(time, x + a2 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).applyExternalDeltas(time, x + a2 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                labs2 = this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum);
                j = 0;
                while (j < labs2.size()) {
                    diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                    deltaLabel = diseaseLabel2.getDeltaValue();
                    k2map.put(diseaseLabel2, deltaLabel.copy());
                    k1 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel2.eClass());
                    k2 = (IntegrationLabelValue)_k2Placeholdes.get(diseaseLabel2.eClass());
                    k1.set((IntegrationLabelValue)k1map.get(diseaseLabel2));
                    k2.set(deltaLabel);
                    IntegrationLabelValue estDelta = k1.scale(b31);
                    k2.scale(b32);
                    estDelta.add(k2);
                    estDelta.scale(h);
                    diseaseLabel2.getProbeValue().set(estDelta.add(diseaseLabel2.getTempValue()));
                    ++j;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).calculateDeltas(time, x + a3 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).applyExternalDeltas(time, x + a3 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                labs2 = this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum);
                j = 0;
                while (j < labs2.size()) {
                    diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                    deltaLabel = diseaseLabel2.getDeltaValue();
                    k3map.put(diseaseLabel2, deltaLabel.copy());
                    k1 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel2.eClass());
                    k2 = (IntegrationLabelValue)_k2Placeholdes.get(diseaseLabel2.eClass());
                    k3 = (IntegrationLabelValue)_k3Placeholdes.get(diseaseLabel2.eClass());
                    k1.set((IntegrationLabelValue)k1map.get(diseaseLabel2));
                    k2.set((IntegrationLabelValue)k2map.get(diseaseLabel2));
                    k3.set(deltaLabel);
                    k1.scale(b41);
                    k2.scale(b42);
                    k3.scale(b43);
                    IntegrationLabelValue estDelta = k1;
                    estDelta.add(k2);
                    estDelta.add(k3);
                    estDelta.scale(h);
                    diseaseLabel2.getProbeValue().set(estDelta.add(diseaseLabel2.getTempValue()));
                    ++j;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).calculateDeltas(time, x + a4 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).applyExternalDeltas(time, x + a4 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                labs2 = this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum);
                j = 0;
                while (j < labs2.size()) {
                    diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                    deltaLabel = diseaseLabel2.getDeltaValue();
                    k4map.put(diseaseLabel2, deltaLabel.copy());
                    k1 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel2.eClass());
                    k2 = (IntegrationLabelValue)_k2Placeholdes.get(diseaseLabel2.eClass());
                    k3 = (IntegrationLabelValue)_k3Placeholdes.get(diseaseLabel2.eClass());
                    k4 = (IntegrationLabelValue)_k4Placeholdes.get(diseaseLabel2.eClass());
                    k1.set((IntegrationLabelValue)k1map.get(diseaseLabel2));
                    k2.set((IntegrationLabelValue)k2map.get(diseaseLabel2));
                    k3.set((IntegrationLabelValue)k3map.get(diseaseLabel2));
                    k4.set(deltaLabel);
                    k1.scale(b51);
                    k2.scale(b52);
                    k3.scale(b53);
                    k4.scale(b54);
                    IntegrationLabelValue estDelta = k1;
                    estDelta.add(k2);
                    estDelta.add(k3);
                    estDelta.add(k4);
                    estDelta.scale(h);
                    diseaseLabel2.getProbeValue().set(estDelta.add(diseaseLabel2.getTempValue()));
                    ++j;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).calculateDeltas(time, x + a5 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).applyExternalDeltas(time, x + a5 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                labs2 = this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum);
                j = 0;
                while (j < labs2.size()) {
                    diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                    deltaLabel = diseaseLabel2.getDeltaValue();
                    k5map.put(diseaseLabel2, deltaLabel.copy());
                    k1 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel2.eClass());
                    k2 = (IntegrationLabelValue)_k2Placeholdes.get(diseaseLabel2.eClass());
                    k3 = (IntegrationLabelValue)_k3Placeholdes.get(diseaseLabel2.eClass());
                    k4 = (IntegrationLabelValue)_k4Placeholdes.get(diseaseLabel2.eClass());
                    IntegrationLabelValue k5 = (IntegrationLabelValue)_k5Placeholdes.get(diseaseLabel2.eClass());
                    k1.set((IntegrationLabelValue)k1map.get(diseaseLabel2));
                    k2.set((IntegrationLabelValue)k2map.get(diseaseLabel2));
                    k3.set((IntegrationLabelValue)k3map.get(diseaseLabel2));
                    k4.set((IntegrationLabelValue)k4map.get(diseaseLabel2));
                    k5.set(deltaLabel);
                    k1.scale(b61);
                    k2.scale(b62);
                    k3.scale(b63);
                    k4.scale(b64);
                    k5.scale(b65);
                    IntegrationLabelValue estDelta = k1;
                    estDelta.add(k2);
                    estDelta.add(k3);
                    estDelta.add(k4);
                    estDelta.add(k5);
                    estDelta.scale(h);
                    diseaseLabel2.getProbeValue().set(estDelta.add(diseaseLabel2.getTempValue()));
                    ++j;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).calculateDeltas(time, x + a6 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                ((IntegrationDecorator)sdm2).applyExternalDeltas(time, x + a6 * h, timeDelta, this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum));
                ++i3;
            }
            i3 = 0;
            while (i3 < iDecorators.size()) {
                sdm2 = (Decorator)iDecorators.get(i3);
                labs2 = this.partitioner.partitionDecoratorLabels(sdm2, (int)threadnum);
                j = 0;
                while (j < labs2.size()) {
                    diseaseLabel2 = (IntegrationLabel)labs2.get(j);
                    deltaLabel = diseaseLabel2.getDeltaValue();
                    k6map.put(diseaseLabel2, deltaLabel.copy());
                    ++j;
                }
                ++i3;
            }
            boolean success = true;
            double maxerror = 0.0;
            int i4 = 0;
            while (i4 < iDecorators.size()) {
                sdm = (Decorator)iDecorators.get(i4);
                labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                int j2 = 0;
                while (j2 < labs.size()) {
                    diseaseLabel = (IntegrationLabel)labs.get(j2);
                    IntegrationLabelValue currentValue = diseaseLabel.getTempValue();
                    IntegrationLabelValue k12 = (IntegrationLabelValue)_k1Placeholdes.get(diseaseLabel.eClass());
                    IntegrationLabelValue k32 = (IntegrationLabelValue)_k3Placeholdes.get(diseaseLabel.eClass());
                    IntegrationLabelValue k42 = (IntegrationLabelValue)_k4Placeholdes.get(diseaseLabel.eClass());
                    IntegrationLabelValue k5 = (IntegrationLabelValue)_k5Placeholdes.get(diseaseLabel.eClass());
                    IntegrationLabelValue k6 = (IntegrationLabelValue)_k6Placeholdes.get(diseaseLabel.eClass());
                    k12.set((IntegrationLabelValue)k1map.get(diseaseLabel));
                    k32.set((IntegrationLabelValue)k3map.get(diseaseLabel));
                    k42.set((IntegrationLabelValue)k4map.get(diseaseLabel));
                    k5.set((IntegrationLabelValue)k5map.get(diseaseLabel));
                    k6.set((IntegrationLabelValue)k6map.get(diseaseLabel));
                    k12.scale(c1);
                    k32.scale(c3);
                    k42.scale(c4);
                    k6.scale(c6);
                    IntegrationLabelValue yout = k12.add(k32).add(k42).add(k6).copy();
                    yout.scale(h);
                    yout.add(currentValue);
                    k12.set((IntegrationLabelValue)k1map.get(diseaseLabel));
                    k32.set((IntegrationLabelValue)k3map.get(diseaseLabel));
                    k42.set((IntegrationLabelValue)k4map.get(diseaseLabel));
                    k5.set((IntegrationLabelValue)k5map.get(diseaseLabel));
                    k6.set((IntegrationLabelValue)k6map.get(diseaseLabel));
                    k12.scale(dc1);
                    k32.scale(dc3);
                    k42.scale(dc4);
                    k5.scale(dc5);
                    k6.scale(dc6);
                    IntegrationLabelValue yerror = k12.add(k32).add(k42).add(k5).add(k6).copy();
                    yerror.scale(h);
                    yerror.divide(diseaseLabel.getErrorScale());
                    yerror.abs();
                    double error = yerror.max();
                    error /= this.getRelativeTolerance();
                    if (h < this.getMinStep()) {
                        error = ERRCON;
                    }
                    if (error > maxerror) {
                        maxerror = error;
                    }
                    if (error <= 1.0) {
                        finalEstimate.put(diseaseLabel, yout.copy());
                    }
                    ++j2;
                }
                ++i4;
            }
            this.jobs[threadnum].h = h;
            this.jobs[threadnum].maxerror = maxerror;
            try {
                this.stepSizeBarrier.await();
            }
            catch (InterruptedException ie) {
                Activator.logError((String)ie.getMessage(), (Throwable)ie);
            }
            catch (BrokenBarrierException bbe) {
                Activator.logError((String)bbe.getMessage(), (Throwable)bbe);
            }
            if (this.maximumError > 1.0) {
                success = false;
            }
            if (success) {
                retry = false;
                if (this.smallestH > h) {
                    Activator.logError((String)("Error, h was less than the smallest, perhaps barrier process failed to execute? h:" + h + " vs " + this.smallestH), (Throwable)new Exception());
                }
                x += h;
                h = this.maximumError > ERRCON ? SAFETY * h * Math.pow(this.maximumError, PGROW) : (h *= 5.0);
                if (h > 1.0) {
                    h = 1.0;
                }
                if (x < end && x + h > end) {
                    h = end - x;
                }
                i = 0;
                while (i < iDecorators.size()) {
                    sdm = (Decorator)iDecorators.get(i);
                    labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                    int j3 = 0;
                    while (j3 < labs.size()) {
                        diseaseLabel = (IntegrationLabel)labs.get(j3);
                        diseaseLabel.getTempValue().set((IntegrationLabelValue)finalEstimate.get(diseaseLabel));
                        diseaseLabel.getProbeValue().set((IntegrationLabelValue)finalEstimate.get(diseaseLabel));
                        ++j3;
                    }
                    ++i;
                }
                try {
                    this.updateDoneBarrier.await();
                }
                catch (InterruptedException ie) {
                    Activator.logError((String)ie.getMessage(), (Throwable)ie);
                }
                catch (BrokenBarrierException bbe) {
                    Activator.logError((String)bbe.getMessage(), (Throwable)bbe);
                }
                double progress = end - x < 0.0 ? 1.0 : 1.0 - (end - x);
                this.jobs[threadnum].setProgress(progress);
                if (x > nextProgressReport) {
                    int i5 = 0;
                    while (i5 < this.num_threads) {
                        if (i5 != threadnum && this.jobs[i5] != null) {
                            progress += this.jobs[i5].getProgress();
                        }
                        ++i5;
                    }
                    progress /= (double)this.num_threads;
                    for (Decorator sdm3 : iDecorators) {
                        sdm3.setProgress(progress);
                    }
                    nextProgressReport += nextProgressReportStep;
                }
                if (!CHECK_SANE) continue;
                this.checkLabelSanity(threadnum, iDecorators, false);
                continue;
            }
            retry = true;
            delta = SAFETY * h * Math.pow(this.maximumError, PSHRNK);
            h = h > 0.0 ? (delta > 0.1 * h ? delta : 0.1 * h) : (delta > 0.1 * h ? 0.1 * h : delta);
            i = 0;
            while (i < iDecorators.size()) {
                sdm = (Decorator)iDecorators.get(i);
                labs = this.partitioner.partitionDecoratorLabels(sdm, (int)threadnum);
                int j4 = 0;
                while (j4 < labs.size()) {
                    diseaseLabel = (IntegrationLabel)labs.get(j4);
                    diseaseLabel.getProbeValue().set(diseaseLabel.getTempValue());
                    ++j4;
                }
                ++i;
            }
            if (!CHECK_SANE) continue;
            this.checkLabelSanity(threadnum, iDecorators, true);
        }
        this.jobs[threadnum].t = x;
        this.jobs[threadnum].h = h;
        this.setStepSize(h);
        int i6 = 0;
        while (i6 < iDecorators.size()) {
            IntegrationDecorator sdm = iDecorators.get(i6);
            EList labs = this.partitioner.partitionDecoratorLabels((Decorator)sdm, (int)threadnum);
            int j = 0;
            while (j < labs.size()) {
                IntegrationLabel diseaseLabel = (IntegrationLabel)labs.get(j);
                IntegrationLabelValue nextState = (IntegrationLabelValue)diseaseLabel.getNextValue();
                IntegrationLabelValue newValue = (IntegrationLabelValue)finalEstimate.get(diseaseLabel);
                nextState.set(newValue);
                if (sdm.isAddStochasticNoise()) {
                    sdm.doStochasticProcess(diseaseLabel, timeDelta);
                }
                diseaseLabel.setNextValueValid(true);
                ++j;
            }
            ++i6;
        }
    }

    void adjustValuesToCycle(IntegrationLabelValue currentValue, IntegrationLabelValue nextValueAtX, double x, int cycle) {
        IntegrationLabelValue result = currentValue.copy();
        nextValueAtX.sub(currentValue);
        nextValueAtX.scale(1.0 / (x - (double)cycle + 1.0));
        nextValueAtX.set(result.add(nextValueAtX));
    }

    public void reset() {
        this.setStepSize(1.0);
        this.setInitialized(false);
    }

    protected double getStepSize() {
        return this.stepSize;
    }

    protected void setStepSize(double d) {
        this.stepSize = d;
    }

    protected EClass eStaticClass() {
        return RkPackage.Literals.RUNGE_KUTTA;
    }

    @Override
    public double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    @Override
    public void setRelativeTolerance(double newRelativeTolerance) {
        double oldRelativeTolerance = this.relativeTolerance;
        this.relativeTolerance = newRelativeTolerance;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldRelativeTolerance, this.relativeTolerance));
        }
    }

    @Override
    public double getMinStep() {
        return this.minStep;
    }

    @Override
    public void setMinStep(double newMinStep) {
        double oldMinStep = this.minStep;
        this.minStep = newMinStep;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldMinStep, this.minStep));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getRelativeTolerance();
            }
            case 6: {
                return this.getMinStep();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setRelativeTolerance((Double)newValue);
                return;
            }
            case 6: {
                this.setMinStep((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setRelativeTolerance(1.0E-9);
                return;
            }
            case 6: {
                this.setMinStep(1.0E-15);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.relativeTolerance != 1.0E-9;
            }
            case 6: {
                return this.minStep != 1.0E-15;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (relativeTolerance: ");
        result.append(this.relativeTolerance);
        result.append(", minStep: ");
        result.append(this.minStep);
        result.append(')');
        return result.toString();
    }

    private void getLabelSnapshot(short threadnum, ArrayList<IntegrationDecorator> iDecorators) {
        if (this.labelValueSnapshot == null) {
            this.labelValueSnapshot = new HashMap();
        }
        for (Decorator decorator : iDecorators) {
            for (DynamicLabel label : this.partitioner.partitionDecoratorLabels(decorator, (int)threadnum)) {
                DynamicLabel copy = (DynamicLabel)EcoreUtil.copy((EObject)label);
                ((Node)label.getIdentifiable()).getLabels().remove((Object)copy);
                this.labelValueSnapshot.put(label.getURI(), copy);
            }
        }
    }

    private void checkLabelSanity(short threadnum, ArrayList<IntegrationDecorator> iDecorators, boolean retry) {
        for (Decorator decorator : iDecorators) {
            for (DynamicLabel label : this.partitioner.partitionDecoratorLabels(decorator, (int)threadnum)) {
                DynamicLabel snapLabel = this.labelValueSnapshot.get(label.getURI());
                if (!label.getCurrentValue().sameValue(snapLabel.getCurrentValue())) {
                    System.err.println("Error current label value not the same as in snapshot for " + label + ". Retry was " + retry);
                }
                if (!retry || ((IntegrationLabel)label).getTempValue().sameValue((LabelValue)((IntegrationLabel)snapLabel).getTempValue())) continue;
                System.err.println("Error temp label value not the same as in snapshot for " + label + " Retry was " + retry);
            }
        }
    }

    private void checkDeltaLabelSame(LabelValue lab) {
        LabelValue labelval = this.deltaLabelValueSnapshot.get(((DynamicLabel)lab).getURI());
        if (labelval == null) {
            return;
        }
        if (!labelval.sameValue(lab)) {
            System.err.println("Error delta label value not the same as in snapshot for " + lab);
        }
    }
}

