/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stem.model.ui.MetamodelEditorPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class LoadBundleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.installBundle(project);
            }
        }
        return null;
    }

    protected void installBundle(IProject project) {
        System.out.println("Installing bundle from project " + project.getName());
        BundleContext ctx = MetamodelEditorPlugin.getPlugin().getBundle().getBundleContext();
        Bundle b = Platform.getBundle((String)project.getName());
        if (b == null) {
            Bundle newBundle = null;
            try {
                newBundle = ctx.installBundle(project.getLocationURI().toString());
                newBundle.start();
            }
            catch (BundleException e) {
                if (newBundle != null) {
                    try {
                        System.err.println("Install and/or start failed, trying to uninstall.");
                        newBundle.uninstall();
                    }
                    catch (BundleException bundleException) {}
                }
                Status status = new Status(4, project.getName(), "Error installing into OSGi container", (Throwable)e);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)("Error installing the project " + project.getName() + " into the OSGi constainer"), (IStatus)status);
                e.printStackTrace();
            }
        }
    }
}

