/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.modifier.FeatureModifier;
import org.eclipse.stem.core.modifier.NOPModifier;
import org.eclipse.stem.core.modifier.RangeModifier;
import org.eclipse.stem.core.modifier.SequenceModifier;
import org.eclipse.stem.core.modifier.SingleValueModifier;
import org.eclipse.stem.ui.adapters.featuremodifier.EStructuralFeatureFeatureModifierAdapterFactory;
import org.eclipse.stem.ui.adapters.featuremodifiereditcomposite.FeatureModifierEditCompositeAdapter;
import org.eclipse.stem.ui.adapters.featuremodifiereditcomposite.FeatureModifierFeatureModifierEditCompositeAdapterFactory;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public abstract class NewModifierPage
extends NewIdentifiablePage {
    protected EObject target;
    private final List<FeatureModifierComposite> featureModifierComposites = new ArrayList<FeatureModifierComposite>();

    protected NewModifierPage(EObject target) {
        super(Messages.getString("NModifierWiz.page_title"));
        this.setTitle(Messages.getString("NModifierWiz.page_title"));
        this.setDescription(Messages.getString("NModifierWiz.page_description"));
        this.target = target;
    }

    @Override
    protected Composite createSpecificComposite(Composite parent) {
        Composite outerComposite = new Composite(parent, 2048);
        outerComposite.setLayout((Layout)new FillLayout());
        ScrolledComposite scrolledComposite = new ScrolledComposite(outerComposite, 2816);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite innerComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)innerComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        innerComposite.setLayout((Layout)layout);
        scrolledComposite.setMinSize(innerComposite.computeSize(-1, -1));
        innerComposite.setSize(innerComposite.computeSize(-1, -1));
        innerComposite.layout();
        Point innerSize = innerComposite.computeSize(-1, -1);
        scrolledComposite.setSize(innerSize);
        outerComposite.setSize(innerSize);
        innerComposite.layout();
        outerComposite.layout();
        parent.layout();
        PropertyStringProviderAdapter pspa = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)this.target, PropertyStringProvider.class);
        ComposedAdapterFactory itemProviderFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)this.target, IItemPropertySource.class);
        List properties = propertySource.getPropertyDescriptors((Object)this.target);
        for (IItemPropertyDescriptor descriptor : properties) {
            EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
            if (!this.isUserSpecifiedProperty(feature)) continue;
            Label label = new Label(innerComposite, 0);
            label.setText(pspa.getPropertyName(descriptor));
            GridData gridData1 = new GridData(1);
            gridData1.horizontalAlignment = 1;
            gridData1.horizontalIndent = 0;
            label.setLayoutData((Object)gridData1);
            FeatureModifierComposite featureModifierComposite = new FeatureModifierComposite(innerComposite, this.target, feature, pspa, descriptor, this.isModifiableProperty(feature), this);
            GridData gridData2 = new GridData(1);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            gridData2.horizontalIndent = 0;
            featureModifierComposite.setLayoutData(gridData2);
            this.featureModifierComposites.add(featureModifierComposite);
        }
        String bottomText = this.getBottomText();
        if (bottomText != null) {
            Label bottomTextLabel = new Label(innerComposite, 0);
            bottomTextLabel.setText(bottomText);
            GridData bottomTextGD = new GridData(3);
            bottomTextGD.grabExcessHorizontalSpace = true;
            bottomTextGD.horizontalSpan = 2;
            bottomTextLabel.setLayoutData((Object)bottomTextGD);
        }
        innerSize = innerComposite.computeSize(-1, -1);
        innerComposite.setSize(innerSize);
        innerComposite.layout();
        scrolledComposite.setMinSize(innerSize);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newmodifier_contextid");
        return outerComposite;
    }

    protected boolean isUserSpecifiedProperty(EStructuralFeature feature) {
        boolean retValue = !feature.getEContainingClass().equals(CommonPackage.Literals.DUBLIN_CORE);
        retValue = retValue && !(feature instanceof EReference);
        return retValue;
    }

    protected String getBottomText() {
        return null;
    }

    protected boolean isModifiableProperty(EStructuralFeature feature) {
        boolean retValue = false;
        retValue |= feature.getEType().equals(EcorePackage.Literals.EINT);
        retValue |= feature.getEType().equals(EcorePackage.Literals.ELONG);
        return retValue |= feature.getEType().equals(EcorePackage.Literals.EDOUBLE);
    }

    public final List<FeatureModifier> getFeatureModifiers() {
        ArrayList<FeatureModifier> retValue = new ArrayList<FeatureModifier>();
        for (FeatureModifierComposite featureModifierComposite : this.featureModifierComposites) {
            FeatureModifier featureModifier = featureModifierComposite.getFeatureModifier();
            if (featureModifier instanceof NOPModifier) continue;
            featureModifier.setTarget(this.target);
            retValue.add(featureModifier);
        }
        return retValue;
    }

    @Override
    public boolean validatePage() {
        return super.validatePage();
    }

    protected static class FeatureModifierComposite
    extends Composite {
        final Composite editCompositeHolder;
        private FeatureModifierEditComposite editComposite;
        FeatureModifier featureModifier = null;
        Button noneButton = null;
        Button singleButton = null;
        Button rangeButton = null;
        Button sequenceButton = null;

        public FeatureModifierComposite(Composite parent, final EObject target, final EStructuralFeature feature, PropertyStringProvider psp, IItemPropertyDescriptor descriptor, boolean modifiable, final NewModifierPage parentNewModifierPage) {
            super(parent, 0);
            FormLayout layout = new FormLayout();
            layout.spacing = 2;
            this.setLayout((Layout)layout);
            this.editCompositeHolder = new Composite((Composite)this, 0);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginHeight = 0;
            fillLayout.marginWidth = 0;
            this.editCompositeHolder.setLayout((Layout)fillLayout);
            this.editCompositeHolder.setToolTipText(psp.getPropertyToolTip(descriptor));
            Label unitLabel = new Label((Composite)this, 0);
            unitLabel.setText(psp.getPropertyUnits(descriptor));
            Group group = new Group((Composite)this, 16);
            group.setText("Select Modifier Type");
            group.setLayout((Layout)new RowLayout(256));
            group.setEnabled(modifiable);
            this.noneButton = new Button((Composite)group, 16);
            this.noneButton.setText("None");
            this.noneButton.setEnabled(modifiable);
            this.singleButton = new Button((Composite)group, 16);
            this.singleButton.setText(Messages.getString("Single.type"));
            this.singleButton.setEnabled(modifiable);
            this.rangeButton = new Button((Composite)group, 16);
            this.rangeButton.setText(Messages.getString("Range.type"));
            this.rangeButton.setEnabled(modifiable);
            this.sequenceButton = new Button((Composite)group, 16);
            this.sequenceButton.setText(Messages.getString("Sequence.type"));
            this.sequenceButton.setEnabled(modifiable);
            int offset = 10;
            FormData formData = new FormData();
            formData.left = new FormAttachment(0, 0);
            formData.top = new FormAttachment(0, 10);
            this.editCompositeHolder.setLayoutData((Object)formData);
            formData = new FormData();
            formData.left = new FormAttachment((Control)this.editCompositeHolder, 0, 131072);
            formData.right = new FormAttachment((Control)group, 0, 16384);
            formData.bottom = new FormAttachment((Control)this.editCompositeHolder, -3, 1024);
            unitLabel.setLayoutData((Object)formData);
            formData = new FormData();
            formData.right = new FormAttachment(100, 0);
            group.setLayoutData((Object)formData);
            this.setFeatureModifier(EStructuralFeatureFeatureModifierAdapterFactory.INSTANCE.adapt(feature, NOPModifier.class));
            this.switchToFeatureModifier(target, parentNewModifierPage);
            this.noneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (noneButton.getSelection() && !(featureModifier instanceof NOPModifier)) {
                        FeatureModifier fm = EStructuralFeatureFeatureModifierAdapterFactory.INSTANCE.adapt(feature, NOPModifier.class);
                        fm.setTarget((EObject)feature);
                        this.setFeatureModifier(fm);
                        this.switchToFeatureModifier(target, parentNewModifierPage);
                    }
                }
            });
            this.singleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (singleButton.getSelection() && !(featureModifier instanceof SingleValueModifier)) {
                        this.setFeatureModifier(EStructuralFeatureFeatureModifierAdapterFactory.INSTANCE.adapt(feature, SingleValueModifier.class));
                        this.switchToFeatureModifier(target, parentNewModifierPage);
                    }
                }
            });
            this.rangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (rangeButton.getSelection() && !(featureModifier instanceof RangeModifier)) {
                        this.setFeatureModifier(EStructuralFeatureFeatureModifierAdapterFactory.INSTANCE.adapt(feature, RangeModifier.class));
                        this.switchToFeatureModifier(target, parentNewModifierPage);
                    }
                }
            });
            this.sequenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (sequenceButton.getSelection() && !(featureModifier instanceof SequenceModifier)) {
                        this.setFeatureModifier(EStructuralFeatureFeatureModifierAdapterFactory.INSTANCE.adapt(feature, SequenceModifier.class));
                        this.switchToFeatureModifier(target, parentNewModifierPage);
                    }
                }
            });
            this.setSize(500, 150);
        }

        void selectNoneButton() {
            this.noneButton.setSelection(true);
            this.singleButton.setSelection(false);
            this.rangeButton.setSelection(false);
            this.sequenceButton.setSelection(false);
        }

        FeatureModifierEditComposite createDefaultEditComposite(Composite parent, NewModifierPage parentNewModifierPage, Identifiable identifiable, EStructuralFeature feature) {
            FeatureModifierEditComposite retValue = new FeatureModifierEditComposite(parent, parentNewModifierPage, null){

                @Override
                protected boolean validate() {
                    return true;
                }
            };
            retValue.setLayout((Layout)new GridLayout());
            Label label = new Label((Composite)retValue, 133120);
            label.setText(identifiable.eGet(feature).toString());
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 0x1000008;
            label.setLayoutData((Object)gridData);
            return retValue;
        }

        void switchToFeatureModifier(EObject target, NewModifierPage parentNewModifierPage) {
            if (target instanceof org.eclipse.stem.core.graph.Label && target.eClass() != this.featureModifier.getEStructuralFeature().getEContainingClass()) {
                org.eclipse.stem.core.graph.Label label = (org.eclipse.stem.core.graph.Label)target;
                LabelValue lv = (LabelValue)label.eGet((EStructuralFeature)GraphPackage.Literals.LABEL__CURRENT_VALUE);
                this.featureModifier.setTarget((EObject)lv);
            } else {
                this.featureModifier.setTarget(target);
            }
            FeatureModifierEditCompositeAdapter fmecAdapter = (FeatureModifierEditCompositeAdapter)FeatureModifierFeatureModifierEditCompositeAdapterFactory.INSTANCE.adapt((Notifier)this.featureModifier, FeatureModifierEditCompositeAdapter.class);
            fmecAdapter.setTarget((Notifier)this.featureModifier);
            this.setEditComposite(fmecAdapter.createEditComposite(this.editCompositeHolder, target, parentNewModifierPage));
            fmecAdapter.setSelectedButton(this.noneButton, this.singleButton, this.rangeButton, this.sequenceButton);
        }

        void setEditComposite(FeatureModifierEditComposite editComposite) {
            if (this.editComposite != null) {
                this.editComposite.dispose();
            }
            this.editComposite = editComposite;
            this.getShell().layout(true, true);
        }

        public final FeatureModifier getFeatureModifier() {
            return this.featureModifier;
        }

        protected final void setFeatureModifier(FeatureModifier featureModifier) {
            this.featureModifier = featureModifier;
        }
    }

    public static abstract class FeatureModifierEditComposite
    extends Composite {
        protected FeatureModifier featureModifier = null;
        protected NewModifierPage parentNewModifierPage;
        protected ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                parentNewModifierPage.setPageComplete(this.validate());
            }
        };

        public FeatureModifierEditComposite(Composite parent, NewModifierPage parentNewModifierPage, FeatureModifier featureModifier) {
            super(parent, 0);
            this.parentNewModifierPage = parentNewModifierPage;
            this.featureModifier = featureModifier;
        }

        public final FeatureModifier getFeatureModifier() {
            return this.featureModifier;
        }

        public final ModifyListener getModifyListener() {
            return this.modifyListener;
        }

        protected abstract boolean validate();
    }
}

