/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFile;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.depend.AbstractAnalyzer;

public class AntAnalyzer
extends AbstractAnalyzer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void determineDependencies(Vector<File> files, Vector<String> classes) {
        HashSet<String> toAnalyze = new HashSet<String>(Collections.list(this.getRootClasses()));
        int count = 0;
        int maxCount = this.isClosureRequired() ? 1000 : 1;
        HashSet<String> dependencies = new HashSet<String>();
        HashSet<File> containers = new HashSet<File>();
        HashSet<String> analyzedDeps = null;
        while (!toAnalyze.isEmpty() && count++ < maxCount) {
            analyzedDeps = new HashSet<String>();
            for (String classname : toAnalyze) {
                dependencies.add(classname);
                try {
                    File container = this.getClassContainer(classname);
                    if (container == null) continue;
                    containers.add(container);
                    ZipFile zipFile = null;
                    InputStream inStream = null;
                    try {
                        if (container.getName().endsWith(".class")) {
                            inStream = Files.newInputStream(Paths.get(container.getPath(), new String[0]), new OpenOption[0]);
                        } else {
                            zipFile = new ZipFile(container.getPath());
                            String entryName = classname.replace('.', '/') + ".class";
                            ZipEntry entry = new ZipEntry(entryName);
                            inStream = zipFile.getInputStream(entry);
                        }
                        ClassFile classFile = new ClassFile();
                        classFile.read(inStream);
                        for (String dependency : classFile.getClassRefs()) {
                            analyzedDeps.add(dependency);
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(inStream);
                        FileUtils.close(zipFile);
                        throw throwable;
                    }
                    FileUtils.close(inStream);
                    FileUtils.close(zipFile);
                }
                catch (IOException iOException) {
                }
            }
            toAnalyze.clear();
            for (String className : analyzedDeps) {
                if (dependencies.contains(className)) continue;
                toAnalyze.add(className);
            }
        }
        dependencies.addAll(analyzedDeps);
        files.removeAllElements();
        files.addAll(containers);
        classes.removeAllElements();
        classes.addAll(dependencies);
    }

    @Override
    protected boolean supportsFileDependencies() {
        return true;
    }
}

