/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestResultFormatter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

final class TestRequest
implements AutoCloseable {
    private final TestDefinition ownerTest;
    private final LauncherDiscoveryRequestBuilder discoveryRequest;
    private final List<Closeable> closables = new ArrayList<Closeable>();
    private final List<TestResultFormatter> interestedInSysOut = new ArrayList<TestResultFormatter>();
    private final List<TestResultFormatter> interestedInSysErr = new ArrayList<TestResultFormatter>();

    TestRequest(TestDefinition ownerTest, LauncherDiscoveryRequestBuilder discoveryRequest) {
        this.ownerTest = ownerTest;
        this.discoveryRequest = discoveryRequest;
    }

    TestDefinition getOwner() {
        return this.ownerTest;
    }

    LauncherDiscoveryRequestBuilder getDiscoveryRequest() {
        return this.discoveryRequest;
    }

    void closeUponCompletion(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        this.closables.add(closeable);
    }

    void addSysOutInterest(TestResultFormatter out) {
        this.interestedInSysOut.add(out);
    }

    boolean interestedInSysOut() {
        return !this.interestedInSysOut.isEmpty();
    }

    Collection<TestResultFormatter> getSysOutInterests() {
        return Collections.unmodifiableList(this.interestedInSysOut);
    }

    void addSysErrInterest(TestResultFormatter err) {
        this.interestedInSysErr.add(err);
    }

    boolean interestedInSysErr() {
        return !this.interestedInSysErr.isEmpty();
    }

    Collection<TestResultFormatter> getSysErrInterests() {
        return Collections.unmodifiableList(this.interestedInSysErr);
    }

    @Override
    public void close() throws Exception {
        if (this.closables.isEmpty()) {
            return;
        }
        for (Closeable closeable : this.closables) {
            closeable.close();
        }
    }
}

