/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.core.common.CommonFactory;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DublinCorePage
extends WizardPage {
    private static final String REQUIRED_FIELD_CHAR = "*";
    private final ModifyListener dcValidator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            DublinCorePage.this.setPageComplete(DublinCorePage.this.validateDublinCorePage());
        }
    };
    protected Text titleTextField;
    protected Text descriptionTextField;
    protected Text creator;
    protected Text date;
    protected Text format;
    protected Text publisher;
    protected Text coverage;
    protected Text contributor;
    protected Text relation;
    protected Text rights;
    protected Text source;
    protected Text subject;
    protected Text type;
    protected Text language;
    protected Text bibliographicCitation;
    protected Text created;
    protected Text license;
    protected Text required;
    protected Text spatial;
    protected Text valid;

    protected DublinCorePage() {
        super(Messages.getString("NDublinCore.page_title"));
        this.setTitle(Messages.getString("NDublinCore.page_title"));
        this.setDescription(Messages.getString("NDublinCore.page_description"));
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        final Composite pageComposite = new Composite((Composite)scrollComposite, 0);
        GridLayout pageCompositeLayout = new GridLayout();
        pageCompositeLayout.verticalSpacing = 12;
        pageCompositeLayout.numColumns = 2;
        pageCompositeLayout.marginHeight = 0;
        pageCompositeLayout.marginWidth = 0;
        pageComposite.setLayout((Layout)pageCompositeLayout);
        scrollComposite.setContent((Control)pageComposite);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        GridData pageCompositeLayoutData = new GridData();
        pageCompositeLayoutData.grabExcessVerticalSpace = true;
        pageCompositeLayoutData.verticalAlignment = 4;
        pageCompositeLayoutData.horizontalAlignment = 4;
        pageCompositeLayoutData.horizontalSpan = 1;
        pageComposite.setLayoutData((Object)pageCompositeLayoutData);
        this.titleTextField = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.title"), Messages.getString("NDublinCore.titleDesc"), true, true);
        this.descriptionTextField = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.desc"), Messages.getString("NDublinCore.descDesc"), false, false);
        this.creator = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.creator"), Messages.getString("NDublinCore.creatorDesc"), false, false);
        this.date = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.date"), Messages.getString("NDublinCore.dateDesc"), false, true);
        this.valid = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.valid"), Messages.getString("NDublinCore.validDesc"), false, true);
        this.created = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.created"), Messages.getString("NDublinCore.createdDesc"), false, true);
        this.source = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.source"), Messages.getString("NDublinCore.sourceDesc"), false, false);
        this.publisher = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.publisher"), Messages.getString("NDublinCore.publisherDesc"), false, false);
        this.coverage = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.coverage"), Messages.getString("NDublinCore.coverageDesc"), false, false);
        this.contributor = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.contributor"), Messages.getString("NDublinCore.contributorDesc"), false, false);
        this.relation = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.relation"), Messages.getString("NDublinCore.relationDesc"), false, false);
        this.rights = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.rights"), Messages.getString("NDublinCore.rightsDesc"), false, false);
        this.subject = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.subject"), Messages.getString("NDublinCore.subjectDesc"), false, false);
        this.language = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.language"), Messages.getString("NDublinCore.languageDesc"), false, false);
        this.bibliographicCitation = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.citation"), Messages.getString("NDublinCore.citationDesc"), false, false);
        this.license = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.license"), Messages.getString("NDublinCore.licensDesc"), false, false);
        this.required = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.required"), Messages.getString("NDublinCore.requiredDesc"), false, false);
        this.spatial = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.spatial"), Messages.getString("NDublinCore.spatialDesc"), false, false);
        this.format = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.format"), Messages.getString("NDublinCore.formatDesc"), true, false);
        this.type = this.createDCAttribute(pageComposite, Messages.getString("NDublinCore.type"), Messages.getString("NDublinCore.typeDesc"), true, false);
        ModifyListener resizeListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                scrollComposite.setMinSize(pageComposite.computeSize(-1, -1));
            }
        };
        this.titleTextField.addModifyListener(resizeListener);
        this.descriptionTextField.addModifyListener(resizeListener);
        this.creator.addModifyListener(resizeListener);
        this.date.addModifyListener(resizeListener);
        this.format.addModifyListener(resizeListener);
        this.publisher.addModifyListener(resizeListener);
        this.coverage.addModifyListener(resizeListener);
        this.contributor.addModifyListener(resizeListener);
        this.relation.addModifyListener(resizeListener);
        this.rights.addModifyListener(resizeListener);
        this.source.addModifyListener(resizeListener);
        this.subject.addModifyListener(resizeListener);
        this.type.addModifyListener(resizeListener);
        this.language.addModifyListener(resizeListener);
        this.bibliographicCitation.addModifyListener(resizeListener);
        this.created.addModifyListener(resizeListener);
        this.license.addModifyListener(resizeListener);
        this.required.addModifyListener(resizeListener);
        this.spatial.addModifyListener(resizeListener);
        this.valid.addModifyListener(resizeListener);
        Label requiredFieldLabel = new Label(pageComposite, 0);
        requiredFieldLabel.setText(REQUIRED_FIELD_CHAR + Messages.getString("NDublinCore.requiredField"));
        GridData requiredLabelLayoutData = new GridData();
        requiredLabelLayoutData.horizontalSpan = 2;
        requiredFieldLabel.setLayoutData((Object)requiredLabelLayoutData);
        this.initializeDCAttributes();
        this.setPageComplete(this.validateDublinCorePage());
        this.setControl((Control)scrollComposite);
    }

    protected void initializeDCAttributes() {
        this.created.setText(DublinCoreImpl.createISO8601DateString((Date)Calendar.getInstance().getTime()));
        this.creator.setText(System.getProperty("user.name"));
        this.publisher.setText(Messages.getString("dc_publisher"));
        this.license.setText(Messages.getString("dc_license"));
    }

    private Text createDCAttribute(Composite parent, String attributeName, String toolTip, boolean requiredField, boolean validatingField) {
        Label attributeLabel = new Label(parent, 0);
        attributeLabel.setText(String.valueOf(attributeName) + ":" + (requiredField ? REQUIRED_FIELD_CHAR : ""));
        GridData labelLayoutData = new GridData();
        labelLayoutData.horizontalSpan = 1;
        attributeLabel.setLayoutData((Object)labelLayoutData);
        Text retValue = new Text(parent, 2048);
        retValue.setToolTipText(toolTip);
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        labelLayoutData.horizontalSpan = 1;
        retValue.setLayoutData((Object)layoutData);
        if (validatingField) {
            retValue.addModifyListener(this.dcValidator);
        }
        return retValue;
    }

    protected boolean validateDublinCorePage() {
        boolean retValue = true;
        this.setErrorMessage(null);
        if (retValue && this.created.getText() != null && !this.created.getText().equals("") && !DublinCorePage.isValidDateString(this.created.getText())) {
            this.setErrorMessage(Messages.getString("NDublinCore.createdErr"));
            retValue = false;
        }
        if (retValue && this.date.getText() != null && !this.date.getText().equals("") && !DublinCorePage.isValidDateString(this.date.getText())) {
            this.setErrorMessage(Messages.getString("NDublinCore.dateErr"));
            retValue = false;
        }
        if (retValue && this.valid.getText() != null && !this.valid.getText().equals("") && !DublinCorePage.isValidValidDateString(this.valid.getText())) {
            this.setErrorMessage(Messages.getString("NDublinCore.validErr"));
            retValue = false;
        }
        return retValue;
    }

    protected static boolean isValidValidDateString(String validDataRangeString) {
        return DublinCoreImpl.isValidStartDateValid((String)validDataRangeString) && DublinCoreImpl.isValidEndDateValid((String)validDataRangeString);
    }

    protected static boolean isValidDateString(String dateString) {
        boolean retValue;
        block3: {
            retValue = false;
            String trimedDateString = dateString.trim();
            if (trimedDateString.length() == "yyyy-dd-mm".length()) break block3;
            return false;
        }
        try {
            DublinCoreImpl.createDateFromISO8601DateString((String)dateString);
            retValue = true;
        }
        catch (ParseException e) {
            retValue = false;
        }
        return retValue;
    }

    public static boolean isEndBeforeStart(String startDateString, String endDateString) {
        boolean retValue = false;
        try {
            Date startDate = DublinCoreImpl.createDateFromISO8601DateString((String)startDateString);
            Date endDate = DublinCoreImpl.createDateFromISO8601DateString((String)endDateString);
            retValue = endDate.before(startDate);
        }
        catch (ParseException e) {
            retValue = true;
        }
        return retValue;
    }

    public void updateDublinCorePage(DublinCore dublinCore) {
        String str = dublinCore.getTitle();
        if (str != null) {
            this.setTitleText(str);
        }
        if ((str = dublinCore.getDescription()) != null) {
            this.setDescriptionText(str);
        }
        if ((str = dublinCore.getSource()) != null) {
            this.setSource(str);
        }
        if ((str = dublinCore.getPublisher()) != null) {
            this.setPublisher(str);
        }
        if ((str = dublinCore.getLicense()) != null) {
            this.setLicense(str);
        }
    }

    public DublinCore createDublinCore() {
        DublinCore retValue = CommonFactory.eINSTANCE.createDublinCore();
        if (this.isSet(this.titleTextField.getText())) {
            retValue.setTitle(this.titleTextField.getText());
        }
        if (this.isSet(this.descriptionTextField.getText())) {
            retValue.setDescription(this.descriptionTextField.getText());
        }
        if (this.isSet(this.creator.getText())) {
            retValue.setCreator(this.creator.getText());
        }
        if (this.isSet(this.date.getText())) {
            retValue.setDate(this.date.getText());
        }
        if (this.isSet(this.format.getText())) {
            retValue.setFormat(this.format.getText());
        }
        if (this.isSet(this.publisher.getText())) {
            retValue.setPublisher(this.publisher.getText());
        }
        if (this.isSet(this.coverage.getText())) {
            retValue.setCoverage(this.coverage.getText());
        }
        if (this.isSet(this.contributor.getText())) {
            retValue.setContributor(this.contributor.getText());
        }
        if (this.isSet(this.relation.getText())) {
            retValue.setRelation(this.relation.getText());
        }
        if (this.isSet(this.rights.getText())) {
            retValue.setRights(this.rights.getText());
        }
        if (this.isSet(this.source.getText())) {
            retValue.setSource(this.source.getText());
        }
        if (this.isSet(this.subject.getText())) {
            retValue.setSubject(this.subject.getText());
        }
        if (this.isSet(this.type.getText())) {
            retValue.setType(this.type.getText());
        }
        if (this.isSet(this.language.getText())) {
            retValue.setBibliographicCitation(this.language.getText());
        }
        if (this.isSet(this.bibliographicCitation.getText())) {
            retValue.setBibliographicCitation(this.bibliographicCitation.getText());
        }
        if (this.isSet(this.created.getText())) {
            retValue.setCreated(this.created.getText());
        }
        if (this.isSet(this.license.getText())) {
            retValue.setLicense(this.license.getText());
        }
        if (this.isSet(this.required.getText())) {
            retValue.setRequired(this.required.getText());
        }
        if (this.isSet(this.spatial.getText())) {
            retValue.setSpatial(this.spatial.getText());
        }
        if (this.isSet(this.valid.getText())) {
            retValue.setValid(this.valid.getText());
        }
        return retValue;
    }

    private boolean isSet(String text) {
        return text != null && !text.equals("");
    }

    public void setTitleText(String titleSTR) {
        if (this.titleTextField != null) {
            this.titleTextField.setText(titleSTR);
        }
    }

    public void setDescriptionText(String descriptionSTR) {
        if (this.descriptionTextField != null) {
            this.descriptionTextField.setText(descriptionSTR);
        }
    }

    public void setCreator(String creatorSTR) {
        if (this.creator != null) {
            this.creator.setText(creatorSTR);
        }
    }

    public void setDate(String dateSTR) {
        if (this.date != null) {
            this.date.setText(dateSTR);
        }
    }

    public void setFormat(String formatSTR) {
        if (this.format != null) {
            this.format.setText(formatSTR);
        }
    }

    public void setPublisher(String publisherSTR) {
        if (this.publisher != null) {
            this.publisher.setText(publisherSTR);
        }
    }

    public void setCoverage(String coverageSTR) {
        if (this.coverage != null) {
            this.coverage.setText(coverageSTR);
        }
    }

    public void setContributor(String contributorSTR) {
        if (this.contributor != null) {
            this.contributor.setText(contributorSTR);
        }
    }

    public void setRelation(String relationSTR) {
        if (this.relation != null) {
            this.relation.setText(relationSTR);
        }
    }

    public void setRights(String rightsSTR) {
        if (this.rights != null) {
            this.rights.setText(rightsSTR);
        }
    }

    public void setSource(String sourceSTR) {
        if (this.source != null) {
            this.source.setText(sourceSTR);
        }
    }

    public void setSubject(String subjectSTR) {
        if (this.subject != null) {
            this.subject.setText(subjectSTR);
        }
    }

    public void setType(String typeSTR) {
        if (this.type != null) {
            this.type.setText(typeSTR);
        }
    }

    public void setLanguage(String languageSTR) {
        if (this.language != null) {
            this.language.setText(languageSTR);
        }
    }

    public void setBibliographicCitation(String bibliographicCitationSTR) {
        if (this.bibliographicCitation != null) {
            this.bibliographicCitation.setText(bibliographicCitationSTR);
        }
    }

    public void setCreated(String createdSTR) {
        if (this.created != null) {
            this.created.setText(createdSTR);
        }
    }

    public void setLicense(String licenseSTR) {
        if (this.license != null) {
            this.license.setText(licenseSTR);
        }
    }

    public void setRequired(String requiredSTR) {
        if (this.required != null) {
            this.required.setText(requiredSTR);
        }
    }

    public void setSpatial(String spatialSTR) {
        if (this.spatial != null) {
            this.spatial.setText(spatialSTR);
        }
    }

    public void setValid(String validSTR) {
        if (this.valid != null) {
            this.valid.setText(validSTR);
        }
    }
}

