/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.handlers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.AbstractAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class EditorActionProvider
extends CommonActionProvider {
    IAction openAction = null;

    public void init(ICommonActionExtensionSite site) {
        ICommonViewerSite aSite = site.getViewSite();
        if (aSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite cvws = (ICommonViewerWorkbenchSite)aSite;
            this.openAction = new OpenIdentifiableAction(cvws.getPage(), cvws.getSelectionProvider());
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.openAction);
        }
    }

    public static class OpenIdentifiableAction
    extends AbstractAction
    implements IAction {
        private final IWorkbenchPage page;
        private final ISelectionProvider selectionProvider;
        private Identifiable selectedIdentifiable;

        public OpenIdentifiableAction(IWorkbenchPage page, ISelectionProvider selectionProvider) {
            this.page = page;
            this.selectionProvider = selectionProvider;
        }

        public void run() {
            String platFormStr = this.selectedIdentifiable.getURI().toPlatformString(true);
            if (platFormStr == null) {
                return;
            }
            Path path = new Path(platFormStr);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file != null) {
                try {
                    IDE.openEditor((IWorkbenchPage)this.page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    Activator.logError("Problem opening editor", e);
                }
            } else {
                Activator.logError("Could not find file \"" + path.toString() + "\"", null);
            }
        }

        public boolean isEnabled() {
            IStructuredSelection sSelection;
            boolean retValue = false;
            ISelection selection = this.selectionProvider.getSelection();
            if (!selection.isEmpty() && (sSelection = (IStructuredSelection)selection).size() == 1 && sSelection.getFirstElement() instanceof Identifiable) {
                this.selectedIdentifiable = (Identifiable)sSelection.getFirstElement();
                retValue = true;
            }
            return retValue;
        }

        public int getAccelerator() {
            return 0;
        }

        public String getActionDefinitionId() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public ImageDescriptor getDisabledImageDescriptor() {
            return null;
        }

        public HelpListener getHelpListener() {
            return null;
        }

        public ImageDescriptor getHoverImageDescriptor() {
            return null;
        }

        public String getId() {
            return null;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public IMenuCreator getMenuCreator() {
            return null;
        }

        public int getStyle() {
            return 0;
        }

        public String getText() {
            return null;
        }

        public String getToolTipText() {
            return null;
        }

        public boolean isChecked() {
            return false;
        }

        public boolean isHandled() {
            return false;
        }

        public void runWithEvent(Event event) {
        }

        public void setAccelerator(int keycode) {
        }

        public void setActionDefinitionId(String id) {
        }

        public void setChecked(boolean checked) {
        }

        public void setDescription(String text) {
        }

        public void setDisabledImageDescriptor(ImageDescriptor newImage) {
        }

        public void setEnabled(boolean enabled) {
        }

        public void setHelpListener(HelpListener listener) {
        }

        public void setHoverImageDescriptor(ImageDescriptor newImage) {
        }

        public void setId(String id) {
        }

        public void setImageDescriptor(ImageDescriptor newImage) {
        }

        public void setMenuCreator(IMenuCreator creator) {
        }

        public void setText(String text) {
        }

        public void setToolTipText(String text) {
        }
    }
}

