/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.AnnotationProcessorListener;
import com.sun.mirror.apt.RoundCompleteListener;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.apt.core.env.Phase;
import org.eclipse.jdt.apt.core.internal.AptCompilationParticipant;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.AptProject;
import org.eclipse.jdt.apt.core.internal.env.AbstractCompilationEnv;
import org.eclipse.jdt.apt.core.internal.env.BuildEnv;
import org.eclipse.jdt.apt.core.internal.env.EclipseRoundCompleteEvent;
import org.eclipse.jdt.apt.core.internal.env.ReconcileEnv;
import org.eclipse.jdt.apt.core.internal.generatedfile.GeneratedFileManager;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.util.AptConfig;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.ReconcileContext;

public class APTDispatchRunnable
implements IWorkspaceRunnable {
    private static final BuildContext[] NO_FILES_TO_PROCESS = new BuildContext[0];
    private static final int MAX_FILES_PER_ITERATION = 1000;
    private BuildContext[] _filesWithAnnotation = null;
    private BuildContext[] _filesWithoutAnnotation = null;
    private Map<IFile, CategorizedProblem[]> _problemRecorder = null;
    private final AptProject _aptProject;
    private final Map<AnnotationProcessorFactory, FactoryPath.Attributes> _factories;
    private final Set<AnnotationProcessorFactory> _dispatchedBatchFactories;
    private Set<AnnotationProcessorFactory> _currentDispatchBatchFactories = Collections.emptySet();
    private final boolean _isFullBuild;
    private static final boolean SPLIT_FILES;
    private static final String SPLIT_FILES_PROPERTY = "org.eclipse.jdt.apt.core.split_files";
    private final boolean _isTestCode;

    static {
        String setting = System.getProperty(SPLIT_FILES_PROPERTY);
        SPLIT_FILES = setting == null || setting.equalsIgnoreCase("true");
    }

    public static Set<AnnotationProcessorFactory> runAPTDuringBuild(BuildContext[] filesWithAnnotations, BuildContext[] filesWithoutAnnotations, Map<IFile, CategorizedProblem[]> problemRecorder, AptProject aptProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories, Set<AnnotationProcessorFactory> dispatchedBatchFactories, boolean isFullBuild, boolean isTestCode) {
        if (filesWithAnnotations == null) {
            filesWithAnnotations = NO_FILES_TO_PROCESS;
        }
        APTDispatchRunnable runnable = new APTDispatchRunnable(filesWithAnnotations, filesWithoutAnnotations, problemRecorder, aptProject, factories, dispatchedBatchFactories, isFullBuild, isTestCode);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            workspace.run((IWorkspaceRunnable)runnable, (ISchedulingRule)aptProject.getJavaProject().getResource(), 1, null);
        }
        catch (CoreException ce) {
            AptPlugin.log(ce, "Could not run APT");
        }
        return runnable._currentDispatchBatchFactories;
    }

    public static void runAPTDuringReconcile(ReconcileContext reconcileContext, AptProject aptProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories, boolean test) {
        APTDispatchRunnable runnable = new APTDispatchRunnable(aptProject, factories, test);
        runnable.reconcile(reconcileContext, aptProject.getJavaProject(), test);
    }

    private APTDispatchRunnable(BuildContext[] filesWithAnnotation, BuildContext[] filesWithoutAnnotation, Map<IFile, CategorizedProblem[]> problemRecorder, AptProject aptProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories, Set<AnnotationProcessorFactory> dispatchedBatchFactories, boolean isFullBuild, boolean isTestCode) {
        assert (filesWithAnnotation != null) : "missing files";
        this._filesWithAnnotation = filesWithAnnotation;
        this._filesWithoutAnnotation = filesWithoutAnnotation;
        this._problemRecorder = problemRecorder;
        this._aptProject = aptProject;
        this._factories = factories;
        this._dispatchedBatchFactories = dispatchedBatchFactories;
        this._isFullBuild = isFullBuild;
        this._isTestCode = isTestCode;
    }

    private APTDispatchRunnable(AptProject aptProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories, boolean test) {
        this._aptProject = aptProject;
        this._factories = factories;
        this._isTestCode = test;
        this._isFullBuild = false;
        this._dispatchedBatchFactories = Collections.emptySet();
    }

    private void reconcile(ReconcileContext reconcileContext, IJavaProject javaProject, boolean test) {
        if (this._factories.size() == 0) {
            if (AptPlugin.DEBUG) {
                APTDispatchRunnable.trace("apt leaving project " + javaProject.getProject() + " early because there are no factories", null);
            }
            return;
        }
        GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager(test);
        gfm.reconcileStarted();
        ReconcileEnvCallback callback = new ReconcileEnvCallback(reconcileContext, gfm);
        AbstractCompilationEnv.newReconcileEnv(reconcileContext, callback);
    }

    public void run(IProgressMonitor monitor) {
        this.build();
    }

    private boolean shouldBuild() {
        int totalFiles;
        if ((this._factories == null || this._factories.size() == 0) && this._dispatchedBatchFactories.isEmpty()) {
            return false;
        }
        int n = totalFiles = this._filesWithAnnotation == null ? 0 : this._filesWithAnnotation.length;
        return totalFiles > 0 || !this._dispatchedBatchFactories.isEmpty();
    }

    private void build() {
        if (!this.shouldBuild()) {
            if (AptPlugin.DEBUG) {
                String msg = (this._factories == null || this._factories.size() == 0) && this._dispatchedBatchFactories.isEmpty() ? "no AnnotationProcessoryFactory instances registered." : "no files to dispatch to.";
                APTDispatchRunnable.trace("run():  leaving project " + this._aptProject.getJavaProject().getProject() + " early because there are " + msg, null);
            }
            this.cleanupAllGeneratedFiles();
        } else {
            assert (this._filesWithAnnotation != null) : "should never be invoked unless we are in build mode!";
            AbstractCompilationEnv.EnvCallback buildCallback = new AbstractCompilationEnv.EnvCallback(){

                @Override
                public void run(AbstractCompilationEnv env) {
                    APTDispatchRunnable.this.build((BuildEnv)env);
                }
            };
            boolean split = false;
            if (SPLIT_FILES && !this.hasBatchFactory()) {
                boolean bl = split = this._filesWithAnnotation.length > 1000;
            }
            if (!split) {
                BuildEnv.newBuildEnv(this._filesWithAnnotation, this._filesWithoutAnnotation, this._aptProject.getJavaProject(), buildCallback);
            } else {
                int index = 0;
                while (index < this._filesWithAnnotation.length) {
                    int numberToProcess = index + 1000 > this._filesWithAnnotation.length ? this._filesWithAnnotation.length - index : 1000;
                    BuildContext[] filesToProcess = new BuildContext[numberToProcess];
                    System.arraycopy(this._filesWithAnnotation, index, filesToProcess, 0, numberToProcess);
                    BuildEnv.newBuildEnv(filesToProcess, this._filesWithoutAnnotation, this._aptProject.getJavaProject(), buildCallback);
                    index += numberToProcess;
                }
            }
        }
        this._aptProject.getGeneratedFileManager(this._isTestCode).writeState();
    }

    private boolean hasBatchFactory() {
        for (FactoryPath.Attributes attr : this._factories.values()) {
            if (!attr.runInBatchMode()) continue;
            return true;
        }
        return false;
    }

    private boolean shouldDispatchToBatchProcessor(AbstractCompilationEnv processorEnv) {
        return this._isFullBuild && processorEnv.getPhase() == Phase.BUILD && this.hasBatchFactory();
    }

    private void runAPTInFileBasedMode(BuildEnv processorEnv) {
        BuildContext[] cpResults = processorEnv.getFilesWithAnnotation();
        GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager(this._isTestCode);
        boolean projectEnablesReconcile = AptConfig.shouldProcessDuringReconcile(this._aptProject.getJavaProject());
        BuildContext[] buildContextArray = cpResults;
        int n = cpResults.length;
        int n2 = 0;
        while (n2 < n) {
            BuildContext curResult = buildContextArray[n2];
            processorEnv.beginFileProcessing(curResult);
            this.dispatchToFileBasedProcessor(processorEnv, projectEnablesReconcile, false);
            this.reportResult(curResult, processorEnv.getAllGeneratedFiles(), processorEnv.getModifiedGeneratedFiles(), processorEnv.getProblems(), processorEnv.getTypeDependencies(), gfm, processorEnv);
            processorEnv.completedFileProcessing();
            ++n2;
        }
    }

    private void reportResult(BuildContext curResult, Set<IFile> java5GeneratedFiles, Set<IFile> modifiedGeneratedFiles, List<? extends CategorizedProblem> problems, Set<String> deps, GeneratedFileManager gfm, BuildEnv processorEnv) {
        int numDeps;
        int numProblems;
        int numDeletedFiles;
        Set<Object> allGeneratedFiles = null;
        Set<IFile> java6GeneratedFiles = AptCompilationParticipant.getInstance().getJava6GeneratedFiles();
        if (java5GeneratedFiles == null || java5GeneratedFiles.isEmpty()) {
            allGeneratedFiles = java6GeneratedFiles.isEmpty() ? Collections.emptySet() : java6GeneratedFiles;
        } else if (java6GeneratedFiles.isEmpty()) {
            allGeneratedFiles = java5GeneratedFiles;
        } else {
            allGeneratedFiles = new HashSet<IFile>(java6GeneratedFiles);
            allGeneratedFiles.addAll(java5GeneratedFiles);
        }
        ArrayList<IFile> deletedFiles = new ArrayList<IFile>();
        IFile parentFile = curResult.getFile();
        this.cleanupNoLongerGeneratedFiles(parentFile, allGeneratedFiles, gfm, processorEnv, deletedFiles);
        int numNewFiles = modifiedGeneratedFiles.size();
        if (numNewFiles > 0) {
            IFile[] newFilesArray = new IFile[numNewFiles];
            curResult.recordAddedGeneratedFiles(modifiedGeneratedFiles.toArray(newFilesArray));
        }
        if ((numDeletedFiles = deletedFiles.size()) > 0) {
            IFile[] deletedFilesArray = new IFile[numDeletedFiles];
            curResult.recordDeletedGeneratedFiles(deletedFiles.toArray(deletedFilesArray));
        }
        if ((numProblems = problems.size()) > 0) {
            CategorizedProblem[] catProblemsArray = new CategorizedProblem[numProblems];
            curResult.recordNewProblems(problems.toArray(catProblemsArray));
            this._problemRecorder.put(curResult.getFile(), catProblemsArray);
        }
        if ((numDeps = deps.size()) > 0) {
            String[] depsArray = new String[numDeps];
            curResult.recordDependencies(deps.toArray(depsArray));
        }
    }

    private void runAPTInMixedMode(BuildEnv processorEnv) {
        BuildContext[] cpResults = processorEnv.getFilesWithAnnotation();
        HashMap<BuildContext, Set<AnnotationTypeDeclaration>> file2AnnotationDecls = new HashMap<BuildContext, Set<AnnotationTypeDeclaration>>(cpResults.length * 4 / 3 + 1);
        Map<String, AnnotationTypeDeclaration> annotationDecls = processorEnv.getAllAnnotationTypes(file2AnnotationDecls);
        if (annotationDecls.isEmpty() && this._dispatchedBatchFactories.isEmpty()) {
            if (AptPlugin.DEBUG) {
                APTDispatchRunnable.trace("runAPT:  leaving early because annotationDecls is empty", processorEnv);
            }
            return;
        }
        if (AptPlugin.DEBUG) {
            APTDispatchRunnable.trace("annotations found " + annotationDecls.keySet(), processorEnv);
        }
        HashMap fileFactory2Annos = new HashMap(this._factories.size() * 4 / 3 + 1);
        HashMap<AnnotationProcessorFactory, Set<AnnotationTypeDeclaration>> batchFactory2Annos = new HashMap<AnnotationProcessorFactory, Set<AnnotationTypeDeclaration>>(this._factories.size() * 4 / 3 + 1);
        for (Map.Entry<AnnotationProcessorFactory, FactoryPath.Attributes> entry : this._factories.entrySet()) {
            AnnotationProcessorFactory factory = entry.getKey();
            Set<AnnotationTypeDeclaration> annotationTypes = APTDispatchRunnable.getFactorySupportedAnnotations(factory, annotationDecls);
            if (annotationTypes != null) {
                HashMap<AnnotationProcessorFactory, Set<AnnotationTypeDeclaration>> factory2Annos;
                boolean batch = entry.getValue().runInBatchMode();
                HashMap<AnnotationProcessorFactory, Set<AnnotationTypeDeclaration>> hashMap = factory2Annos = batch ? batchFactory2Annos : fileFactory2Annos;
                if (annotationTypes.size() == 0) {
                    annotationTypes = new HashSet<AnnotationTypeDeclaration>(annotationDecls.values());
                    factory2Annos.put(factory, annotationTypes);
                    annotationDecls.clear();
                    break;
                }
                factory2Annos.put(factory, annotationTypes);
            }
            if (annotationDecls.isEmpty()) break;
        }
        annotationDecls.isEmpty();
        if (!batchFactory2Annos.isEmpty() || this._dispatchedBatchFactories != null && !this._dispatchedBatchFactories.isEmpty()) {
            processorEnv.beginBatchProcessing();
            if (!batchFactory2Annos.isEmpty()) {
                this._currentDispatchBatchFactories = new LinkedHashSet<AnnotationProcessorFactory>();
                for (AnnotationProcessorFactory factory : this._factories.keySet()) {
                    AnnotationProcessor processor;
                    Set annotationTypes = (Set)batchFactory2Annos.get(factory);
                    if (annotationTypes == null || (processor = factory.getProcessorFor(annotationTypes, processorEnv)) == null) continue;
                    if (AptPlugin.DEBUG) {
                        APTDispatchRunnable.trace("runAPT: invoking batch processor " + processor.getClass().getName(), processorEnv);
                    }
                    this._currentDispatchBatchFactories.add(factory);
                    processorEnv.setCurrentProcessorFactory(factory, false);
                    processor.process();
                    processorEnv.setCurrentProcessorFactory(null, false);
                }
            }
            for (AnnotationProcessorFactory prevRoundFactory : this._dispatchedBatchFactories) {
                AnnotationProcessor processor;
                if (this._currentDispatchBatchFactories.contains(prevRoundFactory) || (processor = prevRoundFactory.getProcessorFor(Collections.emptySet(), processorEnv)) == null) continue;
                if (AptPlugin.DEBUG) {
                    APTDispatchRunnable.trace("runAPT: invoking batch processor " + processor.getClass().getName(), processorEnv);
                }
                processorEnv.setCurrentProcessorFactory(prevRoundFactory, false);
                processor.process();
                processorEnv.setCurrentProcessorFactory(null, false);
            }
            BuildContext firstResult = null;
            if (cpResults.length > 0) {
                firstResult = cpResults[0];
            } else {
                BuildContext[] others = processorEnv.getFilesWithoutAnnotation();
                if (others != null && others.length > 0) {
                    firstResult = others[0];
                }
            }
            assert (firstResult != null) : "don't know where to report results";
            if (firstResult != null) {
                GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager(this._isTestCode);
                this.reportResult(firstResult, processorEnv.getAllGeneratedFiles(), processorEnv.getModifiedGeneratedFiles(), processorEnv.getProblems(), processorEnv.getTypeDependencies(), gfm, processorEnv);
            }
            processorEnv.completedBatchProcessing();
        }
        if (!fileFactory2Annos.isEmpty()) {
            boolean projectEnablesReconcile = AptConfig.shouldProcessDuringReconcile(this._aptProject.getJavaProject());
            BuildContext[] buildContextArray = cpResults;
            int n = cpResults.length;
            int n2 = 0;
            while (n2 < n) {
                BuildContext curResult = buildContextArray[n2];
                Set annotationTypesInFile = (Set)file2AnnotationDecls.get(curResult);
                if (annotationTypesInFile != null && !annotationTypesInFile.isEmpty()) {
                    for (AnnotationProcessorFactory factory : this._factories.keySet()) {
                        Set<AnnotationTypeDeclaration> intersect;
                        Set annotationTypesForFactory = (Set)fileFactory2Annos.get(factory);
                        if (annotationTypesForFactory == null || annotationTypesForFactory.isEmpty() || (intersect = this.setIntersect(annotationTypesInFile, annotationTypesForFactory)) == null || intersect.isEmpty()) continue;
                        processorEnv.beginFileProcessing(curResult);
                        AnnotationProcessor processor = factory.getProcessorFor(intersect, processorEnv);
                        if (processor == null) continue;
                        if (AptPlugin.DEBUG) {
                            APTDispatchRunnable.trace("runAPT: invoking file-based processor " + processor.getClass().getName(), processorEnv);
                        }
                        boolean willReconcile = projectEnablesReconcile && AbstractCompilationEnv.doesFactorySupportReconcile(factory);
                        processorEnv.setCurrentProcessorFactory(factory, willReconcile);
                        processor.process();
                        processorEnv.setCurrentProcessorFactory(null, false);
                    }
                    GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager(this._isTestCode);
                    this.reportResult(curResult, processorEnv.getAllGeneratedFiles(), processorEnv.getModifiedGeneratedFiles(), processorEnv.getProblems(), processorEnv.getTypeDependencies(), gfm, processorEnv);
                    processorEnv.completedFileProcessing();
                }
                ++n2;
            }
        }
    }

    private void dispatchToFileBasedProcessor(AbstractCompilationEnv processorEnv, boolean projectEnablesReconcile, boolean isReconcile) {
        Map<String, AnnotationTypeDeclaration> annotationDecls = processorEnv.getAnnotationTypes();
        for (Map.Entry<AnnotationProcessorFactory, FactoryPath.Attributes> entry : this._factories.entrySet()) {
            AnnotationProcessor processor;
            boolean reconcileSupported;
            if (entry.getValue().runInBatchMode()) continue;
            AnnotationProcessorFactory factory = entry.getKey();
            boolean bl = reconcileSupported = projectEnablesReconcile && AbstractCompilationEnv.doesFactorySupportReconcile(factory);
            if (isReconcile && !reconcileSupported) continue;
            Set<AnnotationTypeDeclaration> factoryDecls = APTDispatchRunnable.getFactorySupportedAnnotations(factory, annotationDecls);
            if (factoryDecls != null && factoryDecls.size() == 0) {
                factoryDecls = new HashSet<AnnotationTypeDeclaration>(annotationDecls.values());
                annotationDecls.clear();
            }
            if (factoryDecls != null && factoryDecls.size() > 0 && (processor = factory.getProcessorFor(factoryDecls, processorEnv)) != null) {
                if (AptPlugin.DEBUG) {
                    APTDispatchRunnable.trace("runAPT: invoking file-based processor " + processor.getClass().getName() + " on " + processorEnv.getFile(), processorEnv);
                }
                processorEnv.setCurrentProcessorFactory(factory, reconcileSupported);
                processor.process();
                processorEnv.setCurrentProcessorFactory(null, false);
            }
            if (annotationDecls.isEmpty()) break;
        }
        annotationDecls.isEmpty();
    }

    private Set<AnnotationProcessorFactory> build(BuildEnv processorEnv) {
        block13: {
            try {
                boolean mixedModeDispatch = this.shouldDispatchToBatchProcessor(processorEnv);
                if (mixedModeDispatch) {
                    this.runAPTInMixedMode(processorEnv);
                } else {
                    this.runAPTInFileBasedMode(processorEnv);
                }
                Set<AnnotationProcessorListener> listeners = processorEnv.getProcessorListeners();
                EclipseRoundCompleteEvent event = null;
                for (AnnotationProcessorListener listener : listeners) {
                    if (!(listener instanceof RoundCompleteListener)) continue;
                    if (event == null) {
                        event = new EclipseRoundCompleteEvent(processorEnv);
                    }
                    RoundCompleteListener rcListener = (RoundCompleteListener)listener;
                    rcListener.roundComplete(event);
                }
                if (this._filesWithoutAnnotation != null) {
                    this.cleanupAllGeneratedFilesFrom(this._filesWithoutAnnotation);
                }
            }
            catch (Error t) {
                if (t.getClass().getName().startsWith("junit.framework")) {
                    throw t;
                }
                AptPlugin.logWarning(t, "Unexpected failure running APT on the file(s): " + APTDispatchRunnable.getFileNamesForPrinting(processorEnv));
                processorEnv.close();
                break block13;
            }
            catch (Throwable t) {
                try {
                    AptPlugin.logWarning(t, "Unexpected failure running APT on the file(s): " + APTDispatchRunnable.getFileNamesForPrinting(processorEnv));
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    processorEnv.close();
                }
            }
            processorEnv.close();
        }
        return Collections.emptySet();
    }

    private Set<AnnotationTypeDeclaration> setIntersect(Set<AnnotationTypeDeclaration> one, Set<AnnotationTypeDeclaration> two) {
        HashSet<AnnotationTypeDeclaration> intersect = null;
        for (AnnotationTypeDeclaration obj : one) {
            if (!two.contains(obj)) continue;
            if (intersect == null) {
                intersect = new HashSet<AnnotationTypeDeclaration>();
            }
            intersect.add(obj);
        }
        return intersect;
    }

    private void cleanupAllGeneratedFiles() {
        this.cleanupAllGeneratedFilesFrom(this._filesWithAnnotation);
        this.cleanupAllGeneratedFilesFrom(this._filesWithoutAnnotation);
    }

    private void cleanupAllGeneratedFilesFrom(BuildContext[] cpResults) {
        if (cpResults == null) {
            return;
        }
        HashSet<IFile> deleted = new HashSet<IFile>();
        GeneratedFileManager gfm = this._aptProject.getGeneratedFileManager(this._isTestCode);
        Set<IFile> java6GeneratedFiles = AptCompilationParticipant.getInstance().getJava6GeneratedFiles();
        BuildContext[] buildContextArray = cpResults;
        int n = cpResults.length;
        int n2 = 0;
        while (n2 < n) {
            BuildContext cpResult = buildContextArray[n2];
            IFile parentFile = cpResult.getFile();
            this.cleanupNoLongerGeneratedFiles(parentFile, java6GeneratedFiles, gfm, null, deleted);
            if (deleted.size() > 0) {
                IFile[] deletedFilesArray = new IFile[deleted.size()];
                cpResult.recordDeletedGeneratedFiles(deleted.toArray(deletedFilesArray));
            }
            ++n2;
        }
    }

    private void cleanupNoLongerGeneratedFiles(IFile parentFile, Set<IFile> newGeneratedFiles, GeneratedFileManager gfm, BuildEnv processorEnv, Collection<IFile> deleted) {
        deleted.addAll(gfm.deleteObsoleteFilesAfterBuild(parentFile, newGeneratedFiles));
    }

    private static Set<AnnotationTypeDeclaration> getFactorySupportedAnnotations(AnnotationProcessorFactory factory, Map<String, AnnotationTypeDeclaration> declarations) {
        Collection<String> supportedTypes = factory.supportedAnnotationTypes();
        if (supportedTypes == null || supportedTypes.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<AnnotationTypeDeclaration> fDecls = new HashSet<AnnotationTypeDeclaration>();
        for (String typeName : supportedTypes) {
            if (typeName.equals("*")) {
                fDecls.addAll(declarations.values());
                declarations.clear();
                AptPlugin.logWarning(null, "Processor Factory " + factory + " claimed all annotations (*), which prevents any following factories from being dispatched.");
                continue;
            }
            if (typeName.endsWith("*")) {
                String prefix = typeName.substring(0, typeName.length() - 2);
                Iterator<Map.Entry<String, AnnotationTypeDeclaration>> entries = declarations.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<String, AnnotationTypeDeclaration> entry = entries.next();
                    String key = entry.getKey();
                    if (!key.startsWith(prefix)) continue;
                    fDecls.add(entry.getValue());
                    entries.remove();
                }
                continue;
            }
            AnnotationTypeDeclaration decl = declarations.get(typeName);
            if (decl == null) continue;
            fDecls.add(decl);
            declarations.remove(typeName);
        }
        return fDecls.isEmpty() ? null : fDecls;
    }

    private static void trace(String s, AbstractCompilationEnv processorEnv) {
        if (AptPlugin.DEBUG) {
            if (processorEnv != null) {
                s = "[ phase = " + (Object)((Object)processorEnv.getPhase()) + ", file = " + APTDispatchRunnable.getFileNamesForPrinting(processorEnv) + " ]  " + s;
            }
            AptPlugin.trace(s);
        }
    }

    private static String getFileNamesForPrinting(AbstractCompilationEnv env) {
        if (env instanceof ReconcileEnv) {
            return env.getFile().getName();
        }
        return APTDispatchRunnable.getFileNamesForPrinting((BuildEnv)env);
    }

    private static String getFileNamesForPrinting(BuildEnv processorEnv) {
        IFile file = processorEnv.getFile();
        if (file != null) {
            return file.getName();
        }
        BuildContext[] results = processorEnv.getFilesWithAnnotation();
        int len = results.length;
        switch (len) {
            case 0: {
                return "no file(s)";
            }
            case 1: {
                return results[0].getFile().getName();
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean firstItem = true;
        BuildContext[] buildContextArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            BuildContext curResult = buildContextArray[n2];
            if (firstItem) {
                firstItem = false;
            } else {
                sb.append(", ");
            }
            sb.append(curResult.getFile().getName());
            ++n2;
        }
        return sb.toString();
    }

    private final class ReconcileEnvCallback
    implements AbstractCompilationEnv.EnvCallback {
        private final ReconcileContext _context;
        private final GeneratedFileManager _gfm;

        private ReconcileEnvCallback(ReconcileContext context, GeneratedFileManager gfm) {
            this._context = context;
            this._gfm = gfm;
        }

        @Override
        public void run(AbstractCompilationEnv env) {
            ReconcileEnv reconcileEnv = (ReconcileEnv)env;
            try {
                APTDispatchRunnable.this.dispatchToFileBasedProcessor(reconcileEnv, true, true);
            }
            catch (Throwable t) {
                AptPlugin.log(t, "Processor failure during reconcile");
            }
            ICompilationUnit parentWC = this._context.getWorkingCopy();
            Set<IFile> newlyGeneratedFiles = reconcileEnv.getAllGeneratedFiles();
            this._gfm.deleteObsoleteTypesAfterReconcile(parentWC, newlyGeneratedFiles);
            List<? extends CategorizedProblem> problemList = reconcileEnv.getProblems();
            int numProblems = problemList.size();
            if (numProblems > 0) {
                CategorizedProblem[] aptCatProblems = new CategorizedProblem[numProblems];
                this._context.putProblems("org.eclipse.jdt.apt.core.compile.problem", problemList.toArray(aptCatProblems));
            }
            reconcileEnv.close();
        }
    }
}

