/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.forcing.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.forcing.ForcingPackage;
import org.eclipse.stem.diseasemodels.forcing.GaussianForcingDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIRImpl;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;

public class GaussianForcingDiseaseModelImpl
extends SIRImpl
implements GaussianForcingDiseaseModel {
    protected static final double SIGMA2_EDEFAULT = 100.0;
    protected double sigma2 = 100.0;
    protected static final double MODULATION_PERIOD_EDEFAULT = 365.25;
    protected double modulationPeriod = 365.25;
    protected static final double MODULATION_PHASE_SHIFT_EDEFAULT = 0.0;
    protected double modulationPhaseShift = 0.0;
    protected static final double MODULATION_FLOOR_EDEFAULT = 0.6;
    protected double modulationFloor = 0.6;
    private static final int WINDOWSIZE = 30;

    protected EClass eStaticClass() {
        return ForcingPackage.Literals.GAUSSIAN_FORCING_DISEASE_MODEL;
    }

    @Override
    public double getSigma2() {
        return this.sigma2;
    }

    @Override
    public void setSigma2(double newSigma2) {
        this.sigma2 = newSigma2;
    }

    @Override
    public double getModulationPeriod() {
        return this.modulationPeriod;
    }

    @Override
    public void setModulationPeriod(double newModulationPeriod) {
        this.modulationPeriod = newModulationPeriod;
    }

    @Override
    public double getModulationPhaseShift() {
        return this.modulationPhaseShift;
    }

    @Override
    public void setModulationPhaseShift(double newModulationPhaseShift) {
        this.modulationPhaseShift = newModulationPhaseShift;
    }

    @Override
    public double getModulationFloor() {
        return this.modulationFloor;
    }

    @Override
    public void setModulationFloor(double newModulationFloor) {
        this.modulationFloor = newModulationFloor;
    }

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedTransmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        double adjustedImmunityLossRate = this.getAdjustedImmunityLossRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SIRLabelValue currentSIR = (SIRLabelValue)currentState;
            double modulationPeriod = this.getModulationPeriod();
            double sigma2 = this.getSigma2();
            int year = (int)(t / modulationPeriod);
            int nextDayYear = (int)((t + 1.0) / modulationPeriod);
            double modulatedTransmissionRate = 0.0;
            if (t % modulationPeriod < 30.0 || t % modulationPeriod > modulationPeriod - 30.0) {
                double fday = (t % modulationPeriod - modulationPeriod / 2.0) / modulationPeriod;
                double f1 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday, 2.0) / (2.0 * sigma2)));
                double f2 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday - 1.0, 2.0) / (2.0 * sigma2)));
                double f3 = adjustedTransmissionRate * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday + 1.0, 2.0) / (2.0 * sigma2)));
                double pos = t % modulationPeriod > modulationPeriod - 30.0 ? 30.0 - (modulationPeriod - t % modulationPeriod) : 30.0 + t % modulationPeriod;
                pos = Math.round(pos);
                double smooth = 0.0;
                smooth = pos == 30.0 && nextDayYear == year ? 0.5 * f1 + 0.5 * f3 : (pos == 30.0 && nextDayYear == year + 1 ? 0.5 * f1 + 0.5 * f2 : (pos < 30.0 ? (60.0 - pos) / 60.0 * f1 + pos / 60.0 * f2 : pos / 60.0 * f1 + (60.0 - pos) / 60.0 * f3));
                modulatedTransmissionRate = smooth;
            } else {
                double fday = (t % modulationPeriod - modulationPeriod / 2.0) / modulationPeriod;
                modulatedTransmissionRate = this.getAdjustedTransmissionRate(timeDelta) * (this.getModulationFloor() + (1.0 - this.getModulationFloor()) * Math.exp(-Math.pow(fday, 2.0) / (2.0 * sigma2)));
            }
            if (!this.isFrequencyDependent()) {
                modulatedTransmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfInfectedToRecovered = adjustedRecoveryRate * currentSIR.getI();
            double numberOfRecoveredToSusceptible = adjustedImmunityLossRate * currentSIR.getR();
            double numberOfSusceptibleToInfected = 0.0;
            numberOfSusceptibleToInfected = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? modulatedTransmissionRate * currentSIR.getS() * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : modulatedTransmissionRate * currentSIR.getS() * effectiveInfectious;
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToInfected;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToRecovered;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            Exchange siExchange = (Exchange)ExchangePool.POOL.get();
            siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            siExchange.setCount(numberOfSusceptibleToInfected);
            siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)siExchange);
            Exchange irExchange = (Exchange)ExchangePool.POOL.get();
            irExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            irExchange.setTarget(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            irExchange.setCount(numberOfInfectedToRecovered);
            irExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)irExchange);
            Exchange rsExchange = (Exchange)ExchangePool.POOL.get();
            rsExchange.setSource(StandardPackage.eINSTANCE.getSIRLabelValue_R());
            rsExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            rsExchange.setCount(numberOfRecoveredToSusceptible);
            rsExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            deltaValue.getDepartures().add((Object)rsExchange);
            SIRLabelValueImpl ret = (SIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(0.0);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 24: {
                return this.getSigma2();
            }
            case 25: {
                return this.getModulationPeriod();
            }
            case 26: {
                return this.getModulationPhaseShift();
            }
            case 27: {
                return this.getModulationFloor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 24: {
                this.setSigma2((Double)newValue);
                return;
            }
            case 25: {
                this.setModulationPeriod((Double)newValue);
                return;
            }
            case 26: {
                this.setModulationPhaseShift((Double)newValue);
                return;
            }
            case 27: {
                this.setModulationFloor((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 24: {
                this.setSigma2(100.0);
                return;
            }
            case 25: {
                this.setModulationPeriod(365.25);
                return;
            }
            case 26: {
                this.setModulationPhaseShift(0.0);
                return;
            }
            case 27: {
                this.setModulationFloor(0.6);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 24: {
                return this.sigma2 != 100.0;
            }
            case 25: {
                return this.modulationPeriod != 365.25;
            }
            case 26: {
                return this.modulationPhaseShift != 0.0;
            }
            case 27: {
                return this.modulationFloor != 0.6;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sigma2: ");
        result.append(this.sigma2);
        result.append(", modulationPeriod: ");
        result.append(this.modulationPeriod);
        result.append(", modulationPhaseShift: ");
        result.append(this.modulationPhaseShift);
        result.append(", modulationFloor: ");
        result.append(this.modulationFloor);
        result.append(')');
        return result.toString();
    }
}

