/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.field;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.internal.core.nd.INdStruct;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.NdNode;
import org.eclipse.jdt.internal.core.nd.RawGrowableArray;
import org.eclipse.jdt.internal.core.nd.field.BaseField;
import org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.eclipse.jdt.internal.core.nd.field.IRefCountedField;
import org.eclipse.jdt.internal.core.nd.field.StructDef;

public class FieldOneToMany<T extends INdStruct>
extends BaseField
implements IDestructableField,
IRefCountedField {
    public StructDef<T> targetType;
    public final StructDef<? extends INdStruct> localType;
    private final RawGrowableArray backPointerArray;
    FieldManyToOne<?> forwardPointer;

    private FieldOneToMany(StructDef<? extends INdStruct> localType, FieldManyToOne<? extends INdStruct> forwardPointer, int inlineElements) {
        this.localType = localType;
        if (forwardPointer != null) {
            if (forwardPointer.backPointer != null && forwardPointer.backPointer != this) {
                throw new IllegalArgumentException("Attempted to construct a FieldBackPointer referring to a forward pointer that is already in use by another field");
            }
            forwardPointer.targetType = localType;
            this.targetType = forwardPointer.localType;
            forwardPointer.backPointer = this;
        }
        this.forwardPointer = forwardPointer;
        this.setFieldName("field " + localType.getNumFields() + ", a " + this.getClass().getSimpleName() + " in struct " + localType.getStructName());
        this.backPointerArray = new RawGrowableArray(inlineElements);
    }

    public static <T extends INdStruct, B extends INdStruct> FieldOneToMany<T> create(StructDef<B> builder, FieldManyToOne<B> forwardPointer, int inlineElementCount) {
        FieldOneToMany<T> result = new FieldOneToMany<T>(builder, forwardPointer, inlineElementCount);
        builder.add(result);
        builder.addDestructableField(result);
        builder.addRefCountedField(result);
        return result;
    }

    public static <T extends INdStruct, B extends INdStruct> FieldOneToMany<T> create(StructDef<B> builder, FieldManyToOne<B> forwardPointer) {
        return FieldOneToMany.create(builder, forwardPointer, 0);
    }

    public void accept(Nd nd, long address, Visitor<T> visitor) {
        int size = this.size(nd, address);
        int idx = 0;
        while (idx < size) {
            visitor.visit(idx, this.get(nd, address, idx));
            ++idx;
        }
    }

    public List<T> asList(Nd nd, long address) {
        final ArrayList result = new ArrayList(this.size(nd, address));
        this.accept(nd, address, new Visitor<T>(){

            @Override
            public void visit(int index, T toVisit) {
                result.add(toVisit);
            }
        });
        return result;
    }

    public boolean isEmpty(Nd nd, long address) {
        return this.backPointerArray.isEmpty(nd, address + (long)this.offset);
    }

    public int size(Nd nd, long address) {
        return this.backPointerArray.size(nd, address + (long)this.offset);
    }

    public T get(Nd nd, long address, int index) {
        long nextPointer = this.backPointerArray.get(nd, address + (long)this.offset, index);
        return NdNode.load(nd, nextPointer, this.targetType);
    }

    public long getAddressOf(Nd nd, long address, int index) {
        return this.backPointerArray.get(nd, address + (long)this.offset, index);
    }

    void remove(Nd nd, long address, int index) {
        long swappedElement = this.backPointerArray.remove(nd, address + (long)this.offset, index);
        if (swappedElement != 0L) {
            this.forwardPointer.adjustIndex(nd, swappedElement, index);
        }
    }

    int add(Nd nd, long address, long value) {
        return this.backPointerArray.add(nd, address + (long)this.offset, value);
    }

    @Override
    public int getRecordSize() {
        return this.backPointerArray.getRecordSize();
    }

    public void ensureCapacity(Nd nd, long address, int capacity) {
        long arrayAddress = address + (long)this.offset;
        this.backPointerArray.ensureCapacity(nd, arrayAddress, capacity);
    }

    @Override
    public void destruct(Nd nd, long address) {
        long arrayAddress = address + (long)this.offset;
        int size = this.size(nd, address);
        boolean isOwner = this.forwardPointer.pointsToOwner;
        int idx = 0;
        while (idx < size) {
            long target = this.backPointerArray.get(nd, arrayAddress, idx);
            this.forwardPointer.clearedByBackPointer(nd, target);
            if (isOwner) {
                nd.scheduleDeletion(target);
            }
            ++idx;
        }
        this.backPointerArray.destruct(nd, arrayAddress);
    }

    public int getCapacity(Nd nd, long address) {
        return this.backPointerArray.getCapacity(nd, address + (long)this.offset);
    }

    @Override
    public boolean hasReferences(Nd nd, long address) {
        if (this.forwardPointer.pointsToOwner) {
            return false;
        }
        return !this.isEmpty(nd, address);
    }

    public static interface Visitor<T> {
        public void visit(int var1, T var2);
    }
}

