/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryExtendedListener;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.reports.Activator;
import org.eclipse.stem.ui.reports.views.PhaseSpaceCanvas;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.stem.ui.widgets.PropertySelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PhaseSpaceHistoryPlotter
extends ReportControl
implements RelativeValueHistoryExtendedListener,
ISimulationListener {
    PhaseSpaceCanvas phaseSpaceCanvas;
    PropertySelector propertySelectorX;
    PropertySelector propertySelectorY;
    ItemPropertyDescriptor selectedProperty1;
    ItemPropertyDescriptor selectedProperty2;
    private static final String X_AXIS_LABEL = "X Axis";
    private static final String Y_AXIS_LABEL = "Y Axis";
    boolean plotUpdateScheduled = false;

    public PhaseSpaceHistoryPlotter(Composite parent) {
        super(parent, 0);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        this.phaseSpaceCanvas = new PhaseSpaceCanvas(this);
        this.propertySelectorX = new PropertySelector((Composite)this, 0, true);
        this.propertySelectorX.setDisplayLabel(X_AXIS_LABEL);
        this.propertySelectorY = new PropertySelector((Composite)this, 0, true);
        this.propertySelectorY.setDisplayLabel(Y_AXIS_LABEL);
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText("remove");
        FormData titleFormData = new FormData();
        this.identifiableTitle.setLayoutData((Object)titleFormData);
        titleFormData.top = new FormAttachment(0, 0);
        titleFormData.left = new FormAttachment(0, 0);
        titleFormData.right = new FormAttachment(100, 0);
        FormData chartFormData = new FormData();
        this.phaseSpaceCanvas.setLayoutData(chartFormData);
        chartFormData.top = new FormAttachment((Control)this.identifiableTitle, 0);
        chartFormData.bottom = new FormAttachment((Control)this.propertySelectorY, 0);
        chartFormData.left = new FormAttachment(0, 0);
        chartFormData.right = new FormAttachment(100, 0);
        FormData propertySelectorFormDataY = new FormData();
        propertySelectorFormDataY.bottom = new FormAttachment(100, 0);
        propertySelectorFormDataY.left = new FormAttachment(0, 0);
        propertySelectorFormDataY.right = new FormAttachment(30, 0);
        this.propertySelectorY.setLayoutData((Object)propertySelectorFormDataY);
        FormData propertySelectorFormDataX = new FormData();
        propertySelectorFormDataX.bottom = new FormAttachment(100, 0);
        propertySelectorFormDataX.left = new FormAttachment((Control)this.propertySelectorY, 0);
        propertySelectorFormDataX.right = new FormAttachment(60, 0);
        this.propertySelectorX.setLayoutData((Object)propertySelectorFormDataX);
        FormData removeButtonFormData = new FormData();
        removeButtonFormData.bottom = new FormAttachment(100, 0);
        removeButtonFormData.left = new FormAttachment((Control)this.propertySelectorX, 0);
        removeButtonFormData.right = new FormAttachment(90, 0);
        this.removeButton.setLayoutData((Object)removeButtonFormData);
        final PhaseSpaceHistoryPlotter self = this;
        this.propertySelectorX.addPropertySelectionListener(new PropertySelector.PropertySelectionListener(){

            public void propertySelected(PropertySelector.PropertySelectionEvent propertySelectionEvent) {
                PhaseSpaceHistoryPlotter.this.selectedDecorator = propertySelectionEvent.getDecorator();
                PhaseSpaceHistoryPlotter.this.selectedProperty2 = propertySelectionEvent.getProperty();
                String selectedId = propertySelectionEvent.getId();
                List allLabels = (List)PhaseSpaceHistoryPlotter.this.decoratorToLabelsMap.get(PhaseSpaceHistoryPlotter.this.selectedDecorator);
                for (DynamicLabel lab : allLabels) {
                    if (!(lab instanceof DiseaseModelLabel) || !((DiseaseModelLabel)lab).getPopulationModelLabel().getPopulationIdentifier().equals(selectedId)) continue;
                    PhaseSpaceHistoryPlotter.this.selectedDynamicLabel = lab;
                    break;
                }
                if (PhaseSpaceHistoryPlotter.this.selectedDynamicLabel != null) {
                    RelativeValueHistoryProviderAdapter rhvp = (RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)PhaseSpaceHistoryPlotter.this.selectedDynamicLabel, RelativeValueHistoryProvider.class);
                    PhaseSpaceHistoryPlotter.this.switchToRVHP(rhvp);
                    self.phaseSpaceCanvas.setDataSourceAndRedraw(rhvp, PhaseSpaceHistoryPlotter.this.selectedProperty2, PhaseSpaceHistoryPlotter.this.selectedProperty1);
                }
            }
        });
        this.propertySelectorY.addPropertySelectionListener(new PropertySelector.PropertySelectionListener(){

            public void propertySelected(PropertySelector.PropertySelectionEvent propertySelectionEvent) {
                PhaseSpaceHistoryPlotter.this.selectedDecorator = propertySelectionEvent.getDecorator();
                PhaseSpaceHistoryPlotter.this.selectedProperty1 = propertySelectionEvent.getProperty();
                String selectedId = propertySelectionEvent.getId();
                List allLabels = (List)PhaseSpaceHistoryPlotter.this.decoratorToLabelsMap.get(PhaseSpaceHistoryPlotter.this.selectedDecorator);
                for (DynamicLabel lab : allLabels) {
                    if (!(lab instanceof DiseaseModelLabel) || !((DiseaseModelLabel)lab).getPopulationModelLabel().getPopulationIdentifier().equals(selectedId)) continue;
                    PhaseSpaceHistoryPlotter.this.selectedDynamicLabel = lab;
                    break;
                }
                if (PhaseSpaceHistoryPlotter.this.selectedDynamicLabel != null) {
                    RelativeValueHistoryProviderAdapter rhvp = (RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)PhaseSpaceHistoryPlotter.this.selectedDynamicLabel, RelativeValueHistoryProvider.class);
                    PhaseSpaceHistoryPlotter.this.switchToRVHP(rhvp);
                    self.phaseSpaceCanvas.setDataSourceAndRedraw(rhvp, PhaseSpaceHistoryPlotter.this.selectedProperty2, PhaseSpaceHistoryPlotter.this.selectedProperty1);
                }
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PhaseSpaceHistoryPlotter.this.fireRemoveEvent(PhaseSpaceHistoryPlotter.this.identifiable);
                PhaseSpaceHistoryPlotter.this.remove();
            }
        });
    }

    @Override
    public void remove() {
        this.removeListeners.clear();
        this.switchToRVHP(null);
        this.relativeValueHistoryExtended(null);
        this.identifiableTitle.setText("");
        this.propertySelectorX.setDecorators(Collections.EMPTY_LIST);
        this.propertySelectorY.setDecorators(Collections.EMPTY_LIST);
        this.dispose();
    }

    @Override
    public void setIdentifiable(Identifiable identifiable) {
        Decorator dec0;
        if (this.identifiable == identifiable) {
            return;
        }
        this.identifiable = identifiable;
        ArrayList<Decorator> decorators = new ArrayList<Decorator>();
        this.decoratorToLabelsMap = new HashMap();
        this.identifiableTitle.setText(identifiable.getDublinCore().getTitle());
        if (identifiable instanceof Node) {
            Node node = (Node)identifiable;
            for (NodeLabel nodeLabel : node.getLabels()) {
                if (!(nodeLabel instanceof DynamicNodeLabel)) continue;
                DynamicNodeLabel dynamicNodeLabel = (DynamicNodeLabel)nodeLabel;
                RelativeValueHistoryProviderAdapter rvhp = (RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeLabel, RelativeValueHistoryProvider.class);
                if (rvhp == null) continue;
                Decorator decorator = dynamicNodeLabel.getDecorator();
                if (decorator != null) {
                    if (this.decoratorToLabelsMap.get(decorator) != null) {
                        List list = (List)this.decoratorToLabelsMap.get(decorator);
                        list.add(dynamicNodeLabel);
                    } else {
                        ArrayList<DynamicNodeLabel> newList = new ArrayList<DynamicNodeLabel>();
                        newList.add(dynamicNodeLabel);
                        this.decoratorToLabelsMap.put(decorator, newList);
                    }
                    if (decorators.contains(decorator)) continue;
                    decorators.add(decorator);
                    continue;
                }
                Activator.logError("DynamicLabel \"" + dynamicNodeLabel.getDublinCore().getTitle() + "\" does not have a Decorator", null);
            }
        }
        if (decorators != null && decorators.size() > 1 && !((dec0 = (Decorator)decorators.get(0)) instanceof DiseaseModel)) {
            int i = 1;
            while (i < decorators.size()) {
                Decorator dec = (Decorator)decorators.get(i);
                if (dec instanceof DiseaseModel) {
                    decorators.set(0, dec);
                    decorators.set(i, dec0);
                    break;
                }
                ++i;
            }
        }
        this.propertySelectorX.setDecorators(decorators);
        this.propertySelectorY.setDecorators(decorators);
        try {
            IPreferenceStore preferenceStore = org.eclipse.stem.ui.Activator.getDefault().getPreferenceStore();
            String yPreference = preferenceStore.getString("org.eclipse.stem.ui.initialattributename");
            String xPreference = preferenceStore.getString("org.eclipse.stem.ui.initialattributename2");
            this.propertySelectorY.setDisplayedProperty(yPreference);
            this.propertySelectorX.setDisplayedProperty(xPreference);
        }
        catch (Exception exception) {}
    }

    public void relativeValueHistoryExtended(final RelativeValueHistoryProviderAdapter rvhp) {
        if (this.plotUpdateScheduled) {
            return;
        }
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            try {
                this.plotUpdateScheduled = true;
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PhaseSpaceHistoryPlotter.this.phaseSpaceCanvas.setDataSourceAndRedraw(rvhp, PhaseSpaceHistoryPlotter.this.selectedProperty2, PhaseSpaceHistoryPlotter.this.selectedProperty1);
                        }
                        finally {
                            PhaseSpaceHistoryPlotter.this.plotUpdateScheduled = false;
                        }
                    }
                });
            }
            catch (Exception exception) {}
        }
    }

    public void simulationChanged(SimulationEvent event) {
        if (event.getSimulationState() == SimulationState.RESET) {
            this.phaseSpaceCanvas.resetData();
        }
        if (event.getSimulationState() == SimulationState.STOPPED) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation = null;
            this.switchToRVHP(null);
            this.relativeValueHistoryExtended(null);
            this.identifiableTitle.setText("");
            this.propertySelectorX.setDecorators(Collections.EMPTY_LIST);
            this.propertySelectorY.setDecorators(Collections.EMPTY_LIST);
        }
    }

    @Override
    protected void initializeFromSimulation(ISimulation simulation) {
        this.simulationNameLabel.setText(simulation.getName());
        this.propertySelectorX.setSimulation(simulation);
        this.propertySelectorY.setSimulation(simulation);
    }

    @Override
    public void refresh2() {
    }

    public void dispose() {
        super.dispose();
        if (this.rvhp != null) {
            this.rvhp.removeExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
    }

    @Override
    public Identifiable getIdentifiable() {
        return this.identifiable;
    }

    @Override
    public String getControlType() {
        return "IDENTIFIABLE_CONTROL_FACTORY";
    }
}

