/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.simulation;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.jobs.Activator;

public class SimulationCaching {
    public static final SimulationCaching INSTANCE = new SimulationCaching();
    private final Map<URI, Scenario> cachedScenarios = new WeakHashMap<URI, Scenario>();
    private boolean toUseCaching = false;

    private SimulationCaching() {
        this.setPreferences();
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SimulationCaching.this.setPreferences();
            }
        });
    }

    public boolean isScenarioInCache(URI scenarioURI) {
        return this.cachedScenarios.containsKey(scenarioURI);
    }

    public Scenario getCachedScenario(URI scenarioURI) {
        return this.cachedScenarios.get(scenarioURI);
    }

    public void addScenarioToCache(Scenario scenario) {
        if (scenario.getURI() == null) {
            return;
        }
        this.cachedScenarios.put(scenario.getURI(), scenario);
    }

    public boolean toUseCaching() {
        return this.toUseCaching;
    }

    protected void setPreferences() {
        IPreferenceStore preferenceSore = Activator.getDefault().getPreferenceStore();
        this.toUseCaching = preferenceSore.getBoolean("useScenariosCaching");
    }
}

