/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CompletionProposalComputerDescriptor {
    private static final String DEFAULT_CATEGORY_ID = "org.eclipse.jdt.ui.defaultProposalCategory";
    private static final String CATEGORY_ID = "categoryId";
    private static final String TYPE = "type";
    private static final String CLASS = "class";
    private static final String ACTIVATE = "activate";
    private static final String NEEDS_SORTING_AFTER_FILTERING = "needsSortingAfterFiltering";
    private static final String PARTITION = "partition";
    private static final Set<String> PARTITION_SET;
    private static final String PERFORMANCE_EVENT;
    private static final boolean MEASURE_PERFORMANCE;
    private static final long MAX_DELAY = 5000L;
    private static final String COMPUTE_COMPLETION_PROPOSALS = "computeCompletionProposals()";
    private static final String COMPUTE_CONTEXT_INFORMATION = "computeContextInformation()";
    private static final String SESSION_STARTED = "sessionStarted()";
    private static final String SESSION_ENDED = "sessionEnded()";
    private final String fId;
    private final String fName;
    private final String fClass;
    private final boolean fActivate;
    private final Set<String> fPartitions;
    private final IConfigurationElement fElement;
    private final CompletionProposalComputerRegistry fRegistry;
    private IJavaCompletionProposalComputer fComputer;
    private final CompletionProposalCategory fCategory;
    private String fLastError;
    private boolean fIsReportingDelay = false;
    private long fStart;
    boolean fTriedLoadingComputer = false;
    private boolean fNeedsSortingAfterFiltering;

    static {
        PERFORMANCE_EVENT = String.valueOf(JavaPlugin.getPluginId()) + "/perf/content_assist/extensions";
        MEASURE_PERFORMANCE = PerformanceStats.isEnabled((String)PERFORMANCE_EVENT);
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("__dftl_partition_content_type");
        partitions.add("__java_javadoc");
        partitions.add("__java_multiline_comment");
        partitions.add("__java_singleline_comment");
        partitions.add("__java_string");
        partitions.add("__java_character");
        PARTITION_SET = Collections.unmodifiableSet(partitions);
    }

    CompletionProposalComputerDescriptor(IConfigurationElement element, CompletionProposalComputerRegistry registry, List<CompletionProposalCategory> categories) throws InvalidRegistryObjectException, CoreException {
        Assert.isLegal((registry != null ? 1 : 0) != 0);
        Assert.isLegal((element != null ? 1 : 0) != 0);
        this.fRegistry = registry;
        this.fElement = element;
        IExtension extension = element.getDeclaringExtension();
        this.fId = extension.getUniqueIdentifier();
        this.checkNotNull(this.fId, "id");
        String name = extension.getLabel();
        this.fName = name.length() == 0 ? this.fId : name;
        HashSet<String> partitions = new HashSet<String>();
        IConfigurationElement[] children = element.getChildren(PARTITION);
        if (children.length == 0) {
            this.fPartitions = PARTITION_SET;
        } else {
            int i = 0;
            while (i < children.length) {
                String type = children[i].getAttribute(TYPE);
                this.checkNotNull(type, TYPE);
                partitions.add(type);
                ++i;
            }
            this.fPartitions = Collections.unmodifiableSet(partitions);
        }
        String activateAttribute = element.getAttribute(ACTIVATE);
        this.fActivate = Boolean.valueOf(activateAttribute);
        String needsSortingAfterFilteringAttribute = element.getAttribute(NEEDS_SORTING_AFTER_FILTERING);
        this.fNeedsSortingAfterFiltering = Boolean.valueOf(needsSortingAfterFilteringAttribute);
        this.fClass = element.getAttribute(CLASS);
        this.checkNotNull(this.fClass, CLASS);
        String categoryId = element.getAttribute(CATEGORY_ID);
        if (categoryId == null) {
            categoryId = DEFAULT_CATEGORY_ID;
        }
        CompletionProposalCategory category = null;
        for (CompletionProposalCategory cat : categories) {
            if (!cat.getId().equals(categoryId)) continue;
            category = cat;
            break;
        }
        if (category == null) {
            this.fCategory = new CompletionProposalCategory(categoryId, this.fName, registry);
            categories.add(this.fCategory);
        } else {
            this.fCategory = category;
        }
    }

    private void checkNotNull(Object value, String attribute) throws InvalidRegistryObjectException, CoreException {
        if (value == null) {
            Object[] args = new Object[]{this.getId(), this.fElement.getContributor().getName(), attribute};
            String message = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_illegal_attribute_message, args);
            Status status = new Status(2, JavaPlugin.getPluginId(), 0, message, null);
            throw new CoreException((IStatus)status);
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public Set<String> getPartitions() {
        return this.fPartitions;
    }

    private synchronized IJavaCompletionProposalComputer getComputer(boolean canCreate) throws CoreException, InvalidRegistryObjectException {
        if (this.fComputer == null && canCreate && !this.fTriedLoadingComputer && (this.fActivate || this.isPluginLoaded())) {
            this.fTriedLoadingComputer = true;
            this.fComputer = this.createComputer();
        }
        return this.fComputer;
    }

    private boolean isPluginLoaded() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() == 32;
    }

    private Bundle getBundle() {
        String namespace = this.fElement.getDeclaringExtension().getContributor().getName();
        Bundle bundle = Platform.getBundle((String)namespace);
        return bundle;
    }

    public IJavaCompletionProposalComputer createComputer() throws CoreException, InvalidRegistryObjectException {
        return (IJavaCompletionProposalComputer)this.fElement.createExecutableExtension(CLASS);
    }

    /*
     * Exception decompiling
     */
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IStatus status;
        block14: {
            block13: {
                IJavaCompletionProposalComputer computer;
                block12: {
                    if (!this.isEnabled()) {
                        return Collections.emptyList();
                    }
                    computer = this.getComputer(true);
                    if (computer != null) break block12;
                    List<IContextInformation> list = Collections.emptyList();
                    monitor.done();
                    return list;
                }
                PerformanceStats stats = this.startMeter(context, computer);
                List<IContextInformation> proposals = computer.computeContextInformation(context, monitor);
                this.stopMeter(stats, COMPUTE_CONTEXT_INFORMATION);
                if (proposals == null) break block13;
                this.fLastError = computer.getErrorMessage();
                List<IContextInformation> list = proposals;
                monitor.done();
                return list;
            }
            try {
                status = this.createAPIViolationStatus(COMPUTE_CONTEXT_INFORMATION);
            }
            catch (InvalidRegistryObjectException x) {
                status = this.createExceptionStatus(x);
                monitor.done();
                break block14;
            }
            catch (CoreException x) {
                status = this.createExceptionStatus(x);
                break block14;
            }
            catch (RuntimeException x) {
                status = this.createExceptionStatus(x);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
                break block14;
            }
            {
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        this.fRegistry.informUser(this, status);
        return Collections.emptyList();
    }

    public void sessionStarted() {
        IStatus status;
        if (!this.isEnabled()) {
            return;
        }
        try {
            IJavaCompletionProposalComputer computer = this.getComputer(true);
            if (computer == null) {
                return;
            }
            PerformanceStats stats = this.startMeter(SESSION_STARTED, computer);
            computer.sessionStarted();
            this.stopMeter(stats, SESSION_ENDED);
            return;
        }
        catch (InvalidRegistryObjectException x) {
            status = this.createExceptionStatus(x);
        }
        catch (CoreException x) {
            status = this.createExceptionStatus(x);
        }
        catch (RuntimeException x) {
            status = this.createExceptionStatus(x);
        }
        this.fRegistry.informUser(this, status);
    }

    public void sessionEnded() {
        IStatus status;
        if (!this.isEnabled()) {
            return;
        }
        try {
            IJavaCompletionProposalComputer computer = this.getComputer(false);
            if (computer == null) {
                return;
            }
            PerformanceStats stats = this.startMeter(SESSION_ENDED, computer);
            computer.sessionEnded();
            this.stopMeter(stats, SESSION_ENDED);
            return;
        }
        catch (InvalidRegistryObjectException x) {
            status = this.createExceptionStatus(x);
        }
        catch (CoreException x) {
            status = this.createExceptionStatus(x);
        }
        catch (RuntimeException x) {
            status = this.createExceptionStatus(x);
        }
        this.fRegistry.informUser(this, status);
    }

    private PerformanceStats startMeter(Object context, IJavaCompletionProposalComputer computer) {
        PerformanceStats stats;
        if (MEASURE_PERFORMANCE) {
            stats = PerformanceStats.getStats((String)PERFORMANCE_EVENT, (Object)computer);
            stats.startRun(context.toString());
        } else {
            stats = null;
        }
        if (this.fIsReportingDelay) {
            this.fStart = System.currentTimeMillis();
        }
        return stats;
    }

    private void stopMeter(PerformanceStats stats, String operation) {
        long current;
        if (MEASURE_PERFORMANCE) {
            stats.endRun();
            if (stats.isFailure()) {
                IStatus status = this.createPerformanceStatus(operation);
                this.fRegistry.informUser(this, status);
                return;
            }
        }
        if (this.fIsReportingDelay && (current = System.currentTimeMillis()) - this.fStart > 5000L) {
            IStatus status = this.createPerformanceStatus(operation);
            this.fRegistry.informUser(this, status);
        }
    }

    private IStatus createExceptionStatus(InvalidRegistryObjectException x) {
        String blame = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_invalid;
        return new Status(1, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createExceptionStatus(CoreException x) {
        String blame = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_instantiation;
        return new Status(4, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createExceptionStatus(RuntimeException x) {
        String blame = this.createBlameMessage();
        String reason = JavaTextMessages.CompletionProposalComputerDescriptor_reason_runtime_ex;
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, (Throwable)x);
    }

    private IStatus createAPIViolationStatus(String operation) {
        String blame = this.createBlameMessage();
        Object[] args = new Object[]{operation};
        String reason = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_API, args);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, null);
    }

    private IStatus createPerformanceStatus(String operation) {
        String blame = this.createBlameMessage();
        Object[] args = new Object[]{operation};
        String reason = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_reason_performance, args);
        return new Status(2, JavaPlugin.getPluginId(), 0, String.valueOf(blame) + " " + reason, null);
    }

    private String createBlameMessage() {
        Object[] args = new Object[]{this.getName(), this.fElement.getDeclaringExtension().getContributor().getName()};
        String disable = Messages.format(JavaTextMessages.CompletionProposalComputerDescriptor_blame_message, args);
        return disable;
    }

    private boolean isEnabled() {
        return this.fCategory.isEnabled();
    }

    CompletionProposalCategory getCategory() {
        return this.fCategory;
    }

    public String getErrorMessage() {
        return this.fLastError;
    }

    IContributor getContributor() {
        try {
            return this.fElement.getContributor();
        }
        catch (InvalidRegistryObjectException invalidRegistryObjectException) {
            return null;
        }
    }

    public boolean isSortingAfterFilteringNeeded() {
        return this.fNeedsSortingAfterFiltering;
    }
}

