/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.IReentrantTypeResolver;

@NonNullByDefault
public class DefaultBatchTypeResolver
implements IBatchTypeResolver {
    @Inject
    private Provider<IReentrantTypeResolver> typeResolverProvider;

    public IResolvedTypes resolveTypes(@Nullable EObject object) {
        if (object == null || object.eIsProxy()) {
            return IResolvedTypes.NULL;
        }
        IReentrantTypeResolver reentrantResolver = this.getTypeResolver(object);
        return reentrantResolver.reentrantResolve();
    }

    protected IReentrantTypeResolver getTypeResolver(EObject object) {
        EObject root = EcoreUtil.getRootContainer((EObject)object);
        IReentrantTypeResolver result = this.getOrCreateResolver(root);
        return result;
    }

    protected IReentrantTypeResolver getOrCreateResolver(EObject root) {
        EList adapters = root.eAdapters();
        TypeResolutionStateAdapter currentAdapter = (TypeResolutionStateAdapter)EcoreUtil.getAdapter((List)adapters, TypeResolutionStateAdapter.class);
        if (currentAdapter == null) {
            final IReentrantTypeResolver newResolver = (IReentrantTypeResolver)this.typeResolverProvider.get();
            TypeResolutionStateAdapter newAdapter = new TypeResolutionStateAdapter(root, newResolver);
            adapters.add(newAdapter);
            IReentrantTypeResolver result = new IReentrantTypeResolver((List)adapters, newAdapter){
                private final /* synthetic */ List val$adapters;
                private final /* synthetic */ TypeResolutionStateAdapter val$newAdapter;
                {
                    this.val$adapters = list;
                    this.val$newAdapter = typeResolutionStateAdapter;
                }

                public IResolvedTypes reentrantResolve() {
                    IResolvedTypes result = newResolver.reentrantResolve();
                    if (!this.val$adapters.remove(this.val$newAdapter)) {
                        throw new IllegalStateException("The TypeResolutionStateAdapter was removed while resolving");
                    }
                    return result;
                }

                public void initializeFrom(EObject root) {
                    newResolver.initializeFrom(root);
                }
            };
            result.initializeFrom(root);
            return result;
        }
        return currentAdapter;
    }

    public static class TypeResolutionStateAdapter
    extends AdapterImpl
    implements IReentrantTypeResolver {
        private final IReentrantTypeResolver context;

        public TypeResolutionStateAdapter(EObject associatedWith, IReentrantTypeResolver context) {
            this.context = context;
            associatedWith.eAdapters().add((Object)this);
        }

        public boolean isAdapterForType(@Nullable Object type) {
            return TypeResolutionStateAdapter.class.equals(type);
        }

        public IReentrantTypeResolver getContext() {
            return this.context;
        }

        public void initializeFrom(EObject root) {
            throw new IllegalStateException("Attempt to reinitialize the root resolver");
        }

        public IResolvedTypes reentrantResolve() {
            return this.context.reentrantResolve();
        }
    }
}

