/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.geography.centers;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stem.data.geography.Activator;
import org.eclipse.stem.geography.names.GeographicMapper;
import org.osgi.framework.Bundle;

public class PluginCenterReader
extends GeographicMapper {
    public static Map<String, String> regionCentersMap = new HashMap<String, String>();
    public static final String GEOGRAPHY_DATA_PLUGIN = "org.eclipse.stem.data.geography";
    public static final String DATA_PATH = "src/org/eclipse/stem/data/geography/centers/";
    public static Bundle geoBundle;
    static List<URL> allCentersFiles;
    List<String> allCountryIDs = new ArrayList<String>();

    static {
        allCentersFiles = new ArrayList<URL>();
    }

    public PluginCenterReader() {
        try {
            geoBundle = Platform.getBundle((String)GEOGRAPHY_DATA_PLUGIN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PluginCenterReader.getAllCenterFileNames();
        int i = 0;
        while (i < allCentersFiles.size()) {
            String id3;
            URL url = allCentersFiles.get(i);
            this.readCenters(url);
            int idx = url.toString().indexOf("_centers.properties");
            if (idx > 3 && (id3 = url.toString().substring(idx - 3, idx)).indexOf("ZZZ") == -1) {
                this.allCountryIDs.add(id3);
            }
            ++i;
        }
    }

    public PluginCenterReader(List<URL> centersFiles) {
        allCentersFiles = centersFiles;
        PluginCenterReader.getAllCenterFileNames();
        int i = 0;
        while (i < allCentersFiles.size()) {
            String id3;
            URL url = allCentersFiles.get(i);
            this.readCenters(url);
            int idx = url.toString().indexOf("_centers.properties");
            if (idx > 3 && (id3 = url.toString().substring(idx - 3, idx)).indexOf("ZZZ") == -1) {
                this.allCountryIDs.add(id3);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        new PluginCenterReader();
    }

    public String[] getCountryIDs() {
        Object[] id3s = this.allCountryIDs.toArray(new String[this.allCountryIDs.size()]);
        Arrays.sort(id3s);
        return id3s;
    }

    public Map<String, String> readCenters(URL url) {
        BufferedReader fileReader = PluginCenterReader.openReader(url);
        try {
            if (fileReader != null) {
                String buffer = null;
                while (!PluginCenterReader.EOF(buffer = fileReader.readLine())) {
                    if (buffer.indexOf("SOURCE") != -1 || buffer.indexOf("VALID") != -1 || buffer.indexOf("#") != -1 || buffer.indexOf("=") < 0) continue;
                    StringTokenizer tokenizer = new StringTokenizer(buffer, "=");
                    String stemID2 = tokenizer.nextToken().trim();
                    String center = tokenizer.nextToken();
                    regionCentersMap.put(stemID2, center);
                }
            }
        }
        catch (Exception e) {
            Activator.logInformation((String)("Error reading file" + url));
            e.printStackTrace();
            System.exit(1);
        }
        return regionCentersMap;
    }

    protected static BufferedReader openReader(URL url) {
        try {
            return new BufferedReader(new InputStreamReader(url.openStream()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static boolean EOF(String buffer) {
        return buffer == null;
    }

    protected static void getAllCenterFileNames() {
        try {
            Enumeration allFiles = geoBundle.findEntries(DATA_PATH, "*.properties", false);
            URL[] dataFiles = PluginCenterReader.filterAndSortFiles(allFiles);
            int j = 0;
            while (j < dataFiles.length) {
                allCentersFiles.add(dataFiles[j]);
                ++j;
            }
        }
        catch (Exception e) {
            Activator.logInformation((String)("Error reading file" + e.getMessage()));
            e.printStackTrace();
            System.exit(1);
        }
    }

    static URL[] filterAndSortFiles(Enumeration<URL> allFiles) {
        ArrayList<URL> filtered = new ArrayList<URL>();
        while (allFiles.hasMoreElements()) {
            URL url = allFiles.nextElement();
            if (url.getPath().indexOf("_centers.properties") < 1) continue;
            filtered.add(url);
        }
        URL[] retVal = new URL[filtered.size()];
        int i = 0;
        while (i < filtered.size()) {
            retVal[i] = (URL)filtered.get(i);
            ++i;
        }
        Arrays.sort(retVal, new Comparator<URL>(){

            @Override
            public int compare(URL ua, URL ub) {
                return ua.getPath().compareTo(ub.toString());
            }
        });
        return retVal;
    }

    static File[] filterAndSortCountryDirs(File[] files) {
        ArrayList<File> filtered = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            String name = files[i].getName();
            if (name.indexOf("svn") <= -1 && name.indexOf("ZZZ") <= -1 && name.indexOf("DS_Store") <= -1) {
                filtered.add(files[i]);
            }
            ++i;
        }
        Object[] retVal = new File[filtered.size()];
        int i2 = 0;
        while (i2 < filtered.size()) {
            retVal[i2] = (File)filtered.get(i2);
            ++i2;
        }
        Arrays.sort(retVal);
        return retVal;
    }

    public double getLatitude(String id) {
        if (regionCentersMap.containsKey(id)) {
            String center = regionCentersMap.get(id);
            StringTokenizer tokenizer = new StringTokenizer(center, ",");
            String lat = tokenizer.nextToken().trim();
            double latVal = new Double(lat);
            return latVal;
        }
        Activator.logInformation((String)("1. CenterReader(): Error, region " + id + " not found"));
        return -999.0;
    }

    public double[] getLatLong(String id) {
        double[] retVal = new double[2];
        if (regionCentersMap.containsKey(id)) {
            String center = regionCentersMap.get(id);
            StringTokenizer tokenizer = new StringTokenizer(center, ",");
            String lat = tokenizer.nextToken().trim();
            String lng = tokenizer.nextToken().trim();
            retVal[0] = new Double(lat);
            retVal[1] = new Double(lng);
            return retVal;
        }
        Activator.logInformation((String)("2. CenterReader(): Warning, region " + id + " not found"));
        return null;
    }
}

