/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmComponentType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.util.Strings;

public class IndexedJvmTypeAccess {
    private static final Logger logger = Logger.getLogger(IndexedJvmTypeAccess.class);
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;

    public EObject getIndexedJvmType(URI javaObjectURI, ResourceSet resourceSet) {
        if (resourceSet != null) {
            URI withoutFragment = javaObjectURI.trimFragment();
            String fqn = withoutFragment.segment(withoutFragment.segmentCount() - 1);
            List fqnSegments = Strings.split((String)fqn, (char)'.');
            QualifiedName qualifiedName = QualifiedName.create((String[])fqnSegments.toArray(new String[fqnSegments.size()]));
            return this.getIndexedJvmType(qualifiedName, javaObjectURI.fragment(), resourceSet);
        }
        return null;
    }

    public EObject getIndexedJvmType(QualifiedName qualifiedName, String fragment, ResourceSet resourceSet) {
        Iterable candidates;
        Iterator iterator;
        IResourceDescriptions descriptions;
        if (resourceSet != null && (descriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet)) != null && (iterator = (candidates = descriptions.getExportedObjects(TypesPackage.Literals.JVM_TYPE, qualifiedName, false)).iterator()).hasNext()) {
            IEObjectDescription description = (IEObjectDescription)iterator.next();
            EObject typeProxy = description.getEObjectOrProxy();
            if (typeProxy.eIsProxy()) {
                typeProxy = EcoreUtil.resolve((EObject)typeProxy, (ResourceSet)resourceSet);
            }
            if (!typeProxy.eIsProxy() && typeProxy instanceof JvmType) {
                if (fragment != null) {
                    EObject result = this.resolveJavaObject((JvmType)typeProxy, fragment);
                    if (result != null) {
                        return result;
                    }
                } else {
                    return typeProxy;
                }
            }
        }
        return null;
    }

    public EObject resolveJavaObject(JvmType rootType, String fragment) {
        block10: {
            int dot;
            int dollar;
            int max;
            block9: {
                if (fragment.endsWith("[]")) {
                    return this.resolveJavaArrayObject(rootType, fragment);
                }
                int slash = fragment.indexOf(47);
                if (slash == -1) break block9;
                if (slash == 0) {
                    return null;
                }
                String containerFragment = fragment.substring(0, slash);
                EObject container = this.resolveJavaObject(rootType, containerFragment);
                if (container == null) break block10;
                String parameterName = fragment.substring(slash + 1);
                if (container instanceof JvmTypeParameterDeclarator) {
                    JvmTypeParameterDeclarator executable = (JvmTypeParameterDeclarator)container;
                    for (JvmTypeParameter parameter : executable.getTypeParameters()) {
                        if (!parameter.getName().equals(parameterName)) continue;
                        return parameter;
                    }
                }
                break block10;
            }
            if (rootType.getIdentifier().equals(fragment)) {
                return rootType;
            }
            int paren = fragment.indexOf(40);
            if (paren == -1) {
                paren = fragment.length();
            }
            if ((max = Math.max(dollar = fragment.lastIndexOf(36, paren), dot = fragment.lastIndexOf(46, paren))) == -1) {
                logger.warn((Object)("Couldn't resolve java object for root type " + rootType.getQualifiedName() + " and fragment '" + fragment), (Throwable)new Exception());
                return null;
            }
            String subFragment = fragment.substring(0, max);
            EObject container = this.resolveJavaObject(rootType, subFragment);
            if (container instanceof JvmDeclaredType) {
                EList<JvmMember> members = ((JvmDeclaredType)container).getMembers();
                for (JvmMember member : members) {
                    String name;
                    if (!(member instanceof JvmType) || !(name = member.getIdentifier()).equals(fragment)) continue;
                    return member;
                }
            }
        }
        return null;
    }

    public EObject resolveJavaArrayObject(JvmType rootType, String fragment) {
        JvmComponentType component = (JvmComponentType)this.resolveJavaObject(rootType, fragment.substring(0, fragment.length() - 2));
        if (component == null) {
            return null;
        }
        if (component.getArrayType() == null) {
            JvmArrayType arrayType = TypesFactory.eINSTANCE.createJvmArrayType();
            arrayType.setComponentType(component);
        }
        return component.getArrayType();
    }
}

