/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ds.ui.editor.sections;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.ds.core.IDSComponent;
import org.eclipse.pde.internal.ds.core.IDSModel;
import org.eclipse.pde.internal.ds.core.IDSProvide;
import org.eclipse.pde.internal.ds.ui.Messages;
import org.eclipse.pde.internal.ds.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ds.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ds.ui.parts.ComboPart;
import org.eclipse.pde.internal.ds.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DSOptionsSection
extends PDESection {
    private IDSComponent fComponent;
    private FormEntry fFactoryEntry;
    private IDSModel fModel;
    private Button fImmediateButton;
    private Button fEnabledButton;
    private ComboPart fConfigurationPolicy;

    public DSOptionsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        this.initializeAttributes();
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        section.setLayoutData((Object)data);
        section.setText(Messages.DSOptionsSection_title);
        section.setDescription(Messages.DSOptionsSection_description);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout(3, false));
        client.setLayoutData((Object)new GridData(768));
        this.fFactoryEntry = new FormEntry(client, toolkit, Messages.DSComponentDetails_factoryEntry, 0);
        Label label = toolkit.createLabel(client, Messages.DSComponentDetails_configurationPolicy, 64);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.fConfigurationPolicy = new ComboPart();
        this.fConfigurationPolicy.createControl(client, toolkit, 8);
        String[] items = new String[]{"", "optional", "require", "ignore"};
        this.fConfigurationPolicy.setItems(items);
        GridDataFactory.fillDefaults().grab(true, false).indent(3, 0).applyTo(this.fConfigurationPolicy.getControl());
        this.createButtons(client, toolkit);
        this.setListeners();
        this.updateUIFields();
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
    }

    private void createButtons(Composite parent, FormToolkit toolkit) {
        this.fEnabledButton = toolkit.createButton(parent, Messages.DSServiceComponentSection_enabledButtonMessage, 32);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        this.fEnabledButton.setLayoutData((Object)data);
        this.fEnabledButton.setEnabled(this.isEditable());
        this.fEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSOptionsSection.this.fModel.getDSComponent().setEnabled(DSOptionsSection.this.fEnabledButton.getSelection());
            }
        });
        this.fImmediateButton = toolkit.createButton(parent, Messages.DSServiceComponentSection_immediateButtonMessage, 32);
        this.fImmediateButton.setLayoutData((Object)data);
        this.fImmediateButton.setEnabled(this.isEditable());
        this.fImmediateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DSOptionsSection.this.fModel.getDSComponent().setImmediate(DSOptionsSection.this.fImmediateButton.getSelection());
            }
        });
    }

    private void initializeAttributes() {
        this.fModel = (IDSModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        this.fComponent = this.fModel.getDSComponent();
    }

    public void commit(boolean onSave) {
        this.fFactoryEntry.commit();
        super.commit(onSave);
    }

    public void modelChanged(IModelChangedEvent e) {
        Display display;
        this.fComponent = this.fModel.getDSComponent();
        if (e.getChangeType() == 99) {
            this.markStale();
        }
        if ((display = this.fEnabledButton.getDisplay()).getThread() == Thread.currentThread()) {
            this.updateUIFields();
        } else {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!DSOptionsSection.this.fEnabledButton.isDisposed()) {
                        DSOptionsSection.this.updateUIFields();
                    }
                }
            });
        }
    }

    public void updateUIFields() {
        if (this.fComponent != null) {
            if (this.fComponent.getFactory() == null) {
                this.fFactoryEntry.setValue("", true);
            } else {
                this.fFactoryEntry.setValue(this.fComponent.getFactory(), true);
            }
            this.fEnabledButton.setSelection(this.fComponent.getEnabled());
            this.fImmediateButton.setSelection(this.fComponent.getImmediate());
            this.enableOrDisableImmediate();
            if (this.fComponent.getConfigurationPolicy() != null) {
                this.fConfigurationPolicy.setText(this.fComponent.getConfigurationPolicy());
            }
        }
    }

    private void enableOrDisableImmediate() {
        IDSProvide[] providedServices;
        boolean isService = false;
        boolean isFactory = this.fComponent.getFactory() != null && !this.fComponent.getFactory().equals("");
        boolean isImmediate = this.fComponent.getImmediate();
        boolean enabled = true;
        if (this.fComponent.getService() != null && (providedServices = this.fComponent.getService().getProvidedServices()) != null && providedServices.length > 0) {
            isService = true;
        }
        if (!(isService || isFactory || isImmediate)) {
            enabled = false;
        }
        this.fImmediateButton.setEnabled(enabled);
    }

    public void setListeners() {
        this.fFactoryEntry.setFormEntryListener(new FormEntryAdapter((IContextPart)this){

            public void textValueChanged(FormEntry entry) {
                if (DSOptionsSection.this.fComponent == null) {
                    return;
                }
                DSOptionsSection.this.fComponent.setFactory(DSOptionsSection.this.fFactoryEntry.getValue());
            }
        });
        this.fConfigurationPolicy.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DSOptionsSection.this.fComponent == null) {
                    return;
                }
                DSOptionsSection.this.fComponent.setConfigurationPolicy(DSOptionsSection.this.fConfigurationPolicy.getSelection());
            }
        });
    }
}

