/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.geography.centers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.stem.data.geography.Activator;
import org.eclipse.stem.geography.names.GeographicMapper;

public class CenterReader
extends GeographicMapper {
    public static Map<String, String> regionCentersMap = new HashMap<String, String>();
    public static final String DATA_PATH = "/Users/jhkauf/Documents/workspace/org.eclipse.stem.data.geography/src/org/eclipse/stem/data/geography/centers/";
    public static String root;
    static List<String> allCentersFiles;
    List<String> allCountryIDs = new ArrayList<String>();

    static {
        allCentersFiles = new ArrayList<String>();
    }

    public CenterReader() {
        try {
            root = DATA_PATH;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CenterReader.getAllCenterFileNames();
        int i = 0;
        while (i < allCentersFiles.size()) {
            String id3;
            String fileName = allCentersFiles.get(i);
            this.readCenters(fileName);
            int idx = fileName.indexOf("_centers.properties");
            if (idx > 3 && (id3 = fileName.substring(idx - 3, idx)).indexOf("ZZZ") == -1) {
                this.allCountryIDs.add(id3);
            }
            ++i;
        }
    }

    public CenterReader(List<String> centersFiles) {
        allCentersFiles = centersFiles;
        CenterReader.getAllCenterFileNames();
        int i = 0;
        while (i < allCentersFiles.size()) {
            String id3;
            String fileName = allCentersFiles.get(i);
            this.readCenters(fileName);
            int idx = fileName.indexOf("_centers.properties");
            if (idx > 3 && (id3 = fileName.substring(idx - 3, idx)).indexOf("ZZZ") == -1) {
                this.allCountryIDs.add(id3);
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        new CenterReader();
    }

    public String[] getCountryIDs() {
        Object[] id3s = this.allCountryIDs.toArray(new String[this.allCountryIDs.size()]);
        Arrays.sort(id3s);
        return id3s;
    }

    public Map<String, String> readCenters(String fileName) {
        BufferedReader fileReader = CenterReader.openReader(fileName);
        try {
            if (fileReader != null) {
                String buffer = null;
                while (!CenterReader.EOF(buffer = fileReader.readLine())) {
                    if (buffer.indexOf("SOURCE") != -1 || buffer.indexOf("VALID") != -1 || buffer.indexOf("#") != -1 || buffer.indexOf("=") < 0) continue;
                    StringTokenizer tokenizer = new StringTokenizer(buffer, "=");
                    String stemID2 = tokenizer.nextToken().trim();
                    String center = tokenizer.nextToken();
                    regionCentersMap.put(stemID2, center);
                }
            }
        }
        catch (Exception e) {
            Activator.logInformation((String)("Error reading file" + fileName));
            e.printStackTrace();
            System.exit(1);
        }
        return regionCentersMap;
    }

    protected static BufferedReader openReader(String file) {
        block3: {
            try {
                File f = new File(file);
                if (f.exists()) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return new BufferedReader(new FileReader(file));
    }

    protected static boolean EOF(String buffer) {
        return buffer == null;
    }

    protected static void getAllCenterFileNames() {
        try {
            File f = new File(root);
            if (f.isDirectory()) {
                File[] dataFiles = CenterReader.filterAndSortFiles(f.listFiles());
                int j = 0;
                while (j < dataFiles.length) {
                    allCentersFiles.add(dataFiles[j].getAbsolutePath());
                    ++j;
                }
            }
        }
        catch (Exception e) {
            Activator.logInformation((String)("Error reading file" + e.getMessage()));
            e.printStackTrace();
            System.exit(1);
        }
    }

    static File[] filterAndSortFiles(File[] files) {
        ArrayList<File> filtered = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            String name = files[i].getName();
            if (name.indexOf("_centers.properties") >= 1) {
                filtered.add(files[i]);
            }
            ++i;
        }
        Object[] retVal = new File[filtered.size()];
        int i2 = 0;
        while (i2 < filtered.size()) {
            retVal[i2] = (File)filtered.get(i2);
            ++i2;
        }
        Arrays.sort(retVal);
        return retVal;
    }

    static File[] filterAndSortCountryDirs(File[] files) {
        ArrayList<File> filtered = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            String name = files[i].getName();
            if (name.indexOf("svn") <= -1 && name.indexOf("ZZZ") <= -1 && name.indexOf("DS_Store") <= -1) {
                filtered.add(files[i]);
            }
            ++i;
        }
        Object[] retVal = new File[filtered.size()];
        int i2 = 0;
        while (i2 < filtered.size()) {
            retVal[i2] = (File)filtered.get(i2);
            ++i2;
        }
        Arrays.sort(retVal);
        return retVal;
    }

    public double getLatitude(String id) {
        if (regionCentersMap.containsKey(id)) {
            String center = regionCentersMap.get(id);
            StringTokenizer tokenizer = new StringTokenizer(center, ",");
            String lat = tokenizer.nextToken().trim();
            double latVal = new Double(lat);
            return latVal;
        }
        Activator.logInformation((String)("1. CenterReader(): Error, region " + id + " not found"));
        return -999.0;
    }

    public double[] getLatLong(String id) {
        double[] retVal = new double[2];
        if (regionCentersMap.containsKey(id)) {
            String center = regionCentersMap.get(id);
            StringTokenizer tokenizer = new StringTokenizer(center, ",");
            String lat = tokenizer.nextToken().trim();
            String lng = tokenizer.nextToken().trim();
            retVal[0] = new Double(lat);
            retVal[1] = new Double(lng);
            return retVal;
        }
        Activator.logInformation((String)("2. CenterReader(): Warning, region " + id + " not found"));
        return null;
    }
}

