/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.common.base.Predicate;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.model.Regions;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AbstractAntlrTokenToAttributeIdMapper;
import org.eclipse.xtext.ui.editor.syntaxcoloring.AbstractTokenScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenScanner
extends AbstractTokenScanner {
    private RangedReentrantIterator reentrantIterator = new RangedReentrantIterator();
    private ILexerTokenRegion currentToken;
    @Inject
    private AbstractAntlrTokenToAttributeIdMapper tokenIdMapper;

    public void setTokenIdMapper(AbstractAntlrTokenToAttributeIdMapper tokenIdMapper) {
        this.tokenIdMapper = tokenIdMapper;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.currentToken = null;
        this.reentrantIterator.setRange(document, offset, length);
    }

    protected Iterable<ILexerTokenRegion> getTokens(IDocument document) {
        XtextDocument doc = (XtextDocument)document;
        return doc.getTokens();
    }

    public IToken nextToken() {
        if (!this.reentrantIterator.hasNext()) {
            return Token.EOF;
        }
        this.currentToken = this.reentrantIterator.next();
        return this.createToken(this.currentToken);
    }

    protected IToken createToken(ILexerTokenRegion currentToken) {
        String id = this.tokenIdMapper.getId(currentToken.getLexerTokenType());
        Token token = new Token((Object)this.getAttribute(id));
        return token;
    }

    public int getTokenOffset() {
        return this.currentToken.getOffset();
    }

    public int getTokenLength() {
        return this.currentToken.getLength();
    }

    protected Iterator<ILexerTokenRegion> getIterator() {
        return this.reentrantIterator;
    }

    protected ILexerTokenRegion getCurrentToken() {
        return this.currentToken;
    }

    protected void setCurrentToken(ILexerTokenRegion currentToken) {
        this.currentToken = currentToken;
    }

    protected AbstractAntlrTokenToAttributeIdMapper getTokenIdMapper() {
        return this.tokenIdMapper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RangedReentrantIterator
    extends UnmodifiableIterator<ILexerTokenRegion> {
        private Iterator<ILexerTokenRegion> delegate;
        private Iterable<ILexerTokenRegion> delegateIterable;
        private ILexerTokenRegion current = null;
        private boolean computedHasNext = false;
        private boolean hasNext = false;
        private Predicate<? super IRegion> overlapFilter;
        private int regionOffset;

        protected RangedReentrantIterator() {
        }

        public boolean hasNext() {
            if (this.computedHasNext) {
                return this.hasNext;
            }
            this.computedHasNext = true;
            while (this.delegate.hasNext()) {
                this.current = this.delegate.next();
                if (this.overlapFilter.apply((Object)this.current)) {
                    this.hasNext = true;
                    break;
                }
                if (this.current.getOffset() <= this.regionOffset) continue;
                this.hasNext = false;
                break;
            }
            return this.hasNext;
        }

        public ILexerTokenRegion next() {
            if (!this.computedHasNext) {
                this.hasNext();
            }
            if (!this.hasNext) {
                throw new NoSuchElementException("You should check for #hasNext prior to calling #next");
            }
            ILexerTokenRegion result = this.current;
            this.current = null;
            this.computedHasNext = false;
            this.hasNext = false;
            return result;
        }

        public void setRange(IDocument document, int offset, int length) {
            this.regionOffset = offset;
            this.overlapFilter = Regions.overlaps(offset, length);
            Iterable<ILexerTokenRegion> newIterable = TokenScanner.this.getTokens(document);
            if (this.delegateIterable != null && !this.delegateIterable.equals(newIterable)) {
                this.current = null;
            }
            if (this.current == null) {
                this.delegate = newIterable.iterator();
                this.delegateIterable = newIterable;
                this.computedHasNext = false;
                this.hasNext = false;
            } else if (this.current.getOffset() <= offset && this.current.getOffset() + this.current.getLength() > offset) {
                this.computedHasNext = true;
                this.hasNext = true;
            } else {
                this.computedHasNext = false;
                this.hasNext = false;
                this.delegate = newIterable.iterator();
                this.delegateIterable = newIterable;
            }
        }
    }
}

