/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerSupportRegistry;
import org.eclipse.ui.views.markers.internal.MarkerType;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.Util;

public class DialogProblemFilter
extends DialogMarkerFilter {
    private DescriptionGroup descriptionGroup;
    private SeverityGroup severityGroup;
    private Composite userFilterComposite;
    private Label systemSettingsLabel;
    private CheckboxTableViewer definedList;

    public DialogProblemFilter(Shell parentShell, ProblemFilter[] filters) {
        super(parentShell, filters);
    }

    protected void createAttributesArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.descriptionGroup = new DescriptionGroup(composite);
        this.severityGroup = new SeverityGroup(composite);
    }

    protected void updateFilterFromUI(MarkerFilter filter) {
        super.updateFilterFromUI(filter);
        ProblemFilter problemFilter = (ProblemFilter)filter;
        problemFilter.setContains(this.descriptionGroup.getContains());
        problemFilter.setDescription(this.descriptionGroup.getDescription().trim());
        problemFilter.setSelectBySeverity(this.severityGroup.isSeveritySelected());
        int severity = 0;
        if (this.severityGroup.isErrorSelected()) {
            severity |= 4;
        }
        if (this.severityGroup.isWarningSelected()) {
            severity |= 2;
        }
        if (this.severityGroup.isInfoSelected()) {
            severity |= 1;
        }
        problemFilter.setSeverity(severity);
    }

    protected void updateUIWithFilter(MarkerFilter filter) {
        ProblemFilter problemFilter = (ProblemFilter)filter;
        this.descriptionGroup.setContains(problemFilter.getContains());
        this.descriptionGroup.setDescription(problemFilter.getDescription());
        this.severityGroup.setEnabled(problemFilter.getSelectBySeverity());
        int severity = problemFilter.getSeverity();
        this.severityGroup.setErrorSelected((severity & 4) > 0);
        this.severityGroup.setWarningSelected((severity & 2) > 0);
        this.severityGroup.setInfoSelected((severity & 1) > 0);
        super.updateUIWithFilter(filter);
    }

    protected void updateEnabledState(boolean enabled) {
        super.updateEnabledState(enabled);
        this.descriptionGroup.updateEnablement(enabled);
        this.severityGroup.updateEnablement(enabled);
    }

    protected void resetPressed() {
        this.descriptionGroup.setContains(true);
        this.descriptionGroup.setDescription("");
        this.severityGroup.setEnabled(false);
        this.severityGroup.setErrorSelected(false);
        this.severityGroup.setWarningSelected(false);
        this.severityGroup.setInfoSelected(false);
        super.resetPressed();
    }

    protected MarkerFilter newFilter(String newName) {
        return new ProblemFilter(newName);
    }

    void createFiltersArea(Composite dialogArea) {
        if (MarkerSupportRegistry.getInstance().getRegisteredFilters().size() == 0) {
            super.createFiltersArea(dialogArea);
            return;
        }
        Composite mainComposite = new Composite(dialogArea, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, false, true));
        mainComposite.setLayout((Layout)new FormLayout());
        Composite topComposite = new Composite(mainComposite, 0);
        FormData topData = new FormData();
        topData.top = new FormAttachment(0);
        topData.left = new FormAttachment(0);
        topData.right = new FormAttachment(100);
        topData.bottom = new FormAttachment(50);
        topComposite.setLayoutData((Object)topData);
        topComposite.setLayout((Layout)new GridLayout());
        this.createUserFiltersArea(topComposite);
        Composite bottomComposite = new Composite(mainComposite, 0);
        FormData bottomData = new FormData();
        bottomData.top = new FormAttachment(50);
        bottomData.left = new FormAttachment(0);
        bottomData.right = new FormAttachment(100);
        bottomData.bottom = new FormAttachment(100);
        bottomComposite.setLayoutData((Object)bottomData);
        bottomComposite.setLayout((Layout)new GridLayout());
        this.createRegisteredFilters(bottomComposite);
        this.createFilterSelectButtons(bottomComposite);
    }

    private void createRegisteredFilters(Composite bottomComposite) {
        Composite listArea = new Composite(bottomComposite, 0);
        listArea.setLayoutData((Object)new GridData(4, 4, true, true));
        listArea.setLayout((Layout)new GridLayout());
        Label title = new Label(listArea, 0);
        title.setText(MarkerMessages.ProblemFilterDialog_System_Filters_Title);
        this.definedList = CheckboxTableViewer.newCheckList((Composite)listArea, (int)2048);
        this.definedList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return MarkerSupportRegistry.getInstance().getRegisteredFilters().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.definedList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MarkerFilter)element).getName();
            }
        });
        this.definedList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object selected = ((IStructuredSelection)selection).getFirstElement();
                    if (selected == null) {
                        DialogProblemFilter.this.systemSettingsLabel.setText(Util.EMPTY_STRING);
                    } else {
                        DialogProblemFilter.this.systemSettingsLabel.setText(DialogProblemFilter.this.getSystemFilterString((ProblemFilter)selected));
                    }
                } else {
                    DialogProblemFilter.this.systemSettingsLabel.setText(Util.EMPTY_STRING);
                }
                DialogProblemFilter.this.showSystemLabel(true);
            }
        });
        Iterator definedFilters = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
        this.definedList.setInput((Object)this);
        while (definedFilters.hasNext()) {
            MarkerFilter next = (MarkerFilter)definedFilters.next();
            this.definedList.setChecked((Object)next, next.isEnabled());
        }
        this.definedList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected String getSystemFilterString(ProblemFilter filter) {
        String severityString;
        String descriptionString;
        StringBuffer filterBuffer = new StringBuffer();
        String scopeString = this.getScopeString(filter);
        if (scopeString != null) {
            filterBuffer.append(scopeString);
        }
        if ((descriptionString = this.getDescriptionString(filter)) != null) {
            filterBuffer.append(Util.TWO_LINE_FEED);
            filterBuffer.append(descriptionString);
        }
        if ((severityString = this.getSeverityString(filter)) != null) {
            filterBuffer.append(Util.TWO_LINE_FEED);
            filterBuffer.append(severityString);
        }
        String typesString = this.getProblemTypesString(filter);
        filterBuffer.append(Util.TWO_LINE_FEED);
        filterBuffer.append(typesString);
        return filterBuffer.toString();
    }

    private String getProblemTypesString(ProblemFilter filter) {
        List types = filter.getSelectedTypes();
        if (types.size() == this.getRootEntries(filter).length) {
            return MarkerMessages.ProblemFilterDialog_All_Problems;
        }
        StringBuffer typesBuffer = new StringBuffer();
        Iterator typesIterator = types.iterator();
        typesBuffer.append(MarkerMessages.ProblemFilterDialog_Selected_Types);
        while (typesIterator.hasNext()) {
            typesBuffer.append(Util.LINE_FEED_AND_TAB);
            typesBuffer.append(((MarkerType)typesIterator.next()).getLabel());
        }
        return typesBuffer.toString();
    }

    private String getSeverityString(ProblemFilter filter) {
        if (filter.getSelectBySeverity()) {
            switch (filter.getSeverity()) {
                case 1: {
                    return MarkerMessages.ProblemFilterDialog_Info_Severity;
                }
                case 2: {
                    return MarkerMessages.ProblemFilterDialog_Warning_Severity;
                }
                case 4: {
                    return MarkerMessages.ProblemFilterDialog_Error_Severity;
                }
            }
            return null;
        }
        return null;
    }

    private String getDescriptionString(ProblemFilter filter) {
        if (filter.getDescription().length() == 0) {
            return null;
        }
        if (filter.getContains()) {
            return NLS.bind((String)MarkerMessages.ProblemFilterDialog_Contains_Description, (Object)filter.getDescription());
        }
        return NLS.bind((String)MarkerMessages.ProblemFilterDialog_Does_Not_Contain_Description, (Object)filter.getDescription());
    }

    private String getScopeString(ProblemFilter filter) {
        switch (filter.onResource) {
            case 0: {
                return MarkerMessages.ProblemFilterDialog_any;
            }
            case 3: {
                return MarkerMessages.ProblemFilterDialog_sameContainer;
            }
            case 2: {
                return MarkerMessages.ProblemFilterDialog_selectedAndChildren;
            }
            case 1: {
                return MarkerMessages.ProblemFilterDialog_selected;
            }
            case 4: {
                return NLS.bind((String)MarkerMessages.ProblemFilterDialog_workingSet, (Object)filter.getWorkingSet());
            }
        }
        return null;
    }

    protected void setSelectedFilter(SelectionChangedEvent event) {
        this.showSystemLabel(false);
        super.setSelectedFilter(event);
    }

    protected void showSystemLabel(boolean systemLabelShowing) {
        this.systemSettingsLabel.setVisible(systemLabelShowing);
        this.userFilterComposite.setVisible(!systemLabelShowing);
        this.userFilterComposite.getParent().layout();
    }

    Composite createSelectedFilterArea(Composite composite) {
        Composite wrapper = new Composite(composite, 0);
        FormLayout wrapperLayout = new FormLayout();
        wrapperLayout.marginHeight = 0;
        wrapperLayout.marginWidth = 0;
        wrapper.setLayout((Layout)wrapperLayout);
        this.systemSettingsLabel = this.createSystemSettingsLabel(wrapper);
        this.systemSettingsLabel.setVisible(false);
        FormData systemData = new FormData();
        systemData.top = new FormAttachment(0, 7);
        systemData.left = new FormAttachment(0, 7);
        systemData.right = new FormAttachment(100, -7);
        systemData.bottom = new FormAttachment(100, -7);
        this.systemSettingsLabel.setLayoutData((Object)systemData);
        this.userFilterComposite = super.createSelectedFilterArea(wrapper);
        FormData userData = new FormData();
        userData.top = new FormAttachment(0);
        userData.left = new FormAttachment(0);
        userData.right = new FormAttachment(100);
        userData.bottom = new FormAttachment(100);
        this.userFilterComposite.setLayoutData((Object)userData);
        return wrapper;
    }

    private Label createSystemSettingsLabel(Composite wrapper) {
        return new Label(wrapper, 0);
    }

    protected void buttonPressed(int buttonId) {
        if (this.definedList != null) {
            if (buttonId == 1028) {
                this.definedList.setAllChecked(true);
            } else if (buttonId == 1029) {
                this.definedList.setAllChecked(false);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        Iterator registered = MarkerSupportRegistry.getInstance().getRegisteredFilters().iterator();
        while (registered.hasNext()) {
            ProblemFilter next = (ProblemFilter)registered.next();
            next.setEnabled(this.definedList.getChecked((Object)next));
        }
        super.okPressed();
    }

    private class DescriptionGroup {
        private Label descriptionLabel;
        private Combo combo;
        private Text description;
        private String contains = MarkerMessages.filtersDialog_contains;
        private String doesNotContain = MarkerMessages.filtersDialog_doesNotContain;

        public DescriptionGroup(Composite parent) {
            Composite descriptionComposite = new Composite(parent, 0);
            descriptionComposite.setLayout((Layout)new GridLayout(2, false));
            descriptionComposite.setLayoutData((Object)new GridData(768));
            this.descriptionLabel = new Label(descriptionComposite, 0);
            this.descriptionLabel.setFont(parent.getFont());
            this.descriptionLabel.setText(MarkerMessages.filtersDialog_descriptionLabel);
            this.combo = new Combo(descriptionComposite, 8);
            this.combo.setFont(parent.getFont());
            this.combo.add(this.contains);
            this.combo.add(this.doesNotContain);
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    DescriptionGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.combo.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2 || e.detail == 4) {
                        e.doit = false;
                    }
                }
            });
            this.description = new Text(descriptionComposite, 2052);
            this.description.setFont(parent.getFont());
            GridData data = new GridData(768);
            data.horizontalSpan = 2;
            this.description.setLayoutData((Object)data);
            this.description.addModifyListener(new ModifyListener(this){
                final /* synthetic */ DescriptionGroup this$1;
                {
                    this.this$1 = descriptionGroup;
                }

                public void modifyText(ModifyEvent e) {
                    DescriptionGroup.access$0(this.this$1).markDirty();
                }
            });
        }

        public boolean getContains() {
            return this.combo.getSelectionIndex() == this.combo.indexOf(this.contains);
        }

        public void setContains(boolean value) {
            if (value) {
                this.combo.select(this.combo.indexOf(this.contains));
            } else {
                this.combo.select(this.combo.indexOf(this.doesNotContain));
            }
        }

        public void setDescription(String text) {
            if (text == null) {
                this.description.setText("");
            } else {
                this.description.setText(text);
            }
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void updateEnablement(boolean enabled) {
            this.descriptionLabel.setEnabled(enabled);
            this.combo.setEnabled(enabled);
            this.description.setEnabled(enabled);
        }

        static /* synthetic */ DialogProblemFilter access$0(DescriptionGroup descriptionGroup) {
            return descriptionGroup.DialogProblemFilter.this;
        }
    }

    private class SeverityGroup {
        private Button enablementButton;
        private Button errorButton;
        private Button warningButton;
        private Button infoButton;

        public SeverityGroup(Composite parent) {
            Composite severityComposite = new Composite(parent, 0);
            severityComposite.setLayout((Layout)new GridLayout(4, false));
            severityComposite.setLayoutData((Object)new GridData(768));
            SelectionAdapter listener = new SelectionAdapter(this){
                final /* synthetic */ SeverityGroup this$1;
                {
                    this.this$1 = severityGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.updateEnablement(true);
                    SeverityGroup.access$0(this.this$1).markDirty();
                }
            };
            this.enablementButton = new Button(severityComposite, 32);
            GridData data = new GridData(768);
            this.enablementButton.setLayoutData((Object)data);
            this.enablementButton.setFont(parent.getFont());
            this.enablementButton.setText(MarkerMessages.filtersDialog_severityLabel);
            this.enablementButton.addSelectionListener((SelectionListener)listener);
            this.errorButton = new Button(severityComposite, 32);
            this.errorButton.setFont(parent.getFont());
            this.errorButton.setText(MarkerMessages.filtersDialog_severityError);
            this.errorButton.setLayoutData((Object)new GridData(768));
            this.errorButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SeverityGroup this$1;
                {
                    this.this$1 = severityGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    SeverityGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.warningButton = new Button(severityComposite, 32);
            this.warningButton.setFont(parent.getFont());
            this.warningButton.setText(MarkerMessages.filtersDialog_severityWarning);
            this.warningButton.setLayoutData((Object)new GridData(768));
            this.warningButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SeverityGroup this$1;
                {
                    this.this$1 = severityGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    SeverityGroup.access$0(this.this$1).updateForSelection();
                }
            });
            this.infoButton = new Button(severityComposite, 32);
            this.infoButton.setFont(parent.getFont());
            this.infoButton.setText(MarkerMessages.filtersDialog_severityInfo);
            this.infoButton.setLayoutData((Object)new GridData(768));
            this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SeverityGroup this$1;
                {
                    this.this$1 = severityGroup;
                }

                public void widgetSelected(SelectionEvent e) {
                    SeverityGroup.access$0(this.this$1).updateForSelection();
                }
            });
        }

        public boolean isSeveritySelected() {
            return this.enablementButton.getSelection();
        }

        public void setEnabled(boolean enabled) {
            this.enablementButton.setSelection(enabled);
        }

        public boolean isErrorSelected() {
            return this.errorButton.getSelection();
        }

        public void setErrorSelected(boolean selected) {
            this.errorButton.setSelection(selected);
        }

        public boolean isWarningSelected() {
            return this.warningButton.getSelection();
        }

        public void setWarningSelected(boolean selected) {
            this.warningButton.setSelection(selected);
        }

        public boolean isInfoSelected() {
            return this.infoButton.getSelection();
        }

        public void setInfoSelected(boolean selected) {
            this.infoButton.setSelection(selected);
        }

        public void updateEnablement(boolean enabled) {
            boolean showingSeverity = this.isSeveritySelected();
            this.enablementButton.setEnabled(enabled);
            this.errorButton.setEnabled(showingSeverity && enabled);
            this.warningButton.setEnabled(showingSeverity && enabled);
            this.infoButton.setEnabled(showingSeverity && enabled);
        }

        static /* synthetic */ DialogProblemFilter access$0(SeverityGroup severityGroup) {
            return severityGroup.DialogProblemFilter.this;
        }
    }
}

