/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphgenerators.impl;

import java.awt.Polygon;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.LocationUtility;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.edges.EdgesFactory;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabel;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabelValue;
import org.eclipse.stem.definitions.edges.impl.EdgesFactoryImpl;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.geography.centers.GeographicCenters;
import org.eclipse.stem.graphgenerators.GraphgeneratorsPackage;
import org.eclipse.stem.graphgenerators.SeasonalMigrationEdgeGraphGenerator;
import org.eclipse.stem.graphgenerators.impl.GraphGeneratorImpl;

public class SeasonalMigrationEdgeGraphGeneratorImpl
extends GraphGeneratorImpl
implements SeasonalMigrationEdgeGraphGenerator {
    protected static final URI LOCATION_A_EDEFAULT = null;
    protected URI locationA = LOCATION_A_EDEFAULT;
    protected static final URI LOCATION_B_EDEFAULT = null;
    protected URI locationB = LOCATION_B_EDEFAULT;
    protected static final double MIGRATION_RATE_EDEFAULT = 0.1;
    protected double migrationRate = 0.1;
    protected static final String POPULATION_EDEFAULT = "human";
    protected String population = "human";
    protected static final double TOLERANCE_ANGLE_A_EDEFAULT = 15.0;
    protected double toleranceAngleA = 15.0;
    protected static final double TOLERANCE_ANGLE_B_EDEFAULT = 15.0;
    protected double toleranceAngleB = 15.0;
    private static final double DEG_TO_RADS = Math.PI / 180;
    private static final double SQRT_TWO = Math.sqrt(2.0);
    private IProject project;

    @Override
    public Graph getGraph() {
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        DublinCore dc = graph.getDublinCore();
        dc.populate();
        dc.setTitle("Migration Edges");
        dc.setSource(this.getClass().getSimpleName());
        Calendar c = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        String valid = formatter.format(c.getTime());
        dc.setValid(valid);
        URI uriA = this.getLocationA();
        URI uriB = this.getLocationB();
        String nodeURIA = uriA.lastSegment();
        String nodeURIB = uriB.lastSegment();
        Node nodeA = LocationUtility.getNode((IProject)this.project, (URI)uriA);
        Node nodeB = LocationUtility.getNode((IProject)this.project, (URI)uriB);
        if (nodeA instanceof RegionImpl && nodeB instanceof RegionImpl) {
            double[] lat_lngA = GeographicCenters.getCenter((String)nodeURIA);
            double[] lat_lngB = GeographicCenters.getCenter((String)nodeURIB);
            if (lat_lngA == null) {
                LatLongProviderAdapter latLongProviderA = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeA, LatLongProvider.class);
                lat_lngA = latLongProviderA.getCenter();
            }
            if (lat_lngB == null) {
                LatLongProviderAdapter latLongProviderB = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeB, LatLongProvider.class);
                lat_lngB = latLongProviderB.getCenter();
            }
            double directionalityAtoB = 1.0;
            double xA = lat_lngA[0];
            double yA = lat_lngA[1];
            double xB = lat_lngB[0];
            double yB = lat_lngB[1];
            if (lat_lngA[0] > lat_lngB[0]) {
                directionalityAtoB = -1.0;
                xB = lat_lngA[0];
                yB = lat_lngA[1];
                xA = lat_lngB[0];
                yA = lat_lngB[1];
            }
            double slope = (yB - yA) / (xB - xA);
            double intercept = yB - slope * xB;
            double L = Math.sqrt((xB - xA) * (xB - xA) + (yB - yA) * (yB - yA));
            double elevAngle = Math.asin((yB - yA) / L);
            double denom = 1.0 + Math.tan(Math.PI / 180 * this.toleranceAngleA) / Math.tan(Math.PI / 180 * this.toleranceAngleB);
            double L1 = L / denom;
            double h = L1 * Math.tan(Math.PI / 180 * this.toleranceAngleA);
            double alpha = -1.0 * elevAngle;
            double dx = L1 * Math.cos(alpha) + h * Math.sin(alpha);
            double dy = -1.0 * L1 * Math.sin(alpha) + h * Math.cos(alpha);
            double xUP = xA + dx;
            double yUP = yA + dy;
            double dx2 = L1 * Math.cos(alpha) - h * Math.sin(alpha);
            double dy2 = -1.0 * L1 * Math.sin(alpha) - h * Math.cos(alpha);
            double xDOWN = xA + dx2;
            double yDOWN = yA + dy2;
            double[] x = new double[4];
            double[] y = new double[4];
            x[0] = xA;
            x[1] = xUP;
            x[2] = xB;
            x[3] = xDOWN;
            y[0] = yA;
            y[1] = yUP;
            y[2] = yB;
            y[3] = yDOWN;
            Dpolygon dPoly = new Dpolygon(x, y);
            Set allCommonBorderEdges = LocationUtility.getCommonBorderEdges((IProject)this.project, null);
            Activator.logInformation((String)("This Generator Under Development: checking " + allCommonBorderEdges.size() + "all edges"));
            Set<Edge> containedCommonBorderEdges = this.filterEdges(allCommonBorderEdges, dPoly);
            Activator.logInformation((String)("This Generator Under Development: filtered " + containedCommonBorderEdges.size() + "contained edges"));
            Iterator<Edge> iter = containedCommonBorderEdges.iterator();
            while (iter != null && iter.hasNext()) {
                Edge e = iter.next();
                URI sourceURI = e.getNodeAURI();
                URI targetURI = e.getNodeBURI();
                EdgesFactory ef = EdgesFactoryImpl.init();
                MigrationEdge mEdge1 = ef.createMigrationEdge();
                URI edgeURI1 = mEdge1.getURI();
                String s1 = edgeURI1.toString();
                int last = s1.lastIndexOf("/");
                String sEdge1 = s1.substring(0, last);
                String sEdge2 = s1.substring(last, s1.length());
                s1 = String.valueOf(sEdge1) + "/relationship/migration" + sEdge2;
                URI newURI = URI.createURI((String)s1);
                mEdge1.setURI(newURI);
                MigrationEdgeLabel label1 = mEdge1.getLabel();
                DublinCore dc1 = mEdge1.getDublinCore();
                MigrationEdgeLabelValue melv1 = label1.getCurrentValue();
                melv1.setMigrationRate(directionalityAtoB * this.getMigrationRate());
                mEdge1.setUseAbsoluteValues(false);
                mEdge1.setPopulationIdentifier(this.getPopulation());
                Node sourceNode = e.getA();
                Node targetNode = e.getB();
                double rA_source = this.getRange2(sourceNode, xA, yA);
                double rA_target = this.getRange2(targetNode, xA, yA);
                double[] lat_lngSRC = GeographicCenters.getCenter((String)sourceURI.lastSegment());
                double[] lat_lngTRGT = GeographicCenters.getCenter((String)targetURI.lastSegment());
                if (lat_lngSRC == null) {
                    LatLongProviderAdapter latLongProviderA = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)sourceNode, LatLongProvider.class);
                    lat_lngSRC = latLongProviderA.getCenter();
                }
                if (lat_lngTRGT == null) {
                    LatLongProviderAdapter latLongProviderB = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)targetNode, LatLongProvider.class);
                    lat_lngTRGT = latLongProviderB.getCenter();
                }
                double srcDist = this.getDistanceToLine(lat_lngSRC, slope, intercept);
                double trgtDist = this.getDistanceToLine(lat_lngTRGT, slope, intercept);
                if (rA_source == rA_target) continue;
                if (rA_source < rA_target) {
                    mEdge1.setNodeAURI(sourceURI);
                    mEdge1.setNodeBURI(targetURI);
                    label1.setURI(SeasonalMigrationEdgeGraphGeneratorImpl.createEdgeLabelURI(sourceURI, targetURI));
                    dc1.setTitle(SeasonalMigrationEdgeGraphGeneratorImpl.createEdgeTitle(sourceURI, targetURI));
                    if (trgtDist > srcDist) {
                        melv1.setMigrationRate(directionalityAtoB * this.getMigrationRate() / SQRT_TWO);
                    }
                } else {
                    mEdge1.setNodeAURI(targetURI);
                    mEdge1.setNodeBURI(sourceURI);
                    label1.setURI(SeasonalMigrationEdgeGraphGeneratorImpl.createEdgeLabelURI(targetURI, sourceURI));
                    dc1.setTitle(SeasonalMigrationEdgeGraphGeneratorImpl.createEdgeTitle(targetURI, sourceURI));
                    if (trgtDist < srcDist) {
                        melv1.setMigrationRate(directionalityAtoB * this.getMigrationRate() / SQRT_TWO);
                    }
                }
                graph.putEdge((Edge)mEdge1);
            }
        } else {
            Activator.logInformation((String)"Error: seasonal migration only works for region nodes defined in project");
        }
        assert (graph.sane());
        return graph;
    }

    public double getRange2(Node n, double x, double y) {
        LatLongProvider latLongProviderA = (LatLongProvider)LatLongProviderAdapterFactory.INSTANCE.adaptNew((Notifier)n, LatLongProvider.class);
        double[] nodeCoords = latLongProviderA.getCenter();
        double r2 = (x - nodeCoords[0]) * (x - nodeCoords[0]) + (y - nodeCoords[1]) * (y - nodeCoords[1]);
        return r2;
    }

    public double getDistanceToLine(double[] latlng, double m, double b) {
        double numer = Math.abs(latlng[1] - m * latlng[0] - b);
        double denom = Math.sqrt(m * m + 1.0);
        return numer / denom;
    }

    public Set<Edge> filterEdges(Set<Edge> allEdges, Dpolygon p) {
        HashSet<Edge> goodEdges = new HashSet<Edge>();
        for (Edge e : allEdges) {
            Node a = e.getA();
            Node b = e.getB();
            if (a instanceof Region && b instanceof Region) {
                LatLongProvider latLongProviderA = (LatLongProvider)LatLongProviderAdapterFactory.INSTANCE.adaptNew((Notifier)a, LatLongProvider.class);
                double[] aCoords = latLongProviderA.getCenter();
                LatLongProvider latLongProviderB = (LatLongProvider)LatLongProviderAdapterFactory.INSTANCE.adaptNew((Notifier)b, LatLongProvider.class);
                double[] bCoords = latLongProviderB.getCenter();
                if (!p.contains(aCoords[0], aCoords[1]) || !p.contains(bCoords[0], bCoords[1])) continue;
                goodEdges.add(e);
                continue;
            }
            Activator.logInformation((String)"Warning: Graph does not contain Region Nodes");
            break;
        }
        return goodEdges;
    }

    private static URI createEdgeLabelURI(URI uriA, URI uriB) {
        String sA = uriA.lastSegment();
        String sB = uriB.lastSegment();
        sA = sA.replace('_', '.');
        sB = sB.replace('_', '.');
        String uriString = String.valueOf(sA) + "_" + sB;
        URI uri = STEMURI.createURI((String)uriString);
        return uri;
    }

    public static String createEdgeTitle(URI uriA, URI uriB) {
        String sA = uriA.lastSegment();
        String sB = uriB.lastSegment();
        StringBuilder sb = new StringBuilder("MigrationEdge[(");
        sb.append(sA);
        sb.append(")<-->(");
        sb.append(sB);
        sb.append(")]");
        return sb.toString();
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject p) {
        this.project = p;
    }

    @Override
    protected EClass eStaticClass() {
        return GraphgeneratorsPackage.Literals.SEASONAL_MIGRATION_EDGE_GRAPH_GENERATOR;
    }

    @Override
    public URI getLocationA() {
        return this.locationA;
    }

    @Override
    public void setLocationA(URI newLocationA) {
        URI oldLocationA = this.locationA;
        this.locationA = newLocationA;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldLocationA, (Object)this.locationA));
        }
    }

    @Override
    public URI getLocationB() {
        return this.locationB;
    }

    @Override
    public void setLocationB(URI newLocationB) {
        URI oldLocationB = this.locationB;
        this.locationB = newLocationB;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldLocationB, (Object)this.locationB));
        }
    }

    @Override
    public double getMigrationRate() {
        return this.migrationRate;
    }

    @Override
    public void setMigrationRate(double newMigrationRate) {
        double oldMigrationRate = this.migrationRate;
        this.migrationRate = newMigrationRate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldMigrationRate, this.migrationRate));
        }
    }

    @Override
    public String getPopulation() {
        return this.population;
    }

    @Override
    public void setPopulation(String newPopulation) {
        String oldPopulation = this.population;
        this.population = newPopulation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldPopulation, (Object)this.population));
        }
    }

    @Override
    public double getToleranceAngleA() {
        return this.toleranceAngleA;
    }

    @Override
    public void setToleranceAngleA(double newToleranceAngleA) {
        double oldToleranceAngleA = this.toleranceAngleA;
        this.toleranceAngleA = newToleranceAngleA;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldToleranceAngleA, this.toleranceAngleA));
        }
    }

    @Override
    public double getToleranceAngleB() {
        return this.toleranceAngleB;
    }

    @Override
    public void setToleranceAngleB(double newToleranceAngleB) {
        double oldToleranceAngleB = this.toleranceAngleB;
        this.toleranceAngleB = newToleranceAngleB;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldToleranceAngleB, this.toleranceAngleB));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                return this.getLocationA();
            }
            case 4: {
                return this.getLocationB();
            }
            case 5: {
                return this.getMigrationRate();
            }
            case 6: {
                return this.getPopulation();
            }
            case 7: {
                return this.getToleranceAngleA();
            }
            case 8: {
                return this.getToleranceAngleB();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                this.setLocationA((URI)newValue);
                return;
            }
            case 4: {
                this.setLocationB((URI)newValue);
                return;
            }
            case 5: {
                this.setMigrationRate((Double)newValue);
                return;
            }
            case 6: {
                this.setPopulation((String)newValue);
                return;
            }
            case 7: {
                this.setToleranceAngleA((Double)newValue);
                return;
            }
            case 8: {
                this.setToleranceAngleB((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.setLocationA(LOCATION_A_EDEFAULT);
                return;
            }
            case 4: {
                this.setLocationB(LOCATION_B_EDEFAULT);
                return;
            }
            case 5: {
                this.setMigrationRate(0.1);
                return;
            }
            case 6: {
                this.setPopulation(POPULATION_EDEFAULT);
                return;
            }
            case 7: {
                this.setToleranceAngleA(15.0);
                return;
            }
            case 8: {
                this.setToleranceAngleB(15.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return LOCATION_A_EDEFAULT == null ? this.locationA != null : !LOCATION_A_EDEFAULT.equals((Object)this.locationA);
            }
            case 4: {
                return LOCATION_B_EDEFAULT == null ? this.locationB != null : !LOCATION_B_EDEFAULT.equals((Object)this.locationB);
            }
            case 5: {
                return this.migrationRate != 0.1;
            }
            case 6: {
                return POPULATION_EDEFAULT == null ? this.population != null : !POPULATION_EDEFAULT.equals(this.population);
            }
            case 7: {
                return this.toleranceAngleA != 15.0;
            }
            case 8: {
                return this.toleranceAngleB != 15.0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (locationA: ");
        result.append(this.locationA);
        result.append(", locationB: ");
        result.append(this.locationB);
        result.append(", migrationRate: ");
        result.append(this.migrationRate);
        result.append(", population: ");
        result.append(this.population);
        result.append(", toleranceAngleA: ");
        result.append(this.toleranceAngleA);
        result.append(", toleranceAngleB: ");
        result.append(this.toleranceAngleB);
        result.append(')');
        return result.toString();
    }

    public class Dpolygon {
        Polygon p;
        static final double RESCALE = 1000000.0;

        public Dpolygon(double[] x, double[] y) {
            int npoints = x.length;
            int[] ix = new int[npoints];
            int[] iy = new int[npoints];
            int i = 0;
            while (i < npoints) {
                ix[i] = (int)Math.round(1000000.0 * x[i]);
                iy[i] = (int)Math.round(1000000.0 * y[i]);
                ++i;
            }
            this.p = new Polygon(ix, iy, npoints);
        }

        public boolean contains(double x, double y) {
            int ix = (int)Math.round(1000000.0 * x);
            int iy = (int)Math.round(1000000.0 * y);
            return this.p.contains(ix, iy);
        }
    }
}

