/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.trace.internal.Messages;
import org.eclipse.ui.trace.internal.TracingComponentColumnEditingSupport;
import org.eclipse.ui.trace.internal.TracingComponentComparator;
import org.eclipse.ui.trace.internal.TracingComponentTreeViewer;
import org.eclipse.ui.trace.internal.TracingDoubleClickListener;
import org.eclipse.ui.trace.internal.datamodel.TracingCollections;
import org.eclipse.ui.trace.internal.datamodel.TracingComponent;
import org.eclipse.ui.trace.internal.datamodel.TracingComponentDebugOption;
import org.eclipse.ui.trace.internal.datamodel.TracingNode;
import org.eclipse.ui.trace.internal.providers.TracingComponentColumnLabelProvider;
import org.eclipse.ui.trace.internal.providers.TracingComponentContentProvider;
import org.eclipse.ui.trace.internal.providers.TracingComponentLabelProvider;
import org.eclipse.ui.trace.internal.utils.DebugOptionsHandler;
import org.eclipse.ui.trace.internal.utils.PreferenceHandler;
import org.eclipse.ui.trace.internal.utils.TracingUtils;

public class TracingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Map<String, TracingComponent> displayableTracingComponents = null;
    protected Button enableTracingButton = null;
    protected Label tracingTreeTitleLabel = null;
    protected FilteredTree filterTree = null;
    protected Group tracingOptionsGroup = null;
    protected Text tracingFileText = null;
    protected Spinner maximumFileSizeSpinner = null;
    protected Spinner maximumFileCountSpinner = null;
    protected Button tracingFileBrowseButton = null;
    protected Label tracingFileLabel = null;
    protected Label tracingFileMaxCountLabel = null;
    protected Label tracingFileMaxSizeLabel = null;

    public TracingPreferencePage() {
        this.setDescription(Messages.preferencePageDescription);
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
        this.disposeWidget((Widget)this.enableTracingButton);
        this.disposeWidget((Widget)this.tracingTreeTitleLabel);
        this.disposeWidget((Widget)this.filterTree);
        this.disposeWidget((Widget)this.tracingOptionsGroup);
        this.disposeWidget((Widget)this.tracingFileLabel);
        this.disposeWidget((Widget)this.tracingFileText);
        this.disposeWidget((Widget)this.tracingFileBrowseButton);
        this.disposeWidget((Widget)this.tracingFileMaxCountLabel);
        this.disposeWidget((Widget)this.maximumFileCountSpinner);
        this.disposeWidget((Widget)this.tracingFileMaxSizeLabel);
        this.disposeWidget((Widget)this.maximumFileSizeSpinner);
        this.purgeModel();
    }

    private void purgeModel() {
        if (this.displayableTracingComponents != null) {
            this.displayableTracingComponents.clear();
            this.displayableTracingComponents = null;
        }
        TracingCollections.getInstance().clear();
    }

    private void disposeWidget(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    protected Control createContents(Composite parent) {
        Composite pageComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(pageComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)pageComposite);
        this.addEnableTracingSection(pageComposite);
        this.addBundleViewerSection(pageComposite);
        this.addTracingOptionsSection(pageComposite);
        this.setUIValuesFromPreferences();
        this.enableTracingButtonSelected(true);
        this.applyDialogFont(pageComposite);
        this.enableTracingButton.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageComposite, "org.eclipse.ui.tracing_preference_page");
        return pageComposite;
    }

    protected void addEnableTracingSection(Composite parent) {
        if (DebugOptionsHandler.isLaunchInDebugMode()) {
            Composite warningComp = new Composite(parent, 0);
            GridData gd = new GridData(4, 1, true, false);
            warningComp.setLayoutData((Object)gd);
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            warningComp.setLayout((Layout)gl);
            Label warningImage = new Label(warningComp, 0);
            warningImage.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
            gd = new GridData(1, 1, false, false);
            warningImage.setLayoutData((Object)gd);
            Label warningText = new Label(warningComp, 64);
            warningText.setText(Messages.TracingPreferencePage_applicationLaunchedInDebugModeWarning);
            gd = new GridData(4, 1, true, false);
            gd.widthHint = 200;
            warningText.setLayoutData((Object)gd);
        }
        this.enableTracingButton = new Button(parent, 32);
        this.enableTracingButton.setText(Messages.enableTracingButtonLabel);
        GridDataFactory.fillDefaults().align(1, 1).grab(true, false).applyTo((Control)this.enableTracingButton);
        this.enableTracingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TracingPreferencePage.this.enableTracingButtonSelected(true);
            }
        });
    }

    protected void addBundleViewerSection(Composite parent) {
        this.tracingTreeTitleLabel = new Label(parent, 0);
        this.tracingTreeTitleLabel.setText(Messages.tracingTreeTile);
        this.filterTree = new TracingComponentTreeViewer(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.getViewerTree());
        this.getViewer().setUseHashlookup(true);
        this.getViewerTree().setHeaderVisible(false);
        this.getViewer().setLabelProvider((IBaseLabelProvider)new TracingComponentLabelProvider());
        this.getViewer().setContentProvider((IContentProvider)new TracingComponentContentProvider());
        this.getViewer().setComparator((ViewerComparator)new TracingComponentComparator());
        this.getViewerTree().setLinesVisible(true);
        this.getViewer().addDoubleClickListener((IDoubleClickListener)new TracingDoubleClickListener());
        Composite treeViewerComposite = this.getViewerTree().getParent();
        TreeColumnLayout treeViewerCompositeLayout = new TreeColumnLayout();
        treeViewerComposite.setLayout((Layout)treeViewerCompositeLayout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeViewerComposite);
        TreeViewerColumn labelColumn = new TreeViewerColumn(this.getViewer(), 0);
        labelColumn.getColumn().setResizable(true);
        labelColumn.getColumn().setText(Messages.columnHeaderTracingString);
        labelColumn.setLabelProvider((CellLabelProvider)new TracingComponentColumnLabelProvider(0));
        treeViewerCompositeLayout.setColumnData((Widget)this.getViewerTree().getColumn(0), (ColumnLayoutData)new ColumnWeightData(75));
        TreeViewerColumn valueColumn = new TreeViewerColumn(this.getViewer(), 0);
        valueColumn.getColumn().setResizable(true);
        valueColumn.getColumn().setText(Messages.columnHeaderTracingValue);
        valueColumn.setLabelProvider((CellLabelProvider)new TracingComponentColumnLabelProvider(1));
        valueColumn.setEditingSupport((EditingSupport)new TracingComponentColumnEditingSupport((ColumnViewer)this.getViewer(), 1));
        treeViewerCompositeLayout.setColumnData((Widget)this.getViewerTree().getColumn(1), (ColumnLayoutData)new ColumnWeightData(25));
    }

    protected void addTracingOptionsSection(Composite parent) {
        this.tracingOptionsGroup = new Group(parent, 0);
        this.tracingOptionsGroup.setText(Messages.tracingOptionsGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tracingOptionsGroup);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.tracingOptionsGroup);
        Composite outputComp = new Composite((Composite)this.tracingOptionsGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)outputComp);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).margins(0, 0).applyTo(outputComp);
        this.tracingFileLabel = new Label(outputComp, 0);
        this.tracingFileLabel.setText(Messages.tracingFileLabel);
        this.tracingFileText = new Text(outputComp, 2052);
        this.tracingFileText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String newInput = TracingPreferencePage.this.getInput(e);
                if (newInput == null || newInput.equals("")) {
                    TracingPreferencePage.this.setValid(false);
                    TracingPreferencePage.this.setErrorMessage(Messages.tracingFileInvalid);
                } else {
                    TracingPreferencePage.this.setValid(true);
                    TracingPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.tracingFileText);
        this.tracingFileBrowseButton = new Button(outputComp, 8);
        this.tracingFileBrowseButton.setText(Messages.tracingFileBrowseButton);
        this.tracingFileBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(TracingPreferencePage.this.tracingOptionsGroup.getShell(), 8192);
                dialog.setFileName(TracingPreferencePage.this.tracingFileText.getText());
                String result = dialog.open();
                if (result != null) {
                    TracingPreferencePage.this.tracingFileText.setText(result);
                }
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)this.tracingFileBrowseButton);
        Composite detailsComp = new Composite((Composite)this.tracingOptionsGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(5).equalWidth(false).margins(0, 0).applyTo(detailsComp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)detailsComp);
        this.tracingFileMaxCountLabel = new Label(detailsComp, 0);
        this.tracingFileMaxCountLabel.setText(Messages.tracingFileMaxCountLabel);
        this.maximumFileCountSpinner = new Spinner(detailsComp, 2052);
        this.maximumFileCountSpinner.setValues(10, 10, 100, 0, 5, 10);
        this.maximumFileCountSpinner.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                TracingPreferencePage.this.verifyIntInput(e, Messages.tracingFileInvalidMaxCount);
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)this.maximumFileCountSpinner);
        Label spacer = new Label(detailsComp, 0);
        GridDataFactory.fillDefaults().hint(10, 10).applyTo((Control)spacer);
        this.tracingFileMaxSizeLabel = new Label(detailsComp, 0);
        this.tracingFileMaxSizeLabel.setText(Messages.tracingFileMaxSizeLabel);
        this.maximumFileSizeSpinner = new Spinner(detailsComp, 2052);
        this.maximumFileSizeSpinner.setValues(100, 100, 10000, 0, 100, 1000);
        this.maximumFileSizeSpinner.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                TracingPreferencePage.this.verifyIntInput(e, Messages.tracingFileInvalidMaxSize);
            }
        });
        GridDataFactory.fillDefaults().applyTo((Control)this.maximumFileSizeSpinner);
    }

    protected void setUIValuesFromPreferences() {
        if (!DebugOptionsHandler.isLaunchInDebugMode()) {
            boolean tracingEnabled = PreferenceHandler.isTracingEnabled();
            if (tracingEnabled && !DebugOptionsHandler.getDebugOptions().isDebugEnabled()) {
                DebugOptionsHandler.getDebugOptions().setDebugEnabled(true);
            }
            this.enableTracingButton.setSelection(tracingEnabled);
        } else {
            this.enableTracingButton.setSelection(false);
        }
        this.tracingFileText.setText(PreferenceHandler.getFilePath());
        this.maximumFileCountSpinner.setSelection(PreferenceHandler.getMaxFileCount());
        this.maximumFileSizeSpinner.setSelection(PreferenceHandler.getMaxFileSize());
        this.enableTracingButtonSelected(false);
    }

    protected String getInput(Event ev) {
        String input = null;
        if (ev.keyCode == 127 || ev.keyCode == 8) {
            String currentValue = ((Text)ev.widget).getText();
            String begin = currentValue.substring(0, ev.start);
            String end = currentValue.substring(ev.start + 1, currentValue.length());
            input = String.valueOf(begin) + end;
        } else {
            input = ev.text;
        }
        return input;
    }

    protected void verifyIntInput(Event ev, String errorMessage) {
        String input = this.getInput(ev);
        if (input.length() <= 0) {
            this.setValid(false);
            this.setErrorMessage(errorMessage);
            return;
        }
        char[] chars = new char[input.length()];
        input.getChars(0, chars.length, chars, 0);
        int i = 0;
        while (i < chars.length) {
            if ('0' > chars[i] || chars[i] > '9') {
                this.setValid(false);
                this.setErrorMessage(errorMessage);
                return;
            }
            ++i;
        }
        this.setValid(true);
        this.setErrorMessage(null);
    }

    protected void enableTracingButtonSelected(boolean updateModel) {
        boolean enableTracing = this.enableTracingButton.getSelection();
        if (updateModel) {
            if (enableTracing) {
                this.buildDisplayableComponents();
                Collection<TracingComponent> components = this.displayableTracingComponents.values();
                TracingComponent[] componentsArray = components.toArray(new TracingComponent[components.size()]);
                this.getViewer().setInput((Object)componentsArray);
            } else {
                this.purgeModel();
                this.getViewer().setInput(null);
            }
        }
        this.tracingTreeTitleLabel.setEnabled(enableTracing);
        this.filterTree.setEnabled(enableTracing);
        this.tracingOptionsGroup.setEnabled(enableTracing);
        this.tracingFileText.setEnabled(enableTracing);
        this.maximumFileSizeSpinner.setEnabled(enableTracing);
        this.maximumFileCountSpinner.setEnabled(enableTracing);
        this.tracingFileBrowseButton.setEnabled(enableTracing);
        this.tracingFileLabel.setEnabled(enableTracing);
        this.tracingFileMaxCountLabel.setEnabled(enableTracing);
        this.tracingFileMaxSizeLabel.setEnabled(enableTracing);
    }

    private void buildDisplayableComponents() {
        if (this.displayableTracingComponents != null) {
            this.purgeModel();
        }
        this.displayableTracingComponents = new HashMap<String, TracingComponent>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.ui.trace", "traceComponents");
        TracingComponent[] components = new TracingComponent[cf.length];
        int i = 0;
        while (i < cf.length) {
            components[i] = TracingCollections.getInstance().getTracingComponent(cf[i]);
            if (!this.displayableTracingComponents.containsKey(components[i].getId()) && !components[i].isConsumed()) {
                this.displayableTracingComponents.put(components[i].getId(), components[i]);
            }
            ++i;
        }
        Iterator<TracingComponent> componentIterator = this.displayableTracingComponents.values().iterator();
        while (componentIterator.hasNext()) {
            componentIterator.next().initialize();
        }
        this.mergePrefsWithDebugOptions();
    }

    private void mergePrefsWithDebugOptions() {
        Map<String, String> prefDebugOptions = PreferenceHandler.getPreferenceProperties();
        Map debugOptions = DebugOptionsHandler.getDebugOptions().getOptions();
        for (Map.Entry<String, String> prefDebugOption : prefDebugOptions.entrySet()) {
            String debugOptionsValue = (String)debugOptions.get(prefDebugOption.getValue());
            boolean updateDebugOption = true;
            if (debugOptionsValue != null) {
                if (TracingUtils.isValueBoolean(debugOptionsValue) && TracingUtils.isValueBoolean(prefDebugOption.getValue())) {
                    boolean optionValue = Boolean.valueOf(debugOptionsValue);
                    boolean prefValue = Boolean.valueOf(prefDebugOption.getValue());
                    if (prefValue != optionValue) {
                        updateDebugOption = prefValue;
                    }
                } else if (!debugOptionsValue.equals(prefDebugOption.getValue())) {
                    updateDebugOption = true;
                }
            }
            if (!updateDebugOption) continue;
            TracingComponentDebugOption[] identicalOptions = TracingCollections.getInstance().getTracingDebugOptions(prefDebugOption.getKey());
            int identicalOptionsIndex = 0;
            while (identicalOptionsIndex < identicalOptions.length) {
                identicalOptions[identicalOptionsIndex].setOptionPathValue(prefDebugOption.getValue());
                ++identicalOptionsIndex;
            }
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        DebugOptionsHandler.getDebugOptions().setOptions(new HashMap());
        this.purgeModel();
        this.getViewer().setInput(null);
        PreferenceHandler.setDefaultPreferences();
        TracingCollections.getInstance().getModifiedDebugOptions().clear();
        this.setUIValuesFromPreferences();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        boolean enableTracing = this.enableTracingButton.getSelection();
        if (DebugOptionsHandler.isLaunchInDebugMode()) {
            if (enableTracing) {
                DebugOptionsHandler.setLaunchInDebugMode(false);
            } else {
                return result;
            }
        }
        this.savePreferences(enableTracing);
        DebugOptionsHandler.setDebugEnabled(enableTracing);
        if (enableTracing) {
            HashMap<String, String> newOptions = new HashMap<String, String>();
            Map currentOptions = DebugOptionsHandler.getDebugOptions().getOptions();
            newOptions.putAll(currentOptions);
            TracingComponentDebugOption[] optionsToAdd = TracingCollections.getInstance().getModifiedDebugOptions().getDebugOptionsToAdd();
            int i = 0;
            while (i < optionsToAdd.length) {
                newOptions.put(optionsToAdd[i].getOptionPath(), optionsToAdd[i].getOptionPathValue());
                ++i;
            }
            TracingComponentDebugOption[] optionsToRemove = TracingCollections.getInstance().getModifiedDebugOptions().getDebugOptionsToRemove();
            int i2 = 0;
            while (i2 < optionsToRemove.length) {
                newOptions.remove(optionsToRemove[i2].getOptionPath());
                ++i2;
            }
            DebugOptionsHandler.getDebugOptions().setOptions(newOptions);
            TracingCollections.getInstance().getModifiedDebugOptions().clear();
            String defaultFile = DebugOptionsHandler.getDebugOptions().getFile().getAbsolutePath();
            String newFile = this.tracingFileText.getText();
            if (!defaultFile.equals(newFile)) {
                DebugOptionsHandler.getDebugOptions().setFile(new File(newFile));
            }
            int newMaxSize = this.maximumFileSizeSpinner.getSelection();
            System.setProperty("eclipse.trace.size.max", String.valueOf(newMaxSize));
            int newMaxCount = this.maximumFileCountSpinner.getSelection();
            System.setProperty("eclipse.trace.backup.max", String.valueOf(newMaxCount));
        }
        return result;
    }

    protected void savePreferences(boolean tracingEnabled) {
        HashMap<String, String> prefValues = new HashMap<String, String>(5);
        prefValues.put("tracingEnabled", Boolean.toString(tracingEnabled));
        prefValues.put("tracingMaxFileCount", Integer.toString(this.maximumFileCountSpinner.getSelection()));
        prefValues.put("tracingMaxFileSize", Integer.toString(this.maximumFileSizeSpinner.getSelection()));
        prefValues.put("tracingFilePath", this.tracingFileText.getText());
        StringBuffer optionsAsString = new StringBuffer();
        if (this.displayableTracingComponents != null) {
            Iterator<Map.Entry<String, TracingComponent>> componentIterator = this.displayableTracingComponents.entrySet().iterator();
            while (componentIterator.hasNext()) {
                StringBuffer result;
                TracingComponent component = componentIterator.next().getValue();
                if (!component.hasChildren() || (result = this.getAllUniqueDebugOptions(component)) == null) continue;
                optionsAsString.append(result);
            }
        } else {
            optionsAsString.append("");
        }
        prefValues.put("tracingEntries", optionsAsString.toString());
        PreferenceHandler.savePreferences(prefValues);
    }

    private StringBuffer getAllUniqueDebugOptions(TracingNode node) {
        StringBuffer buffer = null;
        if (node.hasChildren()) {
            buffer = new StringBuffer();
            TracingNode[] children = node.getChildren();
            int i = 0;
            while (i < children.length) {
                String debugOptionAsString = TracingUtils.convertToString((TracingComponentDebugOption)children[i]);
                buffer.append(debugOptionAsString);
                StringBuffer result = this.getAllUniqueDebugOptions(children[i]);
                if (result != null) {
                    buffer.append(result);
                }
                ++i;
            }
        }
        return buffer;
    }

    private TreeViewer getViewer() {
        return this.filterTree.getViewer();
    }

    private Tree getViewerTree() {
        return this.filterTree.getViewer().getTree();
    }
}

