/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.AbstractEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class TreeContainerEditPolicy
extends AbstractEditPolicy {
    protected abstract Command getAddCommand(ChangeBoundsRequest var1);

    protected abstract Command getCreateCommand(CreateRequest var1);

    protected abstract Command getMoveChildrenCommand(ChangeBoundsRequest var1);

    private void eraseDropFeedback(Request req) {
        this.getTree().setInsertMark(null, true);
    }

    public void eraseTargetFeedback(Request req) {
        if (req.getType().equals("move") || req.getType().equals("add children") || req.getType().equals("create child")) {
            this.eraseDropFeedback(req);
        }
    }

    protected final int findIndexOfTreeItemAt(Point pt) {
        int index = -1;
        TreeItem item = this.findTreeItemAt(pt);
        if (item != null && (index = this.getHost().getChildren().indexOf(item.getData())) >= 0 && !this.isInUpperHalf(item.getBounds(), pt)) {
            ++index;
        }
        return index;
    }

    protected final TreeItem findTreeItemAt(Point pt) {
        return this.getTree().getItem(new org.eclipse.swt.graphics.Point(pt.x, pt.y));
    }

    public Command getCommand(Request req) {
        if (req.getType().equals("move children")) {
            return this.getMoveChildrenCommand((ChangeBoundsRequest)req);
        }
        if (req.getType().equals("add children")) {
            return this.getAddCommand((ChangeBoundsRequest)req);
        }
        if (req.getType().equals("create child")) {
            return this.getCreateCommand((CreateRequest)req);
        }
        return null;
    }

    public EditPart getTargetEditPart(Request req) {
        if (req.getType().equals("add children") || req.getType().equals("move") || req.getType().equals("create child")) {
            DropRequest drop = (DropRequest)((Object)req);
            org.eclipse.swt.graphics.Point where = new org.eclipse.swt.graphics.Point(drop.getLocation().x, drop.getLocation().y);
            Widget widget = ((TreeEditPart)this.getHost()).getWidget();
            if (widget instanceof Tree) {
                return this.getHost();
            }
            TreeItem treeitem = (TreeItem)widget;
            Rectangle bounds = treeitem.getBounds();
            int fudge = bounds.height / 5;
            Rectangle inner = new Rectangle(bounds.x, bounds.y + fudge, bounds.width, bounds.height - (treeitem.getExpanded() ? 0 : fudge * 2));
            if (!bounds.contains(where) || inner.contains(where)) {
                return this.getHost();
            }
        }
        return null;
    }

    private Tree getTree() {
        Widget widget = ((TreeEditPart)this.getHost()).getWidget();
        if (widget instanceof Tree) {
            return (Tree)widget;
        }
        return ((TreeItem)widget).getParent();
    }

    private void insertMarkAfterLastChild(TreeItem[] children) {
        if (children != null && children.length > 0) {
            TreeItem item = children[children.length - 1];
            this.getTree().setInsertMark(item, false);
        }
    }

    private boolean isInUpperHalf(Rectangle rect, Point pt) {
        Rectangle tempRect = new Rectangle(rect.x, rect.y, rect.width, rect.height / 2);
        return tempRect.contains(new org.eclipse.swt.graphics.Point(pt.x, pt.y));
    }

    private void showDropFeedback(DropRequest request) {
        Widget hostWidget = ((TreeEditPart)this.getHost()).getWidget();
        Tree tree = this.getTree();
        Point pt = request.getLocation();
        TreeItem item = this.findTreeItemAt(pt);
        if (item == null) {
            if (hostWidget == tree) {
                this.insertMarkAfterLastChild(tree.getItems());
            }
        } else if (item == hostWidget) {
            tree.setInsertMark(null, true);
        } else {
            boolean before = this.isInUpperHalf(item.getBounds(), pt);
            tree.setInsertMark(item, before);
        }
    }

    public void showTargetFeedback(Request req) {
        if (req.getType().equals("move") || req.getType().equals("add children") || req.getType().equals("create child")) {
            this.showDropFeedback((DropRequest)((Object)req));
        }
    }
}

