/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.internal.core.text.build.BuildModel;
import org.eclipse.pde.internal.core.text.build.PropertiesTextChangeListener;
import org.eclipse.pde.internal.ui.refactoring.MoveFromChange;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class BuildPropertiesChange {
    public static Change createRenameChange(IFile file, Object[] affectedElements, String[] newNames, IProgressMonitor monitor) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            BuildModel model;
            IDocument document;
            block11: {
                manager.connect(file.getFullPath(), LocationKind.NORMALIZE, monitor);
                ITextFileBuffer buffer = manager.getTextFileBuffer(file.getFullPath(), LocationKind.NORMALIZE);
                document = buffer.getDocument();
                try {
                    model = new BuildModel(document, false);
                    model.load();
                    if (model.isLoaded()) break block11;
                    return null;
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            PropertiesTextChangeListener listener = new PropertiesTextChangeListener(document);
            model.addModelChangedListener((IModelChangedListener)listener);
            IBuild build = model.getBuild();
            IBuildEntry[] entries = build.getBuildEntries();
            int i = 0;
            while (i < affectedElements.length) {
                IResource res;
                if (!(affectedElements[i] instanceof IJavaElement) && !((res = (IResource)affectedElements[i]) instanceof IProject)) {
                    int j = 0;
                    while (j < entries.length) {
                        BuildPropertiesChange.addBuildEntryEdit(entries[j], res, newNames[i]);
                        ++j;
                    }
                }
                ++i;
            }
            TextEdit[] operations = listener.getTextOperations();
            if (operations.length > 0) {
                MoveFromChange change = new MoveFromChange("", file);
                MultiTextEdit edit = new MultiTextEdit();
                edit.addChildren(operations);
                change.setEdit((TextEdit)edit);
                PDEModelUtility.setChangeTextType(change, file);
                MoveFromChange moveFromChange = change;
                return moveFromChange;
            }
            return null;
        }
        finally {
            manager.disconnect(file.getFullPath(), LocationKind.NORMALIZE, monitor);
        }
    }

    private static void addBuildEntryEdit(IBuildEntry entry, IResource res, String string) {
        IPath resPath = res.getProjectRelativePath();
        String[] tokens = entry.getTokens();
        int i = 0;
        while (i < tokens.length) {
            if (resPath.isPrefixOf((IPath)new Path(tokens[i]))) {
                try {
                    entry.renameToken(tokens[i], string.concat(tokens[i].substring(resPath.toString().length())));
                }
                catch (CoreException coreException) {}
            }
            ++i;
        }
    }
}

