/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.PopulationLabelValue;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.populationmodels.standard.ExternalDataSourcePopulationInitializer;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.impl.Messages;
import org.eclipse.stem.populationmodels.standard.impl.PopulationInitializerImpl;

public class ExternalDataSourcePopulationInitializerImpl
extends PopulationInitializerImpl
implements ExternalDataSourcePopulationInitializer {
    private static final String COUNT_PARAM = "Count";
    private static final String STEM_URI_PREFIX = "stem:";
    protected static final String DATA_PATH_EDEFAULT = null;
    protected String dataPath = DATA_PATH_EDEFAULT;
    protected static final int ROW_EDEFAULT = 1;
    protected int row = 1;

    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        if (this.isGraphDecorated()) {
            return;
        }
        this.checkPopulationModels();
        ReferenceScenarioDataMapImpl ref = null;
        try {
            CSVscenarioLoader loader1 = new CSVscenarioLoader(this.getDataPath());
            int res = loader1.getMaxResolution("");
            ref = loader1.parseAllFiles("", res);
        }
        catch (LogInitializationException lie) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.ERR_LOADING_DATA, (Object[])new Object[]{this.getURI().toString(), this.getDataPath()}), (Identifiable)this, (Exception)((Object)lie));
        }
        Set locations = ref.getLocations();
        for (String location : locations) {
            ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance instance = ref.getLocation(location);
            List data = instance.getData(COUNT_PARAM);
            if (data == null || data.size() == 0) {
                throw new ScenarioInitializationException(NLS.bind((String)Messages.NO_DATA_FOUND, (Object[])new Object[]{this.getURI().toString(), this.getDataPath()}), (Identifiable)this, new Exception());
            }
            if (data.size() < this.getRow() - 1) {
                throw new ScenarioInitializationException(NLS.bind((String)Messages.ROW_NOT_FOUND, (Object[])new Object[]{this.getURI().toString(), this.getDataPath(), this.getRow()}), (Identifiable)this, new Exception());
            }
            double count = Double.parseDouble((String)data.get(this.getRow() - 1));
            Graph g = this.getGraph();
            URI uri = null;
            uri = location.startsWith(STEM_URI_PREFIX) ? STEMURI.createURI((String)location) : RegionImpl.createRegionNodeURI((String)location);
            Node node = (Node)g.getNodes().get((Object)uri);
            if (node == null) {
                throw new ScenarioInitializationException(NLS.bind((String)Messages.EXT_DS_INIT_REGION_NOT_FOUND, (Object[])new Object[]{this.getURI().toString(), location}), (Identifiable)this, new Exception());
            }
            PopulationLabel existingLabel = null;
            for (NodeLabel lab : node.getLabels()) {
                if (!(lab instanceof PopulationLabel) || !((PopulationLabel)lab).getPopulationIdentifier().equals(this.getPopulationIdentifier())) continue;
                existingLabel = (PopulationLabel)lab;
            }
            if (existingLabel != null) {
                this.initializeLabelCount(existingLabel, time, count);
                continue;
            }
            PopulationLabel newLabel = LabelsFactory.eINSTANCE.createPopulationLabel();
            newLabel.setPopulationIdentifier(this.getPopulationIdentifier());
            newLabel.setURIOfIdentifiableToBeLabeled(node.getURI());
            newLabel.setNode(node);
            URI newURI = this.createPopulationLabelURI(node, time);
            g.getNodeLabels().put((Object)newURI, (Object)newLabel);
            this.initializeLabelCount(newLabel, time, count);
        }
    }

    protected void initializeLabelCount(PopulationLabel lab, STEMTime time, double count) {
        PopulationLabelValue plv = lab.getCurrentPopulationValue();
        plv.setCount(count);
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.EXTERNAL_DATA_SOURCE_POPULATION_INITIALIZER;
    }

    @Override
    public String getDataPath() {
        return this.dataPath;
    }

    @Override
    public void setDataPath(String newDataPath) {
        this.dataPath = newDataPath;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public void setRow(int newRow) {
        this.row = newRow;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getDataPath();
            }
            case 10: {
                return this.getRow();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setDataPath((String)newValue);
                return;
            }
            case 10: {
                this.setRow((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setDataPath(DATA_PATH_EDEFAULT);
                return;
            }
            case 10: {
                this.setRow(1);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return DATA_PATH_EDEFAULT == null ? this.dataPath != null : !DATA_PATH_EDEFAULT.equals(this.dataPath);
            }
            case 10: {
                return this.row != 1;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (dataPath: ");
        result.append(this.dataPath);
        result.append(", row: ");
        result.append(this.row);
        result.append(')');
        return result.toString();
    }

    @Override
    protected void initializeLabel(PopulationLabel lab, STEMTime time, boolean zeroValue) {
    }
}

