/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.analysis.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.stem.analysis.ErrorFunction;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.util.analysis.Activator;
import org.eclipse.stem.util.analysis.CSVAnalysisWriter;
import org.eclipse.stem.util.analysis.ScenarioAnalysisSuite;
import org.eclipse.stem.util.analysis.views.AnalysisControl;
import org.eclipse.stem.util.analysis.views.Messages;
import org.eclipse.stem.util.analysis.views.TimeSeriesCanvas;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScenarioComparisonControl
extends AnalysisControl {
    private static final String CONSUMER = "SCENARIOCOMPARISON_CONTROL";
    private static final String PRIMARY_FOLDER_KEY = "SCENARIOCOMPARISON_CONTROL_PRIMARY";
    private static final String SECONDARY_FOLDER_KEY = "SCENARIOCOMPARISON_CONTROL_SECONDARY";
    Label firstScenarioFolderLabel;
    Label secondScenarioFolderLabel;
    Text text1;
    Text text2;
    protected Combo errorFunctionCombo;
    protected ErrorFunction[] errorFunctions;
    protected Combo aCompartmentCombo;
    protected Combo bCompartmentCombo;
    Label statusLabel;
    static final ColorDefinition foreGround = ColorDefinitionImpl.BLACK();
    static final ColorDefinition BACKGROUND_COLOR = ColorDefinitionImpl.create((int)0, (int)0, (int)0);
    static final ColorDefinition frameColor = ColorDefinitionImpl.create((int)220, (int)220, (int)220);
    static final String ROOT_PATH = Platform.getLocation().toOSString();
    static TimeSeriesCanvas timeSeriesCanvas;
    List<EList<Double>> comparisonValues = new ArrayList<EList<Double>>();
    private static final String COMPARISON_FILE_NAME = "RMSCompare";
    private static final String SELECT_FOLDER_DIALOG_TEXT = "Pick a scenario folder";
    ScenarioAnalysisSuite analyzer = new ScenarioAnalysisSuite(this);
    Composite parent;

    public ScenarioComparisonControl(Composite parent) {
        super(parent, 0);
        this.parent = parent;
        this.createContents();
    }

    private void createContents() {
        Display display = this.getDisplay();
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        final Font newFont = this.getLargerFont(18, display);
        this.identifiableTitle.setFont(newFont);
        this.identifiableTitle.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
        this.identifiableTitle.setText(Messages.getString("COMP.TITLE"));
        this.statusLabel = new Label((Composite)this, 2048);
        this.statusLabel.setText("");
        this.firstScenarioFolderLabel = new Label((Composite)this, 2048);
        this.firstScenarioFolderLabel.setText(Messages.getString("COMP.FOLDER1LABEL"));
        this.text1 = new Text((Composite)this, 2048);
        String primaryDir = this.prefs.getRecentFolder(PRIMARY_FOLDER_KEY);
        this.text1.setText(primaryDir);
        this.secondScenarioFolderLabel = new Label((Composite)this, 2048);
        this.secondScenarioFolderLabel.setText(Messages.getString("COMP.FOLDER2LABEL"));
        this.text2 = new Text((Composite)this, 2048);
        String secondaryDir = this.prefs.getRecentFolder(SECONDARY_FOLDER_KEY);
        this.text2.setText(secondaryDir);
        Composite analyzeButtonComposite = this.getAnalyzeButtonComposite(this, Messages.getString("COMP.ANALYZE"));
        this.statusLabel = new Label((Composite)this, 8);
        this.statusLabel.setBackground(display.getSystemColor(1));
        this.statusLabel.setText(Messages.getString("COMP.RESULTS"));
        int spacer = 5;
        int buttonspacer = 0;
        FormData titleFormData = new FormData();
        this.identifiableTitle.setLayoutData((Object)titleFormData);
        titleFormData.top = new FormAttachment(0, 0);
        titleFormData.left = new FormAttachment(0, 0);
        titleFormData.right = new FormAttachment(100, 0);
        FormData firstScenarioFolderLabelFormData = new FormData();
        firstScenarioFolderLabelFormData.top = new FormAttachment((Control)this.identifiableTitle, spacer);
        firstScenarioFolderLabelFormData.left = new FormAttachment(0, 0);
        firstScenarioFolderLabelFormData.right = new FormAttachment(15, 0);
        this.firstScenarioFolderLabel.setLayoutData((Object)firstScenarioFolderLabelFormData);
        FormData text1FormData = new FormData();
        text1FormData.top = new FormAttachment((Control)this.identifiableTitle, spacer);
        text1FormData.left = new FormAttachment((Control)this.firstScenarioFolderLabel, 0);
        text1FormData.right = new FormAttachment(85, 0);
        this.text1.setLayoutData((Object)text1FormData);
        Button selectFolder1Button = new Button((Composite)this, 0);
        selectFolder1Button.setText(Messages.getString("COMP.SELECTFOLDERBUTTON"));
        FormData selectFolder1FormData = new FormData();
        selectFolder1FormData.top = new FormAttachment((Control)this.identifiableTitle, buttonspacer);
        selectFolder1FormData.left = new FormAttachment((Control)this.text1, 0);
        selectFolder1Button.setLayoutData((Object)selectFolder1FormData);
        final Shell shell = this.getShell();
        selectFolder1Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                dd.setText(ScenarioComparisonControl.SELECT_FOLDER_DIALOG_TEXT);
                String beginSearch = ScenarioComparisonControl.this.text1.getText();
                if (beginSearch == null || beginSearch.length() < 1) {
                    beginSearch = ROOT_PATH;
                }
                dd.setFilterPath(beginSearch);
                String selected = dd.open();
                if (selected != null) {
                    ScenarioComparisonControl.this.text1.setText(selected);
                }
            }
        });
        FormData secondScenarioFolderLabelFormData = new FormData();
        secondScenarioFolderLabelFormData.top = new FormAttachment((Control)this.firstScenarioFolderLabel, spacer);
        secondScenarioFolderLabelFormData.left = new FormAttachment(0, 0);
        secondScenarioFolderLabelFormData.right = new FormAttachment(15, 0);
        this.secondScenarioFolderLabel.setLayoutData((Object)secondScenarioFolderLabelFormData);
        FormData text2FormData = new FormData();
        text2FormData.top = new FormAttachment((Control)this.text1, spacer);
        text2FormData.left = new FormAttachment((Control)this.secondScenarioFolderLabel, 0);
        text2FormData.right = new FormAttachment(85, 0);
        this.text2.setLayoutData((Object)text2FormData);
        Button selectFolder2Button = new Button((Composite)this, 0);
        selectFolder2Button.setText(Messages.getString("COMP.SELECTFOLDERBUTTON"));
        FormData selectFolder2FormData = new FormData();
        selectFolder2FormData.top = new FormAttachment((Control)this.text1, buttonspacer);
        selectFolder2FormData.left = new FormAttachment((Control)this.text2, 0);
        selectFolder2Button.setLayoutData((Object)selectFolder2FormData);
        selectFolder2Button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(shell, 4096);
                dd.setText(Messages.getString("COMP.SELECTFOLDERDIALOG"));
                String beginSearch = ScenarioComparisonControl.this.text2.getText();
                if (beginSearch == null || beginSearch.length() < 1) {
                    beginSearch = ROOT_PATH;
                }
                dd.setFilterPath(beginSearch);
                String selected = dd.open();
                if (selected != null) {
                    ScenarioComparisonControl.this.text2.setText(selected);
                }
            }
        });
        Button resetButton = new Button((Composite)this, 0);
        resetButton.setText(Messages.getString("COMP.RESET"));
        FormData resetFormData = new FormData();
        resetFormData.top = new FormAttachment((Control)this.text2, 0);
        resetFormData.left = new FormAttachment((Control)this.secondScenarioFolderLabel, 0);
        resetButton.setLayoutData((Object)resetFormData);
        Label errorFunctionLabel = new Label((Composite)this, 0);
        FormData errorFunctionLabelFormData = new FormData();
        errorFunctionLabelFormData.top = new FormAttachment((Control)resetButton, 0);
        errorFunctionLabelFormData.left = new FormAttachment(0, 0);
        errorFunctionLabelFormData.right = new FormAttachment(15, 0);
        errorFunctionLabel.setLayoutData((Object)errorFunctionLabelFormData);
        errorFunctionLabel.setText(Messages.getString("COMP.ERRORFUNCTION"));
        this.errorFunctionCombo = new Combo((Composite)this, 0);
        FormData errorFunctionComboFormData = new FormData();
        errorFunctionComboFormData.top = new FormAttachment((Control)resetButton, 0);
        errorFunctionComboFormData.left = new FormAttachment((Control)errorFunctionLabel, 5);
        this.errorFunctionCombo.setLayoutData((Object)errorFunctionComboFormData);
        this.populateErrorFunctionCombo();
        String[] defaultKeys = new String[]{Messages.getString("COMP.SET_UP_MESSAGE")};
        Label aLabel = new Label((Composite)this, 0);
        this.aCompartmentCombo = new Combo((Composite)this, 0);
        this.aCompartmentCombo.setItems(defaultKeys);
        this.aCompartmentCombo.select(0);
        Label bLabel = new Label((Composite)this, 0);
        this.bCompartmentCombo = new Combo((Composite)this, 0);
        this.bCompartmentCombo.setItems(defaultKeys);
        this.bCompartmentCombo.select(0);
        FormData aLabelFormData = new FormData();
        FormData aCompartmentFormData = new FormData();
        FormData bLabelFormData = new FormData();
        FormData bCompartmentFormData = new FormData();
        aLabel.setLayoutData((Object)aLabelFormData);
        this.aCompartmentCombo.setLayoutData((Object)aCompartmentFormData);
        bLabel.setLayoutData((Object)bLabelFormData);
        this.bCompartmentCombo.setLayoutData((Object)bCompartmentFormData);
        aLabel.setText(Messages.getString("COMP.COMPARTMENT_A"));
        bLabel.setText(Messages.getString("COMP.COMPARTMENT_B"));
        aLabelFormData.top = new FormAttachment((Control)resetButton, 0);
        aLabelFormData.left = new FormAttachment((Control)this.errorFunctionCombo, 15);
        aCompartmentFormData.top = new FormAttachment((Control)resetButton, 0);
        aCompartmentFormData.left = new FormAttachment((Control)aLabel, 5);
        bLabelFormData.top = new FormAttachment((Control)resetButton, 0);
        bLabelFormData.left = new FormAttachment((Control)this.aCompartmentCombo, 5);
        bCompartmentFormData.top = new FormAttachment((Control)resetButton, 0);
        bCompartmentFormData.left = new FormAttachment((Control)bLabel, 5);
        FormData analysisButtonFormData = new FormData();
        analysisButtonFormData.top = new FormAttachment((Control)this.errorFunctionCombo, spacer);
        analysisButtonFormData.left = new FormAttachment(0, 0);
        analysisButtonFormData.right = new FormAttachment(100, 0);
        analyzeButtonComposite.setLayoutData((Object)analysisButtonFormData);
        timeSeriesCanvas = new TimeSeriesCanvas(this, Messages.getString("COMP.RMSDIFFERENCELABEL"), Messages.getString("COMP.RMSSTRING"), Messages.getString("COMP.RMSSTRING"), foreGround, BACKGROUND_COLOR, frameColor, 0);
        FormData chartFormData = new FormData();
        timeSeriesCanvas.setLayoutData(chartFormData);
        chartFormData.top = new FormAttachment((Control)analyzeButtonComposite, 0);
        chartFormData.bottom = new FormAttachment(90, 0);
        chartFormData.left = new FormAttachment(0, 0);
        chartFormData.right = new FormAttachment(100, 0);
        FormData statusFormData = new FormData();
        statusFormData.top = new FormAttachment(90, 0);
        statusFormData.bottom = new FormAttachment(100, 0);
        statusFormData.left = new FormAttachment(0, 0);
        statusFormData.right = new FormAttachment(100, 0);
        this.statusLabel.setLayoutData((Object)statusFormData);
        final ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.getShell());
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScenarioComparisonControl.this.statusLabel.setText(Messages.getString("COMMON.STATUS"));
                String referenceDirectory = ScenarioComparisonControl.this.text1.getText();
                String comparisonDirectory = ScenarioComparisonControl.this.text2.getText();
                if (!ScenarioComparisonControl.this.analyzer.validate(referenceDirectory)) {
                    ScenarioComparisonControl.this.statusLabel.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    ScenarioComparisonControl.this.text1.setText("");
                }
                if (!ScenarioComparisonControl.this.analyzer.validate(comparisonDirectory)) {
                    ScenarioComparisonControl.this.statusLabel.setText(ScenarioAnalysisSuite.NOT_FOUND_MSG);
                    ScenarioComparisonControl.this.text2.setText("");
                }
                if (!ScenarioComparisonControl.this.analyzer.validate(referenceDirectory) || !ScenarioComparisonControl.this.analyzer.validate(comparisonDirectory)) {
                    return;
                }
                try {
                    int i;
                    int defaultIndex;
                    String[] aKeys = ScenarioComparisonControl.this.analyzer.getKeys(referenceDirectory);
                    String[] bKeys = ScenarioComparisonControl.this.analyzer.getKeys(comparisonDirectory);
                    if (aKeys != null) {
                        defaultIndex = 0;
                        i = 0;
                        while (i < aKeys.length) {
                            if (aKeys[i].equalsIgnoreCase("Incidence")) {
                                defaultIndex = i;
                                break;
                            }
                            ++i;
                        }
                        ScenarioComparisonControl.this.aCompartmentCombo.removeAll();
                        ScenarioComparisonControl.this.aCompartmentCombo.setItems(aKeys);
                        ScenarioComparisonControl.this.aCompartmentCombo.select(defaultIndex);
                    }
                    if (bKeys != null) {
                        defaultIndex = 0;
                        i = 0;
                        while (i < bKeys.length) {
                            if (bKeys[i].equalsIgnoreCase("Incidence")) {
                                defaultIndex = i;
                                break;
                            }
                            ++i;
                        }
                        ScenarioComparisonControl.this.bCompartmentCombo.removeAll();
                        ScenarioComparisonControl.this.bCompartmentCombo.setItems(bKeys);
                        ScenarioComparisonControl.this.bCompartmentCombo.select(defaultIndex);
                    }
                    ScenarioComparisonControl.this.parent.redraw();
                }
                catch (LogInitializationException sie) {
                    Activator.logError("", sie);
                }
            }
        });
        this.analyzeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                timeSeriesCanvas.reset();
                ScenarioComparisonControl.this.comparisonValues.clear();
                timeSeriesCanvas.draw();
                ScenarioComparisonControl.this.statusLabel.setText(Messages.getString("COMMON.STATUS"));
                String referenceDirectory = ScenarioComparisonControl.this.text1.getText();
                String comparisonDirectory = ScenarioComparisonControl.this.text2.getText();
                String refDataKey = ScenarioComparisonControl.this.aCompartmentCombo.getItem(ScenarioComparisonControl.this.aCompartmentCombo.getSelectionIndex());
                String comparisonDataKey = ScenarioComparisonControl.this.bCompartmentCombo.getItem(ScenarioComparisonControl.this.bCompartmentCombo.getSelectionIndex());
                if (refDataKey.equalsIgnoreCase(Messages.getString("COMP.SET_UP_MESSAGE")) || comparisonDataKey.equalsIgnoreCase(Messages.getString("COMP.SET_UP_MESSAGE"))) {
                    ScenarioComparisonControl.this.statusLabel.setText(Messages.getString("COMMON.MUST_SET_UP"));
                    return;
                }
                ErrorResult result = null;
                try {
                    int index = ScenarioComparisonControl.this.errorFunctionCombo.getSelectionIndex() == -1 ? 0 : ScenarioComparisonControl.this.errorFunctionCombo.getSelectionIndex();
                    ErrorFunction selectedErrorFunction = ScenarioComparisonControl.this.errorFunctions[index];
                    selectedErrorFunction.setReferenceDataCompartment(refDataKey);
                    selectedErrorFunction.setComparisonCompartment(comparisonDataKey);
                    result = ScenarioComparisonControl.this.analyzer.compare(referenceDirectory, comparisonDirectory, (IRunnableContext)progressDialog, selectedErrorFunction);
                    if (result != null) {
                        ScenarioComparisonControl.this.comparisonValues.add((EList<Double>)result.getErrorByTimeStep());
                    }
                    ScenarioComparisonControl.this.prefs.setRecentFolder(ScenarioComparisonControl.PRIMARY_FOLDER_KEY, referenceDirectory);
                    ScenarioComparisonControl.this.prefs.setRecentFolder(ScenarioComparisonControl.SECONDARY_FOLDER_KEY, comparisonDirectory);
                }
                catch (LogInitializationException sie) {
                    Activator.logError("", sie);
                }
                timeSeriesCanvas.draw();
                String outFileName = "RMSCompare_" + ScenarioComparisonControl.getScenarioNameFromDirectoryName(referenceDirectory) + "_" + ScenarioComparisonControl.getScenarioNameFromDirectoryName(comparisonDirectory);
                CSVAnalysisWriter writer = new CSVAnalysisWriter(outFileName);
                writer.logData(ScenarioComparisonControl.this.comparisonValues);
                String results = "RMS Difference = ";
                if (result != null) {
                    results = String.valueOf(results) + result.getError();
                }
                ScenarioComparisonControl.this.statusLabel.setText(results);
            }
        });
    }

    public static String getScenarioNameFromDirectoryName(String dirName) {
        int last = dirName.lastIndexOf("/");
        int last2 = dirName.lastIndexOf("\\");
        if (last2 > last) {
            last = last2;
        }
        if (last <= 0) {
            last = 0;
        }
        String retVal = dirName.substring(last + 1, dirName.length());
        return retVal;
    }

    @Override
    public double[] getValues(int chartIndex, int comparisonType) {
        if (this.comparisonValues == null || this.comparisonValues.size() == 0) {
            return new double[0];
        }
        EList<Double> r = this.comparisonValues.get(0);
        double[] result = new double[r.size()];
        int i = 0;
        while (i < r.size()) {
            result[i] = (Double)r.get(i);
            ++i;
        }
        return result;
    }

    private void populateErrorFunctionCombo() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] errorFunctionsConfigElements = registry.getConfigurationElementsFor("org.eclipse.stem.analysis.errorfunction");
        ArrayList<ErrorFunction> temp = new ArrayList<ErrorFunction>();
        this.errorFunctions = new ErrorFunction[errorFunctionsConfigElements.length];
        int i = 0;
        while (i < errorFunctionsConfigElements.length) {
            IConfigurationElement element = errorFunctionsConfigElements[i];
            if (element.getName().equals("classdef")) {
                try {
                    temp.add((ErrorFunction)element.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    Activator.logError(Messages.getString("Unable to instantiate extension point " + element), e);
                }
            }
            ++i;
        }
        this.errorFunctions = temp.toArray(new ErrorFunction[0]);
        i = 0;
        while (i < this.errorFunctions.length) {
            this.errorFunctionCombo.add(this.errorFunctions[i].eClass().getName());
            ++i;
        }
        this.errorFunctionCombo.select(0);
    }

    @Override
    public String getProperty(int chartIndex, int state) {
        return Messages.getString("COMP.RMSSTRING");
    }

    @Override
    public int getNumProperties(int chartIndex) {
        return 1;
    }

    @Override
    public void remove() {
        this.updateStatusLabel();
    }

    protected void updateStatusLabel() {
        this.statusLabel.setText(Messages.getString("COMMON.STATUS"));
    }

    @Override
    protected void initializeHeader(String folderName) {
        this.simulationNameLabel.setText("analyzing " + folderName);
    }

    public void dispose() {
        super.dispose();
    }

    @Override
    public Map<String, Object> getControlParametersMap() {
        return controlParametersMap;
    }
}

