/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.filters.SyntheticMembersFilter;
import org.eclipse.jdt.internal.ui.typehierarchy.HierarchyViewerSorter;
import org.eclipse.jdt.internal.ui.typehierarchy.MethodsContentProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.MethodsLabelProvider;
import org.eclipse.jdt.internal.ui.typehierarchy.ShowInheritedMembersAction;
import org.eclipse.jdt.internal.ui.typehierarchy.SortByDefiningTypeAction;
import org.eclipse.jdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jdt.internal.ui.util.JavaUIHelp;
import org.eclipse.jdt.internal.ui.util.SelectionUtil;
import org.eclipse.jdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;

public class MethodsViewer
extends ProblemTableViewer {
    private static final String TAG_SHOWINHERITED = "showinherited";
    private static final String TAG_SORTBYDEFININGTYPE = "sortbydefiningtype";
    private static final String TAG_VERTICAL_SCROLL = "mv_vertical_scroll";
    private MethodsLabelProvider fLabelProvider;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ShowInheritedMembersAction fShowInheritedMembersAction;
    private SortByDefiningTypeAction fSortByDefiningTypeAction;

    public MethodsViewer(Composite parent, TypeHierarchyLifeCycle lifeCycle) {
        super(new Table(parent, 2));
        this.addFilter(new SyntheticMembersFilter());
        this.fLabelProvider = new MethodsLabelProvider(lifeCycle, this);
        this.setLabelProvider((IBaseLabelProvider)new DecoratingJavaLabelProvider(this.fLabelProvider, true));
        this.setContentProvider((IContentProvider)new MethodsContentProvider(lifeCycle));
        HierarchyViewerSorter sorter = new HierarchyViewerSorter(lifeCycle);
        sorter.setSortByDefiningType(false);
        this.setComparator(sorter);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this, "HierarchyMethodView", false, 7);
        this.fShowInheritedMembersAction = new ShowInheritedMembersAction(this, false);
        this.fSortByDefiningTypeAction = new SortByDefiningTypeAction(this, false);
        this.showInheritedMethodsNoRedraw(false);
        this.sortByDefiningTypeNoRedraw(false);
        JavaUIHelp.setHelp((StructuredViewer)this, "org.eclipse.jdt.ui.type_hierarchy_view_context");
    }

    private void showInheritedMethodsNoRedraw(boolean on) {
        MethodsContentProvider cprovider = (MethodsContentProvider)this.getContentProvider();
        cprovider.showInheritedMethods(on);
        this.fShowInheritedMembersAction.setChecked(on);
        if (on) {
            this.fLabelProvider.setTextFlags(this.fLabelProvider.getTextFlags() | JavaElementLabels.ALL_POST_QUALIFIED);
        } else {
            this.fLabelProvider.setTextFlags(this.fLabelProvider.getTextFlags() & (JavaElementLabels.ALL_POST_QUALIFIED ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (on) {
            this.sortByDefiningTypeNoRedraw(false);
        }
        this.fSortByDefiningTypeAction.setEnabled(!on);
    }

    public void showInheritedMethods(boolean on) {
        if (on == this.isShowInheritedMethods()) {
            return;
        }
        try {
            this.getTable().setRedraw(false);
            this.showInheritedMethodsNoRedraw(on);
            this.refresh();
        }
        finally {
            this.getTable().setRedraw(true);
        }
    }

    private void sortByDefiningTypeNoRedraw(boolean on) {
        this.fSortByDefiningTypeAction.setChecked(on);
        this.fLabelProvider.setShowDefiningType(on);
        ((HierarchyViewerSorter)this.getComparator()).setSortByDefiningType(on);
    }

    public void sortByDefiningType(boolean on) {
        if (on == this.isShowDefiningTypes()) {
            return;
        }
        try {
            this.getTable().setRedraw(false);
            this.sortByDefiningTypeNoRedraw(on);
            this.refresh();
        }
        finally {
            this.getTable().setRedraw(true);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    public boolean isShowInheritedMethods() {
        return ((MethodsContentProvider)this.getContentProvider()).isShowInheritedMethods();
    }

    public boolean isShowDefiningTypes() {
        return this.fLabelProvider.isShowDefiningType();
    }

    public void saveState(IMemento memento) {
        this.fMemberFilterActionGroup.saveState(memento);
        memento.putString(TAG_SHOWINHERITED, String.valueOf(this.isShowInheritedMethods()));
        memento.putString(TAG_SORTBYDEFININGTYPE, String.valueOf(this.isShowDefiningTypes()));
        ScrollBar bar = this.getTable().getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putString(TAG_VERTICAL_SCROLL, String.valueOf(position));
    }

    public void restoreState(IMemento memento) {
        Integer vScroll;
        this.fMemberFilterActionGroup.restoreState(memento);
        this.getControl().setRedraw(false);
        this.refresh();
        this.getControl().setRedraw(true);
        boolean showInherited = Boolean.valueOf(memento.getString(TAG_SHOWINHERITED));
        this.showInheritedMethods(showInherited);
        boolean showDefiningTypes = Boolean.valueOf(memento.getString(TAG_SORTBYDEFININGTYPE));
        this.sortByDefiningType(showDefiningTypes);
        ScrollBar bar = this.getTable().getVerticalBar();
        if (bar != null && (vScroll = memento.getInteger(TAG_VERTICAL_SCROLL)) != null) {
            bar.setSelection(vScroll.intValue());
        }
    }

    public void initContextMenu(IMenuListener menuListener, String popupId, IWorkbenchPartSite viewSite) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuListener);
        Menu menu = menuMgr.createContextMenu((Control)this.getTable());
        this.getTable().setMenu(menu);
        viewSite.registerContextMenu(popupId, menuMgr, (ISelectionProvider)this);
    }

    public void contributeToContextMenu(IMenuManager menu) {
    }

    public void contributeToToolBar(ToolBarManager tbm) {
        tbm.add((IAction)this.fShowInheritedMembersAction);
        tbm.add((IAction)this.fSortByDefiningTypeAction);
        tbm.add((IContributionItem)new Separator());
        this.fMemberFilterActionGroup.contributeToToolBar((IToolBarManager)tbm);
    }

    public void dispose() {
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
    }

    protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        List<?> oldSelections = SelectionUtil.toList(invalidSelection);
        List<?> newSelections = SelectionUtil.toList(newSelection);
        if (!oldSelections.isEmpty()) {
            ArrayList newSelectionElements = new ArrayList(newSelections);
            try {
                Object[] currElements = this.getFilteredChildren(this.getInput());
                int i = 0;
                while (i < oldSelections.size()) {
                    IMethod similar;
                    IMethod method;
                    Object curr = oldSelections.get(i);
                    if (curr instanceof IMethod && !newSelections.contains(curr) && (method = (IMethod)curr).exists() && (similar = this.findSimilarMethod(method, currElements)) != null) {
                        newSelectionElements.add(similar);
                    }
                    ++i;
                }
                if (!newSelectionElements.isEmpty()) {
                    newSelection = new StructuredSelection(newSelectionElements);
                } else if (currElements.length > 0) {
                    newSelection = new StructuredSelection(currElements[0]);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        this.setSelection(newSelection);
        this.updateSelection(newSelection);
    }

    private IMethod findSimilarMethod(IMethod meth, Object[] elements) throws JavaModelException {
        String name = meth.getElementName();
        String[] paramTypes = meth.getParameterTypes();
        boolean isConstructor = meth.isConstructor();
        int i = 0;
        while (i < elements.length) {
            Object curr = elements[i];
            if (curr instanceof IMethod && JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, (IMethod)curr)) {
                return (IMethod)curr;
            }
            ++i;
        }
        return null;
    }
}

