/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.graphmap;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.modifier.DoubleModifier;
import org.eclipse.stem.core.modifier.FeatureModifier;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.predicate.And;
import org.eclipse.stem.core.predicate.ElapsedTimeTest;
import org.eclipse.stem.core.predicate.Not;
import org.eclipse.stem.core.predicate.Predicate;
import org.eclipse.stem.core.predicate.PredicateExpression;
import org.eclipse.stem.core.trigger.TriggerList;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabel;
import org.eclipse.stem.definitions.edges.PopulationEdge;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.geography.centers.GeographicCenters;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;
import org.eclipse.stem.ui.views.graphmap.DecoratorDisplayData;
import org.eclipse.stem.ui.views.graphmap.GeoViewOptionsBar;
import org.eclipse.stem.ui.views.graphmap.GraphMapCanvas;
import org.eclipse.stem.ui.views.graphmap.GraphMapPreferences;
import org.eclipse.stem.ui.views.graphmap.GraphMapRegistry;
import org.eclipse.stem.ui.views.graphmap.GraphMapView;
import org.eclipse.stem.ui.views.graphmap.Messages;
import org.eclipse.stem.ui.views.graphmap.PaneChangeEvent;
import org.eclipse.stem.ui.views.graphmap.StemPolygon;
import org.eclipse.stem.ui.views.graphmap.StemPolygonList;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class GraphMapControl
extends Composite
implements ISimulationListener,
GeoViewOptionsBar.PropertySelectionListener {
    private ISimulation simulation;
    private GraphMapCanvas canvas;
    private String selectedEdge;
    private Job refreshJob;
    private boolean refreshPending;
    private StemPolygonList polygonsToDraw;
    private ColorProviderAdapter colorProviderAdapter;
    private GeoViewOptionsBar optionsBar;
    private Map<Decorator, DecoratorDisplayData> decoratorToDecoratorDisplayDataMap;
    private Map<LatLong, StemPolygonList> polygonListMap;
    private GraphMapView view;
    private boolean showOptionsBar;
    private FormData optionsBarFormData;
    private Composite topComposite;

    public GraphMapControl(Composite parent, int style, GraphMapView view) {
        super(parent, style);
        this.view = view;
        this.decoratorToDecoratorDisplayDataMap = new HashMap<Decorator, DecoratorDisplayData>();
        this.polygonListMap = new HashMap<LatLong, StemPolygonList>();
        this.canvas = new GraphMapCanvas(this, 0, this.view);
        this.canvas.setColorProvider(this.colorProviderAdapter);
        this.canvas.addPaneChangeListener(new PaneChangeListener(this));
        this.setLayout((Layout)new FormLayout());
        this.topComposite = new Composite((Composite)this, 0);
        this.topComposite.setLayout((Layout)new FillLayout(256));
        this.canvas.setGainScaleLabel(new Label(this.topComposite, 131072));
        this.optionsBar = new GeoViewOptionsBar(this, 0, view);
        this.optionsBar.addPropertySelectionListener(this);
        FormData topCompositeFormData = new FormData();
        this.topComposite.setLayoutData((Object)topCompositeFormData);
        topCompositeFormData.top = new FormAttachment(0, 0);
        topCompositeFormData.left = new FormAttachment(0, 0);
        topCompositeFormData.right = new FormAttachment(100, 0);
        FormData geoRendererFormData = new FormData();
        this.canvas.setLayoutData(geoRendererFormData);
        geoRendererFormData.top = new FormAttachment((Control)this.topComposite, 0);
        geoRendererFormData.bottom = new FormAttachment((Control)this.optionsBar, 0);
        geoRendererFormData.left = new FormAttachment(0, 0);
        geoRendererFormData.right = new FormAttachment(100, 0);
        this.optionsBarFormData = new FormData();
        this.optionsBar.setLayoutData(this.optionsBarFormData);
        this.optionsBarFormData.bottom = new FormAttachment(100, 0);
        this.optionsBarFormData.left = new FormAttachment(0, 0);
        this.optionsBarFormData.right = new FormAttachment(100, 0);
        this.showOptionsBar = true;
        this.pack();
    }

    public ISimulation getSimulation() {
        return this.simulation;
    }

    public void setSimulation(ISimulation simulation) {
        if (this.simulation == simulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
        this.simulation = simulation;
        if (this.simulation != null) {
            this.simulation.addSimulationListener((ISimulationListener)this);
            this.optionsBar.setSimulation(this.simulation);
            this.setGeoViewProperties();
        }
        this.refresh();
    }

    public void showOptionsBar(boolean toggle) {
        this.showOptionsBar = toggle;
        if (this.showOptionsBar) {
            this.optionsBarFormData.top = null;
            this.layout();
        } else {
            this.optionsBarFormData.top = new FormAttachment(100, 0);
            this.layout();
        }
        this.redraw();
    }

    public void refresh() {
        if (this.refreshJob != null) {
            this.refreshPending = true;
            return;
        }
        this.refreshJob = new Job(Messages.getString("IMView.MRefresh")){

            protected IStatus run(IProgressMonitor monitor) {
                GraphMapControl.this.polygonsToDraw = GraphMapControl.this.createPolygonsToDraw(monitor);
                if (GraphMapControl.this.polygonsToDraw == null || GraphMapControl.this.polygonsToDraw.isEmpty()) {
                    return Status.OK_STATUS;
                }
                try {
                    Display display;
                    if (PlatformUI.isWorkbenchRunning() && !(display = Display.getDefault()).isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!GraphMapControl.this.canvas.isDisposed()) {
                                    GraphMapControl.this.canvas.render(GraphMapControl.this.polygonsToDraw, GraphMapControl.this.simulation);
                                    GraphMapControl.this.refreshJob = null;
                                    if (GraphMapControl.this.refreshPending) {
                                        GraphMapControl.this.refreshPending = false;
                                        GraphMapControl.this.refresh();
                                    }
                                } else {
                                    GraphMapControl.this.refreshJob = null;
                                }
                            }
                        });
                    }
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (SWTException sWTException) {}
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.schedule();
    }

    public void simulationChanged(SimulationEvent event) {
        switch (event.getSimulationState()) {
            case COMPLETED_CYCLE: {
                if (!this.optionsBar.isInitialized()) {
                    this.optionsBar.setSimulation(this.getSimulation());
                }
                this.refresh();
                break;
            }
            case RESET: {
                this.refresh();
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.optionsBar.removePropertySelectionListener(this);
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.canvas.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.canvas.removeSelectionChangedListener(listener);
    }

    public Image getMapCanvasImage() {
        return this.canvas.getCanvasImage();
    }

    @Override
    public void propertySelected() {
        this.setGeoViewProperties();
        this.layout();
        this.refresh();
    }

    private void setGeoViewProperties() {
        AdapterFactory adapterFactory;
        Adapter adapter;
        Decorator decorator = this.optionsBar.getSelectedDecorator();
        if (decorator != null && (adapter = (adapterFactory = ColorProviderAdapterFactory.INSTANCE.getFactoryForType(this.optionsBar.getSelectedColorProvider())).adapt((Notifier)decorator.getGraph(), this.optionsBar.getSelectedColorProvider())) instanceof ColorProviderAdapter) {
            this.colorProviderAdapter = (ColorProviderAdapter)adapter;
            this.colorProviderAdapter.setSelectedDecorator(this.optionsBar.getSelectedDecorator());
            this.colorProviderAdapter.setSelectedPopulationIdentifier(this.optionsBar.getSelectedPopulationIdentifier());
            this.canvas.setColorProvider(this.colorProviderAdapter);
            this.selectedEdge = this.optionsBar.getSelectedEdge();
            if (this.optionsBar.getSelectedProperty() != null) {
                this.colorProviderAdapter.setSelectedProperty(this.optionsBar.getSelectedProperty());
            }
        }
    }

    private DecoratorDisplayData getDecoratorDisplayData(Decorator decorator, IProgressMonitor monitor) {
        DecoratorDisplayData retValue = this.decoratorToDecoratorDisplayDataMap.get(decorator);
        if (retValue == null) {
            retValue = new DecoratorDisplayData();
            this.decoratorToDecoratorDisplayDataMap.put(decorator, retValue);
            if (decorator instanceof TriggerList) {
                Graph graph = this.simulation.getScenario().getCanonicalGraph();
                for (Node node : graph.getNodes().values()) {
                    retValue.addNode(node);
                }
            } else {
                if (decorator.getLabelsToUpdate() == null || decorator.getLabelsToUpdate().isEmpty()) {
                    return retValue;
                }
                for (DynamicLabel label : decorator.getLabelsToUpdate()) {
                    retValue.addNode(((DynamicNodeLabel)label).getNode());
                }
            }
        }
        if (!retValue.hasAllLatLong()) {
            monitor.subTask(decorator.getDublinCore().getTitle());
            retValue.updateLatLong(monitor);
        }
        return retValue;
    }

    /*
     * WARNING - void declaration
     */
    private StemPolygonList createPolygonsToDraw(IProgressMonitor monitor) {
        Decorator selectedDecorator = this.optionsBar.getSelectedDecorator();
        String selectedPopulationIdentifier = this.optionsBar.getSelectedPopulationIdentifier();
        StemPolygonList retValue = new StemPolygonList();
        if (selectedDecorator == null) {
            return null;
        }
        DecoratorDisplayData displayData = this.getDecoratorDisplayData(selectedDecorator, monitor);
        if (displayData == null) {
            return null;
        }
        monitor.beginTask(selectedDecorator.getDublinCore().getTitle(), displayData.getNodeData().size());
        if (selectedDecorator instanceof TriggerList) {
            Map<URI, Double> nodeValues = this.getMigrationNodeValues();
            for (Map.Entry<Node, LatLong> entry : displayData.getNodeData().entrySet()) {
                Node node = entry.getKey();
                LatLong latLong = entry.getValue();
                monitor.subTask(node.getDublinCore().getTitle());
                if (latLong != null && latLong.size() > 0) {
                    StemPolygonList stemPolygonsList = this.polygonListMap.get(latLong);
                    Double value = nodeValues.get(node.getURI());
                    if (stemPolygonsList == null) {
                        stemPolygonsList = new StemPolygonList(latLong, (Identifiable)node);
                        this.polygonListMap.put(latLong, stemPolygonsList);
                    }
                    if (value != null) {
                        stemPolygonsList.setValueToDisplay(value);
                    } else {
                        stemPolygonsList.setValueToDisplay(0.0);
                    }
                    retValue.addAll(stemPolygonsList);
                }
                monitor.worked(1);
            }
        } else {
            for (Map.Entry<Node, LatLong> labelData : displayData.getNodeData().entrySet()) {
                Node node = labelData.getKey();
                LatLong latLong = labelData.getValue();
                boolean foundLabel = false;
                boolean success = true;
                block4: do {
                    success = true;
                    try {
                        for (NodeLabel lab : labelData.getKey().getLabels()) {
                            if (lab instanceof DiseaseModelLabel && ((DiseaseModelLabel)lab).getPopulationModelLabel().getPopulationIdentifier().equals(selectedPopulationIdentifier)) {
                                foundLabel = true;
                                continue block4;
                            }
                            if (!(lab instanceof PopulationModelLabel) || !((PopulationModelLabel)lab).getPopulationIdentifier().equals(selectedPopulationIdentifier)) continue;
                            foundLabel = true;
                            continue block4;
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        success = false;
                    }
                } while (!success);
                if (!foundLabel) continue;
                monitor.subTask(node.getDublinCore().getTitle());
                if (latLong != null && latLong.size() > 0) {
                    StemPolygonList stemPolygonsList = this.polygonListMap.get(latLong);
                    if (stemPolygonsList == null) {
                        stemPolygonsList = new StemPolygonList(latLong, (Identifiable)node);
                        this.polygonListMap.put(latLong, stemPolygonsList);
                    }
                    stemPolygonsList.setValueToDisplay(Double.NaN);
                    retValue.addAll(stemPolygonsList);
                }
                monitor.worked(1);
            }
        }
        if (this.selectedEdge == null) {
            return retValue;
        }
        Map<URI, Double> edgeValues = null;
        String string = this.selectedEdge;
        if (this.selectedEdge.startsWith("triggered")) {
            String string2 = this.selectedEdge.replaceFirst("triggered", "");
            edgeValues = this.getMigrationEdgeValues(false);
        } else if (this.selectedEdge.startsWith("history")) {
            String string3 = this.selectedEdge.replaceFirst("history", "");
            edgeValues = this.getMigrationEdgeValues(true);
        }
        EMap allEdges = selectedDecorator.getGraph().getEdges();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (URI uri : allEdges.keySet()) {
            void var7_14;
            if (!uri.toString().startsWith((String)var7_14)) continue;
            Edge edge = (Edge)allEdges.get((Object)uri);
            if (edge instanceof PopulationEdge) {
                String popID = ((PopulationEdge)edge).getPopulationIdentifier();
                if (!selectedPopulationIdentifier.equals(popID)) continue;
                edges.add(edge);
                continue;
            }
            edges.add(edge);
        }
        if (edges.isEmpty()) {
            return retValue;
        }
        HashSet<URI> addedEdges = new HashSet<URI>();
        for (Edge nextEdge : edges) {
            Node nodeA = nextEdge.getA();
            Node nodeB = nextEdge.getB();
            if (nodeA == null || nodeB == null) continue;
            String nodeAISOKey = nodeA.getURI().lastSegment();
            String nodeBISOKey = nodeB.getURI().lastSegment();
            double[] centerA = GeographicCenters.getCenter((String)nodeAISOKey);
            double[] centerB = GeographicCenters.getCenter((String)nodeBISOKey);
            if (centerA == null) {
                LatLongProviderAdapter latLongProviderA = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeA, LatLongProvider.class);
                centerA = latLongProviderA.getCenter();
            }
            if (centerB == null) {
                LatLongProviderAdapter latLongProviderB = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeB, LatLongProvider.class);
                centerB = latLongProviderB.getCenter();
            }
            if (centerA == null || centerB == null || addedEdges.contains(nextEdge.getURI())) continue;
            LatLong.Segment edgeSegment = new LatLong.Segment((double[][])new double[][]{centerA, centerB});
            StemPolygon stemPolygon = new StemPolygon(edgeSegment, (Identifiable)nextEdge);
            if (edgeValues == null) {
                stemPolygon.setValueToDisplay(Double.NaN);
                retValue.add(stemPolygon);
                addedEdges.add(nextEdge.getURI());
                continue;
            }
            Double value = edgeValues.get(nextEdge.getURI());
            if (value == null) continue;
            stemPolygon.setValueToDisplay(value);
            retValue.add(stemPolygon);
            addedEdges.add(nextEdge.getURI());
        }
        return retValue;
    }

    private Map<URI, Double> getMigrationNodeValues() {
        EMap edges = this.simulation.getScenario().getCanonicalGraph().getEdges();
        Map<URI, Double> edgeValues = this.getMigrationEdgeValues(true);
        HashMap<URI, Double> nodeValues = new HashMap<URI, Double>();
        for (URI edgeURI : edgeValues.keySet()) {
            double value = edgeValues.get(edgeURI);
            MigrationEdge edge = (MigrationEdge)edges.get((Object)edgeURI);
            URI nodeURI = edge.getNodeBURI();
            Double oldValue = (Double)nodeValues.get(nodeURI);
            if (oldValue == null) {
                nodeValues.put(nodeURI, value);
                continue;
            }
            nodeValues.put(nodeURI, oldValue + value);
        }
        return nodeValues;
    }

    private Map<URI, Double> getMigrationEdgeValues(boolean history) {
        EMap edges = this.simulation.getScenario().getCanonicalGraph().getEdges();
        HashMap<URI, EdgeLabel> edgeLabels = new HashMap<URI, EdgeLabel>();
        HashMap<URI, Double> edgeValues = new HashMap<URI, Double>();
        for (Edge edge : edges.values()) {
            EdgeLabel edgeLabel = edge.getLabel();
            edgeLabels.put(edgeLabel.getURI(), edgeLabel);
        }
        for (Decorator deco : this.simulation.getScenario().getScenarioDecorators()) {
            if (!(deco instanceof TriggerList)) continue;
            TriggerList triggerList = (TriggerList)deco;
            int i = 0;
            while (i < triggerList.getPredicateList().size()) {
                Modifier modifier;
                EdgeLabel label;
                Predicate predicate = (Predicate)triggerList.getPredicateList().get(i);
                Decorator action = (Decorator)triggerList.getActionList().get(i);
                Interval interval = this.getTimeInterval(predicate);
                long time = this.simulation.getScenario().getSequencer().getCurrentTime().getTime().getTime();
                if (interval != null && (!history || time >= interval.startTime) && (history || time >= interval.startTime && time <= interval.endTime) && action instanceof Modifier && (label = (EdgeLabel)edgeLabels.get((modifier = (Modifier)action).getTargetURI())) != null && label instanceof MigrationEdgeLabel) {
                    MigrationEdgeLabel migrationLabel = (MigrationEdgeLabel)label;
                    for (FeatureModifier fm : modifier.getFeatureModifiers()) {
                        if (!fm.getFeatureName().equals("migrationRate")) continue;
                        double value = ((DoubleModifier)fm).getValue();
                        URI edgeURI = migrationLabel.getURIOfIdentifiableToBeLabeled();
                        Double oldValue = (Double)edgeValues.get(edgeURI);
                        if (oldValue == null) {
                            edgeValues.put(edgeURI, value);
                            continue;
                        }
                        edgeValues.put(edgeURI, oldValue + value);
                    }
                }
                ++i;
            }
        }
        return edgeValues;
    }

    private Interval getTimeInterval(Predicate predicate) {
        if (!(predicate instanceof PredicateExpression)) {
            return null;
        }
        Predicate and = ((PredicateExpression)predicate).getPredicate();
        if (!(and instanceof And)) {
            return null;
        }
        EList operands = ((And)and).getOperands();
        if (operands.size() != 2) {
            return null;
        }
        ElapsedTimeTest timeTest1 = null;
        Not not = null;
        if (operands.get(0) instanceof ElapsedTimeTest && operands.get(1) instanceof Not) {
            timeTest1 = (ElapsedTimeTest)operands.get(0);
            not = (Not)operands.get(1);
        } else if (operands.get(1) instanceof ElapsedTimeTest && operands.get(0) instanceof Not) {
            timeTest1 = (ElapsedTimeTest)operands.get(1);
            not = (Not)operands.get(0);
        } else {
            return null;
        }
        if (!(not.getOperand() instanceof ElapsedTimeTest)) {
            return null;
        }
        ElapsedTimeTest timeTest2 = (ElapsedTimeTest)not.getOperand();
        long millis1 = timeTest1.getReferenceTime().getTime().getTime() + (long)timeTest1.getNumberofDays() * STEMTime.Units.DAY.getMilliseconds();
        long millis2 = timeTest2.getReferenceTime().getTime().getTime() + (long)timeTest2.getNumberofDays() * STEMTime.Units.DAY.getMilliseconds();
        return new Interval(millis1, millis2);
    }

    private class Interval {
        public long startTime;
        public long endTime;

        public Interval(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }

    private class PaneChangeListener
    implements Observer {
        GraphMapControl thiss;

        public PaneChangeListener(GraphMapControl ctrl) {
            this.thiss = ctrl;
        }

        @Override
        public void update(Observable o, Object arg) {
            PaneChangeEvent e = (PaneChangeEvent)arg;
            int viewId = GraphMapRegistry.getInstance().getViewId(this.thiss.view);
            GraphMapPreferences prefs = GraphMapPreferences.getInstance();
            prefs.updatePreferenceState(viewId, this.thiss.getSimulation(), "org.eclipse.stem.ui.views.graphmap.translationx", e.getTranformationX());
            prefs.updatePreferenceState(viewId, this.thiss.getSimulation(), "org.eclipse.stem.ui.views.graphmap.translationy", e.getTranformationY());
            prefs.updatePreferenceState(viewId, this.thiss.getSimulation(), "org.eclipse.stem.ui.views.graphmap.scalefactor", e.getScaleFactor());
        }
    }
}

