/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.wizard.template;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.xtext.ui.wizard.template.AbstractProjectTemplate;
import org.eclipse.xtext.ui.wizard.template.IProjectTemplateProvider;
import org.eclipse.xtext.ui.wizard.template.Messages;
import org.eclipse.xtext.ui.wizard.template.TemplateLabelProvider;

@Beta
public class NewProjectWizardTemplateSelectionPage
extends WizardPage {
    private static final String PROJECT_TEMPLATE_PROVIDER_EXTENSION_POINT_ID = "org.eclipse.xtext.ui.projectTemplate";
    private static final String PROJECT_TEMPLATE_PROVIDER_ID = "projectTemplateProvider";
    private static final String PROJECT_TEMPLATE_PROVIDER_GRAMMAR_NAME_ATTRIBUTE = "grammarName";
    private static final String PROJECT_TEMPLATE_PROVIDER_GRAMMAR_CLASS_ATTRIBUTE = "class";
    private static final Logger logger = Logger.getLogger(NewProjectWizardTemplateSelectionPage.class);
    private TemplateLabelProvider labelProvider;
    private AbstractProjectTemplate selectedTemplate;
    private String grammarName;

    public NewProjectWizardTemplateSelectionPage(String pageName, String grammarName, TemplateLabelProvider labelProvider) {
        super(pageName);
        this.grammarName = grammarName;
        this.labelProvider = labelProvider;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        main.setLayout((Layout)new GridLayout(1, false));
        Label availableTemplatesLabel = new Label(main, 0);
        availableTemplatesLabel.setText(Messages.NewProjectWizardTemplateSelectionPage_available_templates);
        availableTemplatesLabel.setLayoutData((Object)new GridData(16384, 4, true, false));
        SashForm sash = new SashForm(main, 256);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 400;
        sash.setLayoutData((Object)data);
        TableViewer templateTable = new TableViewer((Composite)sash, 2048);
        templateTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        templateTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        templateTable.setInput((Object)this.loadTemplatesFromExtensionPoint());
        final FormText text = new FormText((Composite)sash, 2048);
        text.setText("", false, false);
        text.setBackground(templateTable.getTable().getBackground());
        templateTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object element = structuredSelection.getFirstElement();
                    if (element instanceof AbstractProjectTemplate) {
                        NewProjectWizardTemplateSelectionPage.this.selectedTemplate = (AbstractProjectTemplate)element;
                        NewProjectWizardTemplateSelectionPage.this.setPageComplete(true);
                        String content = "<form>" + NewProjectWizardTemplateSelectionPage.this.selectedTemplate.getDescription() + "</form>";
                        try {
                            text.setText(content, true, true);
                        }
                        catch (Exception e) {
                            text.setText(e.getMessage(), false, false);
                        }
                    } else {
                        NewProjectWizardTemplateSelectionPage.this.selectedTemplate = null;
                        text.setText("", false, false);
                        NewProjectWizardTemplateSelectionPage.this.setPageComplete(false);
                    }
                } else {
                    NewProjectWizardTemplateSelectionPage.this.selectedTemplate = null;
                    text.setText("", false, false);
                    NewProjectWizardTemplateSelectionPage.this.setPageComplete(false);
                }
            }
        });
        templateTable.setSelection((ISelection)new StructuredSelection(templateTable.getElementAt(0)));
        this.setControl((Control)main);
    }

    private AbstractProjectTemplate[] loadTemplatesFromExtensionPoint() {
        ArrayList<AbstractProjectTemplate> result = new ArrayList<AbstractProjectTemplate>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(PROJECT_TEMPLATE_PROVIDER_EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (PROJECT_TEMPLATE_PROVIDER_ID.equals(element.getName()) && this.grammarName.equals(element.getAttribute(PROJECT_TEMPLATE_PROVIDER_GRAMMAR_NAME_ATTRIBUTE))) {
                try {
                    IProjectTemplateProvider provider = (IProjectTemplateProvider)element.createExecutableExtension(PROJECT_TEMPLATE_PROVIDER_GRAMMAR_CLASS_ATTRIBUTE);
                    result.addAll(Arrays.asList(provider.getProjectTemplates()));
                }
                catch (CoreException e) {
                    logger.error((Object)("Can not instantiate '" + element.getAttribute(PROJECT_TEMPLATE_PROVIDER_GRAMMAR_CLASS_ATTRIBUTE) + "'"), (Throwable)e);
                }
            }
            ++n2;
        }
        return result.toArray(new AbstractProjectTemplate[0]);
    }

    public AbstractProjectTemplate getSelectedTemplate() {
        return this.selectedTemplate;
    }
}

