/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphgenerators.impl;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.definitions.Activator;
import org.eclipse.stem.definitions.adapters.spatial.geo.InlineLatLongDataProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.edges.EdgesFactory;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabel;
import org.eclipse.stem.definitions.edges.MigrationEdgeLabelValue;
import org.eclipse.stem.definitions.edges.impl.EdgesFactoryImpl;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabel;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.PopulationLabelValue;
import org.eclipse.stem.definitions.labels.impl.CommonBorderRelationshipLabelImpl;
import org.eclipse.stem.definitions.nodes.NodesFactory;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.swt.graphics.Point;

public class PajekNetGraphGeneratorImplOld {
    static double RESCALE = 100000.0;
    private File pajekNETFileURI;
    private double scalingFactor;

    public PajekNetGraphGeneratorImplOld(File pajekNETFileURI, double scalingFactor) {
        this.pajekNETFileURI = pajekNETFileURI;
        this.scalingFactor = scalingFactor;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Graph getGraph() {
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        DublinCore dc = graph.getDublinCore();
        dc.populate();
        dc.setTitle("Pajek Import");
        dc.setSource(this.getClass().getSimpleName());
        Calendar c = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        String valid = formatter.format(c.getTime());
        dc.setValid(valid);
        ArrayList vPopulationListNodes = new ArrayList();
        ArrayList<EdgeContainer> edgeContainerList = new ArrayList<EdgeContainer>();
        Node[] nodeHolder = new Node[]{};
        try {
            Scanner input = new Scanner(this.pajekNETFileURI);
            boolean doNodes = false;
            boolean doEdges = false;
            boolean bl = false;
            Object nodeName = new String[]{};
            while (input.hasNext()) {
                int n;
                String nextLine = input.nextLine();
                StreamTokenizer tok = new StreamTokenizer(new StringReader(nextLine.trim()));
                tok.parseNumbers();
                tok.wordChars(95, 95);
                int ttype = this.getNextToken(tok);
                if (ttype == -3) {
                    if (tok.sval.equalsIgnoreCase("vertices")) {
                        doNodes = true;
                        doEdges = false;
                        ttype = this.getNextToken(tok);
                        if (ttype == -2) {
                            n = (int)tok.nval;
                            nodeHolder = new Node[n];
                            nodeName = new String[n];
                            n = 0;
                            continue;
                        }
                        Activator.logError((String)("Pajek importing " + this.pajekNETFileURI.getName() + ": vertices keyword without valid number of nodes... Not processable!"), null);
                        input.close();
                        return null;
                    }
                    if (tok.sval.equalsIgnoreCase("arcs") || tok.sval.equalsIgnoreCase("arcslist") || tok.sval.equalsIgnoreCase("edges")) {
                        doNodes = false;
                        doEdges = true;
                        continue;
                    }
                    doNodes = false;
                    doEdges = false;
                    continue;
                }
                if (doNodes && ttype == -2) {
                    String parameter;
                    double x = 0.0;
                    double y = 0.0;
                    String shape = "box";
                    double nodeArea = 0.0;
                    LinkedHashMap<String, Double> vPopulation = new LinkedHashMap<String, Double>();
                    String populationIdentifier = "";
                    if (tok.nval != (double)(n + 1)) {
                        Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": usually successive numbering of vertices/nodes... Please check! Exiting!"), null);
                        input.close();
                        return null;
                    }
                    nodeName[n] = "" + (int)tok.nval;
                    ttype = this.getNextToken(tok);
                    if (ttype == -3 || ttype == 34) {
                        nodeName[n] = tok.sval;
                    } else if (ttype == -2) {
                        nodeName[n] = "" + (int)tok.nval;
                    } else {
                        Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": a label for the node/vertex is obligatory... Exiting!"), null);
                        input.close();
                        return null;
                    }
                    ttype = this.getNextToken(tok);
                    if (ttype == -2) {
                        x = tok.nval;
                    }
                    if ((ttype = this.getNextToken(tok)) == -2) {
                        y = tok.nval;
                    }
                    if ((ttype = this.getNextToken(tok)) != -2) {
                        tok.pushBack();
                    }
                    if ((ttype = this.getNextToken(tok)) == -3) {
                        parameter = tok.sval.toLowerCase();
                        if (parameter.equals("ellipse") || parameter.equals("box") || parameter.equals("diamond") || parameter.equals("triangle") || parameter.equals("cross") || parameter.equals("empty")) {
                            shape = parameter;
                        } else {
                            tok.pushBack();
                        }
                    }
                    while (ttype != -1) {
                        ttype = this.getNextToken(tok);
                        if (ttype != -3) continue;
                        parameter = tok.sval.toLowerCase();
                        if (parameter.equals("s_size")) {
                            ttype = this.getNextToken(tok);
                            if (ttype == -2) {
                                nodeArea = tok.nval;
                                continue;
                            }
                            Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": size of node has wrong format... Exiting!"), null);
                            input.close();
                            return null;
                        }
                        if (parameter.equals("bc")) {
                            ttype = this.getNextToken(tok);
                            if (ttype == -3) continue;
                            Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": shapeColor value has wrong format... Exiting!"), null);
                            input.close();
                            return null;
                        }
                        if (parameter.equals("popcount")) {
                            ttype = this.getNextToken(tok);
                            if (ttype == -2) {
                                vPopulation.put(populationIdentifier, tok.nval);
                                continue;
                            }
                            Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": popCount value has wrong format... Exiting!"), null);
                            input.close();
                            return null;
                        }
                        if (parameter.equals("popid")) {
                            ttype = this.getNextToken(tok);
                            if (ttype == -3) {
                                populationIdentifier = tok.sval;
                                continue;
                            }
                            Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": popCount value has wrong format... Exiting!"), null);
                            input.close();
                            return null;
                        }
                        ttype = this.getNextToken(tok);
                    }
                    Region regionNode = this.createRegionNode("PAJNET;" + (String)nodeName[n] + ";", x *= this.scalingFactor, y *= this.scalingFactor, graph);
                    double area = nodeArea * this.scalingFactor * this.scalingFactor;
                    AreaLabel areaLabel = LabelsFactory.eINSTANCE.createAreaLabel();
                    areaLabel.getCurrentAreaValue().setArea(area);
                    regionNode.getLabels().add((Object)areaLabel);
                    LatLong nodeSegments = this.createNodePolygon(x, y, area, shape);
                    String spatialURIString = InlineLatLongDataProvider.createSpatialInlineURIString((LatLong)nodeSegments);
                    regionNode.getDublinCore().setSpatial(spatialURIString);
                    nodeHolder[n] = regionNode;
                    ++n;
                    vPopulationListNodes.add(vPopulation);
                    continue;
                }
                if (doEdges && ttype == -2) {
                    int b = 0;
                    int borderLength = 0;
                    double[] migrationRates = new double[]{0.0, 0.0};
                    String populationIdentifier = "";
                    LinkedHashMap<String, double[]> vPopulation = new LinkedHashMap<String, double[]>();
                    int a = (int)tok.nval;
                    ttype = this.getNextToken(tok);
                    if (ttype != -2) {
                        Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": wrong arcs format. Cannot identify terminal node with initial node " + a + " ... Exiting!"), null);
                        input.close();
                        return null;
                    }
                    b = (int)tok.nval;
                    ttype = this.getNextToken(tok);
                    if (ttype == -2) {
                        borderLength = (int)tok.nval;
                    } else if (ttype != -1) {
                        tok.pushBack();
                    }
                    if (borderLength < 0) {
                        borderLength *= -1;
                    }
                    while (ttype != -1) {
                        ttype = this.getNextToken(tok);
                        if (ttype != -3) continue;
                        String parameter = tok.sval.toLowerCase();
                        if (parameter.equals("c")) {
                            ttype = this.getNextToken(tok);
                            if (ttype == -3) continue;
                            Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": color of edge has wrong format... Exiting!"), null);
                            input.close();
                            return null;
                        }
                        if (parameter.equals("rateab")) {
                            ttype = this.getNextToken(tok);
                            if (ttype == -2) {
                                migrationRates[0] = tok.nval;
                                vPopulation.put(populationIdentifier, migrationRates);
                                continue;
                            }
                            Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": migration rate AB of edge has wrong format... Exiting!"), null);
                            input.close();
                            return null;
                        }
                        if (parameter.equals("rateba")) {
                            ttype = this.getNextToken(tok);
                            if (ttype == -2) {
                                migrationRates[1] = tok.nval;
                                vPopulation.put(populationIdentifier, migrationRates);
                                continue;
                            }
                            Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": migration rate BA of edge has wrong format... Exiting!"), null);
                            input.close();
                            return null;
                        }
                        if (!parameter.equals("popid")) continue;
                        ttype = this.getNextToken(tok);
                        if (ttype == -3) {
                            populationIdentifier = tok.sval;
                            continue;
                        }
                        Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": population identifier of edge has wrong format... Exiting!"), null);
                        input.close();
                        return null;
                    }
                    edgeContainerList.add(new EdgeContainer(a, b, borderLength, vPopulation));
                    continue;
                }
                Activator.logError((String)("Pajek importing: " + this.pajekNETFileURI.getName() + ": very special Pajek format?!? Not processable!"), null);
                input.close();
                return null;
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < nodeHolder.length) {
            Map vPopulation = (Map)vPopulationListNodes.get(i);
            if (vPopulationListNodes.get(i) != null) {
                for (Map.Entry entry : vPopulation.entrySet()) {
                    String populationID = (String)entry.getKey();
                    if (populationID.length() <= 0) continue;
                    double populationCount = (Double)entry.getValue();
                    PopulationLabel newLabel = LabelsFactory.eINSTANCE.createPopulationLabel();
                    newLabel.setPopulationIdentifier(populationID);
                    newLabel.setURIOfIdentifiableToBeLabeled(nodeHolder[i].getURI());
                    newLabel.setNode(nodeHolder[i]);
                    this.initializeLabel(newLabel, populationID, populationCount);
                }
            }
            graph.putNode(nodeHolder[i]);
            ++i;
        }
        for (EdgeContainer edgeContainer : edgeContainerList) {
            int n = edgeContainer.a;
            int b = edgeContainer.b;
            int borderLength = edgeContainer.borderLength;
            LinkedHashMap<String, double[]> vPopulation = edgeContainer.vPopulation;
            if (vPopulation.size() == 0) {
                this.createCommonBorderEdge(graph, nodeHolder[n - 1], nodeHolder[b - 1], borderLength);
                continue;
            }
            for (Map.Entry<String, double[]> entry : vPopulation.entrySet()) {
                String populationID = entry.getKey();
                if (populationID.length() <= 0) continue;
                double[] migrationRates = entry.getValue();
                this.createMigrationEdge(graph, nodeHolder[n - 1], nodeHolder[b - 1], entry.getKey(), migrationRates[0], migrationRates[1]);
            }
        }
        assert (graph.sane());
        return graph;
    }

    private int getNextToken(StreamTokenizer tok) throws IOException {
        int ttype = 0;
        while ((ttype = tok.nextToken()) != -3 && ttype != -2 && ttype != -1 && ttype != 34) {
        }
        return ttype;
    }

    private LatLong createNodePolygon(double x, double y, double area, String shape) {
        LatLong retValue = new LatLong();
        LatLong.SegmentBuilder sb = new LatLong.SegmentBuilder();
        if (shape.toLowerCase().equals("triangle")) {
            double areax2 = Math.sqrt(4.0 * area / Math.sqrt(3.0)) / 2.0;
            double areay = areax2 / Math.sqrt(3.0);
            sb.add(x - areax2, y - areay);
            sb.add(x + areax2, y - areay);
            sb.add(x, y + 2.0 * areay);
            sb.add(x - areax2, y - areay);
        } else if (shape.toLowerCase().equals("cross")) {
            double area2 = Math.sqrt(2.0 * area / Math.sqrt(3.0)) / 2.0;
            sb.add(x + area2, y + area2);
            sb.add(x - area2, y - area2);
            sb.add(x - area2, y + area2);
            sb.add(x + area2, y - area2);
            sb.add(x + area2, y + area2);
        } else if (shape.toLowerCase().equals("ellipse")) {
            double r = Math.sqrt(area / Math.PI);
            int numSegs = 20;
            int i = 0;
            while (i <= numSegs) {
                sb.add(x + r * Math.cos(Math.PI * 2 * (double)i / (double)numSegs), y + r * Math.sin(Math.PI * 2 * (double)i / (double)numSegs));
                ++i;
            }
        } else {
            double area2 = Math.sqrt(area) / 2.0;
            sb.add(x - area2, y - area2);
            sb.add(x - area2, y + area2);
            sb.add(x + area2, y + area2);
            sb.add(x + area2, y - area2);
            sb.add(x - area2, y - area2);
        }
        retValue.add(sb.toSegment());
        return retValue;
    }

    private Region createRegionNode(String uriPrefix, double x, double y, Graph graph) {
        Region node = NodesFactory.eINSTANCE.createRegion();
        DublinCore dc = node.getDublinCore();
        dc.setTitle(this.createNodeTitle(x, y));
        node.setURI(this.createRegionNodeURI(uriPrefix, x, y, graph));
        return node;
    }

    private String createNodeTitle(double x, double y) {
        StringBuilder sb = new StringBuilder("Node[");
        sb.append(String.valueOf((long)(x * 100.0) / 100L));
        sb.append(", ");
        sb.append(String.valueOf((long)(y * 100.0) / 100L));
        sb.append("]");
        return sb.toString();
    }

    private URI createRegionNodeURI(String uriPrefix, double x, double y, Graph graph) {
        String nodeUriSuffix = String.valueOf(uriPrefix) + String.valueOf((long)(x * 100.0) / 100L) + ";" + String.valueOf((long)(y * 100.0) / 100L);
        String nodeUriString = "node/" + graph.getURI().lastSegment() + "/" + nodeUriSuffix;
        URI uri = STEMURI.createURI((String)nodeUriString);
        return uri;
    }

    private void createCommonBorderEdge(Graph graph, Node nodeA, Node nodeB, int borderLength) {
        Edge edge = CommonBorderRelationshipLabelImpl.createCommonBorderRelationship((Node)nodeA, (Node)nodeB, (double)borderLength);
        URI edgeURI = edge.getURI();
        String sEdge = edgeURI.toString();
        int last = sEdge.lastIndexOf("/");
        String sEdge1 = sEdge.substring(0, last);
        String sEdge2 = sEdge.substring(last, sEdge.length());
        sEdge = String.valueOf(sEdge1) + "/relationship/commonborder" + sEdge2;
        URI newURI = URI.createURI((String)sEdge);
        edge.setURI(newURI);
        CommonBorderRelationshipLabel label = (CommonBorderRelationshipLabel)edge.getLabel();
        label.setURI(PajekNetGraphGeneratorImplOld.createEdgeLabelURI(nodeA.getURI(), nodeB.getURI()));
        DublinCore dc = edge.getDublinCore();
        dc.setTitle(this.createEdgeTitle(nodeA, nodeB));
        graph.putEdge(edge);
    }

    private String createEdgeTitle(Node nodeA, Node nodeB) {
        String nA = nodeA.getDublinCore().getTitle();
        String nB = nodeB.getDublinCore().getTitle();
        StringBuilder sb = new StringBuilder("Edge[(");
        sb.append(nA);
        sb.append(")<-->(");
        sb.append(nB);
        sb.append(")]");
        return sb.toString();
    }

    private static URI createEdgeLabelURI(URI uriA, URI uriB) {
        String sA = uriA.lastSegment();
        String sB = uriB.lastSegment();
        sA = sA.replace('_', '.');
        sB = sB.replace('_', '.');
        String uriString = String.valueOf(sA) + "_" + sB;
        URI uri = STEMURI.createURI((String)uriString);
        return uri;
    }

    private void createMigrationEdge(Graph graph, Node nodeA, Node nodeB, String populationIdentifier, double migrationRateAB, double migrationRateBA) {
        URI sourceURI = nodeA.getURI();
        URI targetURI = nodeB.getURI();
        EdgesFactory ef = EdgesFactoryImpl.init();
        MigrationEdge mEdge1 = ef.createMigrationEdge();
        MigrationEdge mEdge2 = ef.createMigrationEdge();
        URI edgeURI1 = mEdge1.getURI();
        String s1 = edgeURI1.toString();
        int last = s1.lastIndexOf("/");
        String sEdge1 = s1.substring(0, last);
        String sEdge2 = s1.substring(last, s1.length());
        s1 = String.valueOf(sEdge1) + "/relationship/migration" + sEdge2;
        URI newURI = URI.createURI((String)s1);
        mEdge1.setURI(newURI);
        URI edgeURI2 = mEdge2.getURI();
        String s2 = edgeURI2.toString();
        int last2 = s2.lastIndexOf("/");
        sEdge1 = s2.substring(0, last2);
        sEdge2 = s2.substring(last, s2.length());
        s2 = String.valueOf(sEdge1) + "/relationship/migration" + sEdge2;
        URI newURI2 = URI.createURI((String)s2);
        mEdge2.setURI(newURI2);
        mEdge1.setNodeAURI(sourceURI);
        mEdge1.setNodeBURI(targetURI);
        mEdge2.setNodeBURI(sourceURI);
        mEdge2.setNodeAURI(targetURI);
        MigrationEdgeLabel label1 = mEdge1.getLabel();
        MigrationEdgeLabel label2 = mEdge2.getLabel();
        label1.setURI(PajekNetGraphGeneratorImplOld.createEdgeLabelURI(sourceURI, targetURI));
        label2.setURI(PajekNetGraphGeneratorImplOld.createEdgeLabelURI(targetURI, sourceURI));
        MigrationEdgeLabelValue melv1 = label1.getCurrentValue();
        melv1.setMigrationRate(migrationRateAB);
        MigrationEdgeLabelValue melv2 = label2.getCurrentValue();
        melv2.setMigrationRate(migrationRateBA);
        DublinCore dc1 = mEdge1.getDublinCore();
        dc1.setTitle(PajekNetGraphGeneratorImplOld.createMigrationEdgeTitle(sourceURI, targetURI));
        DublinCore dc2 = mEdge2.getDublinCore();
        dc2.setTitle(PajekNetGraphGeneratorImplOld.createMigrationEdgeTitle(targetURI, sourceURI));
        mEdge1.setPopulationIdentifier(populationIdentifier);
        mEdge2.setPopulationIdentifier(populationIdentifier);
        graph.putEdge((Edge)mEdge1);
        graph.putEdge((Edge)mEdge2);
    }

    public static String createMigrationEdgeTitle(URI uriA, URI uriB) {
        String sA = uriA.lastSegment();
        String sB = uriB.lastSegment();
        StringBuilder sb = new StringBuilder("MigrationEdge[(");
        sb.append(sA);
        sb.append(")<-->(");
        sb.append(sB);
        sb.append(")]");
        return sb.toString();
    }

    private void initializeLabel(PopulationLabel lab, String populationIdentifier, double populationCount) {
        PopulationLabelValue plv = lab.getCurrentPopulationValue();
        plv.setCount(populationCount);
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        lab.setValidYear(year);
    }

    public boolean containsPoint(double x, double y, LatLong.Segment datapoints) {
        boolean isInside = false;
        double[] points = new double[2 * datapoints.size()];
        int k = 0;
        int pointsIndex = 0;
        while (k < datapoints.size()) {
            points[pointsIndex] = datapoints.latitude(k);
            points[pointsIndex + 1] = datapoints.longitude(k);
            ++k;
            pointsIndex += 2;
        }
        int numOfPoints = points.length / 2;
        int i = 0;
        int j = (numOfPoints - 1) * 2;
        while (i < points.length - 1) {
            if ((points[i + 1] <= y && y < points[j + 1] || points[j + 1] <= y && y < points[i + 1]) && x < (points[j] - points[i]) * (y - points[i + 1]) / (points[j + 1] - points[i + 1]) + points[i]) {
                isInside = !isInside;
            }
            j = i;
            i += 2;
        }
        return isInside;
    }

    public static Set<LatLong> getSpatials(IProject project, URI location) {
        HashMap<String, LatLong> latLongs = new HashMap<String, LatLong>();
        if (project != null) {
            IFolder modelFolder = project.getFolder("models");
            IResource[] models = null;
            try {
                models = modelFolder.members();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (models != null) {
                IResource[] iResourceArray = models;
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    if (!r.getName().startsWith(".")) {
                        try {
                            URI uri = URI.createURI((String)r.getLocationURI().toString());
                            Identifiable id = Utility.getIdentifiable((URI)uri);
                            Graph g = ((Model)id).getCanonicalGraphNoDecorate(STEMURI.createURI((String)""), null, null);
                            if (id instanceof Model) {
                                latLongs.putAll(PajekNetGraphGeneratorImplOld.getGraphSpatials(g, location));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
            IFolder graphsFolder = project.getFolder("graphs");
            IResource[] graphs = null;
            try {
                graphs = graphsFolder.members();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (graphs != null) {
                IResource[] iResourceArray = graphs;
                int n = graphs.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource r = iResourceArray[n3];
                    if (!r.getName().startsWith(".")) {
                        try {
                            URI uri = URI.createURI((String)r.getLocationURI().toString());
                            Identifiable id = Utility.getIdentifiable((URI)uri);
                            if (id instanceof Graph) {
                                latLongs.putAll(PajekNetGraphGeneratorImplOld.getGraphSpatials((Graph)id, location));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n3;
                }
            }
        }
        HashSet<LatLong> retVal = new HashSet<LatLong>();
        retVal.addAll(latLongs.values());
        return retVal;
    }

    private static Map<String, LatLong> getGraphSpatials(Graph g, URI location) {
        HashMap<String, LatLong> latlongs = new HashMap<String, LatLong>();
        for (Node n : g.getNodes().values()) {
            URI uriKey = n.getURI();
            if (location == null || location.toString().trim().equals("") || !uriKey.toString().equals(location.toString())) continue;
            LatLongProvider latLongProvider = (LatLongProvider)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)n, LatLongProvider.class);
            LatLong result = latLongProvider.getLatLong();
            latlongs.put(uriKey.toString(), result);
        }
        return latlongs;
    }

    public static double getArea(Polygon p) {
        double area = 0.0;
        int[] x = p.xpoints;
        int[] y = p.ypoints;
        int i = 0;
        while (i < x.length - 1) {
            area += (double)x[i] * (double)y[i + 1] - (double)x[i + 1] * (double)y[i];
            ++i;
        }
        return (area /= 2.0) > 0.0 ? area : -area;
    }

    public static Point getInteriorCentroid(Polygon p) {
        double maxRange = -1.0;
        double cx = 0.0;
        double cy = 0.0;
        Rectangle r = p.getBounds();
        double STEP = 100.0;
        double deltax = Math.abs((double)r.width);
        double deltay = Math.abs((double)r.height);
        deltax /= 100.0;
        deltay /= 100.0;
        double x = r.getMinX();
        double y = r.getMinY();
        int i = 0;
        while (i <= 100) {
            y = r.getMinY();
            int j = 0;
            while (j <= 100) {
                double range;
                if (p.contains(x, y) && (range = PajekNetGraphGeneratorImplOld.getSqrdEdgeRange(x, y, p)) >= maxRange) {
                    maxRange = range;
                    cx = x;
                    cy = y;
                }
                y += deltay;
                ++j;
            }
            x += deltax;
            ++i;
        }
        x = cx - deltax;
        double y0 = y = cy - deltay;
        deltax /= 100.0;
        deltay /= 100.0;
        int i2 = 0;
        while (i2 <= 200) {
            y = y0;
            int j = 0;
            while (j <= 200) {
                double range;
                if (p.contains(x, y) && (range = PajekNetGraphGeneratorImplOld.getSqrdEdgeRange(x, y, p)) >= maxRange) {
                    maxRange = range;
                    cx = x;
                    cy = y;
                }
                y += deltay;
                ++j;
            }
            x += deltax;
            ++i2;
        }
        int ix = (int)Math.round(cx);
        int iy = (int)Math.round(cy);
        Point center = new Point(ix, iy);
        return center;
    }

    public static double getSqrdEdgeRange(double qx, double qy, Polygon p) {
        double range = Double.MAX_VALUE;
        int[] ix = p.xpoints;
        int[] iy = p.ypoints;
        int i = 0;
        while (i < ix.length) {
            double x = ix[i];
            double dx = qx - x;
            double y = iy[i];
            double dy = qy - y;
            double r = dx * dx + dy * dy;
            if (r <= range) {
                range = r;
            }
            ++i;
        }
        return range;
    }

    public class EdgeContainer {
        int a;
        int b;
        int borderLength;
        LinkedHashMap<String, double[]> vPopulation;

        public EdgeContainer(int a, int b, int borderLength, LinkedHashMap<String, double[]> vPopulation) {
            this.a = a;
            this.b = b;
            this.borderLength = borderLength;
            this.vPopulation = vPopulation;
        }
    }
}

